/*
 * Decompiled with CFR 0.152.
 */
package driftwood.parser;

import driftwood.parser.TokenMatcher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexTokenMatcher
implements TokenMatcher {
    public static final Pattern WHITESPACE = Pattern.compile("(?:\\s+)");
    public static final Pattern NON_WHITESPACE = Pattern.compile("(?:\\S+)");
    public static final Pattern SIGNED_INT;
    public static final Pattern UNSIGNED_INT;
    public static final Pattern SIGNED_REAL;
    public static final Pattern UNSIGNED_REAL;
    public static final Pattern JAVA_WORD;
    public static final Pattern JAVA_PUNC;
    public static final Pattern SINGLE_QUOTED_STRING;
    public static final Pattern DOUBLE_QUOTED_STRING;
    public static final Pattern SLASH_QUOTED_STRING;
    public static final Pattern HASH_COMMENT;
    public static final Pattern DOUBLE_SLASH_COMMENT;
    public static final Pattern SLASH_STAR_COMMENT;
    Matcher accept;
    Matcher ignore;
    String theToken = null;
    int tokenEnd = 0;

    public RegexTokenMatcher(Pattern pattern, Pattern pattern2) {
        this.accept = pattern.matcher("");
        this.ignore = pattern2.matcher("");
    }

    public RegexTokenMatcher(String string, String string2) {
        this(Pattern.compile(string), Pattern.compile(string2));
    }

    public RegexTokenMatcher(Matcher matcher, Matcher matcher2) {
        this(matcher.pattern(), matcher2.pattern());
    }

    public boolean match(CharSequence charSequence, int n) {
        this.ignore.reset(charSequence);
        int n2 = n;
        int n3 = charSequence.length();
        while (n2 < n3) {
            this.ignore.region(n2, n3);
            if (!this.ignore.lookingAt()) break;
            n2 = this.ignore.end();
        }
        this.accept.reset(charSequence);
        this.accept.region(n2, n3);
        if (this.accept.lookingAt()) {
            this.theToken = this.normalize(this.accept.group());
            this.tokenEnd = this.accept.end();
            return true;
        }
        this.theToken = null;
        this.tokenEnd = n2;
        return n2 > n && n2 == n3;
    }

    public int end() {
        return this.tokenEnd;
    }

    public String token() {
        return this.theToken;
    }

    public String normalize(String string) {
        return string;
    }

    public static Pattern joinPatterns(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append('|');
            }
            stringBuffer.append("(?:");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(')');
        }
        return Pattern.compile(stringBuffer.toString());
    }

    public static Pattern joinPatterns(Pattern[] patternArray) {
        String[] stringArray = new String[patternArray.length];
        for (int i = 0; i < patternArray.length; ++i) {
            stringArray[i] = patternArray[i].pattern();
        }
        return RegexTokenMatcher.joinPatterns(stringArray);
    }

    public static Pattern joinPatterns(Matcher[] matcherArray) {
        String[] stringArray = new String[matcherArray.length];
        for (int i = 0; i < matcherArray.length; ++i) {
            stringArray[i] = matcherArray[i].pattern().pattern();
        }
        return RegexTokenMatcher.joinPatterns(stringArray);
    }

    public static Pattern recursivePattern(String string, String string2, String string3, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("(?:").append(string).append(")(?:(?:").append(string2).append(")|(?:");
        }
        stringBuffer.append(string2);
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("))+(?:").append(string3).append(")");
        }
        return Pattern.compile(stringBuffer.toString());
    }

    public static Pattern recursivePattern(Pattern pattern, Pattern pattern2, Pattern pattern3, int n) {
        return RegexTokenMatcher.recursivePattern(pattern.pattern(), pattern2.pattern(), pattern3.pattern(), n);
    }

    public static Pattern recursivePattern(Matcher matcher, Matcher matcher2, Matcher matcher3, int n) {
        return RegexTokenMatcher.recursivePattern(matcher.pattern().pattern(), matcher2.pattern().pattern(), matcher3.pattern().pattern(), n);
    }

    public static void main(String[] stringArray) {
        RegexTokenMatcher regexTokenMatcher = new RegexTokenMatcher(RegexTokenMatcher.recursivePattern("<", "[a-zA-Z .]*", ">", 3), WHITESPACE);
        String string = "<foo>   <Fred approached.  <<Hi there>> said Bob.>";
        System.out.println(string);
        int n = 0;
        while (n < string.length()) {
            if (!regexTokenMatcher.match(string, n)) {
                System.out.println("*** Syntax error at " + n);
                break;
            }
            System.out.println("> " + regexTokenMatcher.token());
            n = regexTokenMatcher.end();
        }
    }

    static {
        String string = "(?:[+-]?)";
        String string2 = "(?:[0-9]+)";
        String string3 = "(?:[1-9][0-9]*)";
        String string4 = "(?:0|" + string3 + ")";
        String string5 = "(?:" + string + string4 + ")";
        String string6 = "(?:" + string4 + "(?:\\.(?:" + string2 + ")?)?)";
        String string7 = "(?:" + string6 + "(?:[eE]" + string5 + ")?)";
        String string8 = "(?:" + string + string7 + ")";
        SIGNED_INT = Pattern.compile(string5);
        UNSIGNED_INT = Pattern.compile(string4);
        SIGNED_REAL = Pattern.compile(string8);
        UNSIGNED_REAL = Pattern.compile(string7);
        JAVA_WORD = Pattern.compile("(?:[a-zA-Z_][a-zA-Z_0-9]*)");
        JAVA_PUNC = Pattern.compile("(?:[~!%^&|*/<>.=+-]=?|[,;:?(){}\\[\\]]|&&|\\|\\||<<=?|>>=?|>>>=?|\\+\\+|--)");
        SINGLE_QUOTED_STRING = Pattern.compile("(?s:'(?:[^'\\\\]|\\\\.)*')");
        DOUBLE_QUOTED_STRING = Pattern.compile(SINGLE_QUOTED_STRING.pattern().replace('\'', '\"'));
        SLASH_QUOTED_STRING = Pattern.compile(SINGLE_QUOTED_STRING.pattern().replace('\'', '/'));
        HASH_COMMENT = Pattern.compile("(?:#.*)");
        DOUBLE_SLASH_COMMENT = Pattern.compile("(?://.*)");
        SLASH_STAR_COMMENT = Pattern.compile("(?s:/\\*.*?\\*/)");
    }
}

