/*
* tip.cpp
*/

#include "tip.h"
#include "board.h"
#include "qgo.h"

/*
* Tip
*/

Tip::Tip(QWidget *parent)
: QToolTip(parent)
{
}

Tip::~Tip()
{
}

void Tip::maybeTip(const QPoint &pos)
{
	if (!setting->readBoolEntry("BOARD_COORDS_TIP"))
		return;
	
	int x = ((Board*)parentWidget())->getCurrentX(),
		y = ((Board*)parentWidget())->getCurrentY();
	
	if (x == -1 || y == -1)
		return;
	
	tip(QRect(pos.x(), pos.y(), 1, 1),
		QString(QChar(static_cast<const char>('A' + (x<9?x:x+1) - 1))) +       // A -> T (skip I)
		" " + QString::number(((Board*)parentWidget())->getBoardSize()-y+1));  // 19 -> 1
}


/*
* StatusTip
*/

StatusTip::StatusTip(QWidget *parent)
: QLabel(parent)
{
	setAlignment(AlignCenter | SingleLine);
}

StatusTip::~StatusTip()
{
}

void StatusTip::slotStatusTipCoords(int x, int y, int board_size)
{
	emit clearStatusBar();
	
	setText(" " + QString(QChar(static_cast<const char>('A' + (x<9?x:x+1) - 1))) +       // A -> T (skip I)
		" " + QString::number(board_size-y+1) + " ");                                // 19 -> 1
}
