/*
 * telnet.h
 */

#ifndef TELNET_H
#define TELNET_H

#include <qobject.h>

class IGSInterface;

//-----------

class TelnetInterface : public QObject
{
	Q_OBJECT

public:
	TelnetInterface();
	~TelnetInterface();
	static void callback(const char *s, uint i=0);

signals:
	void textRecieved(const QString&);
};

//-----------

class TelnetConnection : public QObject
{
	Q_OBJECT

public:
	TelnetConnection(QWidget* parent);
	~TelnetConnection();

	void sendTextFromApp(const QString&);
	void setHost(const QString, const QString, const QString, unsigned int);

public slots:
	void slotHostConnect();
	void slotHostDisconnect();
	void slotHostQuit();

private:
	QString host, loginName, password;
	unsigned int port;

	IGSInterface *igsInterface;
};
 
#endif

