/*
* stone.cpp
*/

#include "stone.h"
#include "imagehandler.h"
#include <stdlib.h>

Stone::Stone(QCanvasPixmapArray *a, QCanvas *canvas, StoneColor c, int x, int y, int numberOfImages)
: QCanvasSprite(a, canvas), color(c), myX(x), myY(y)
{
	setFrame(color == stoneBlack ? 0 : (rand() % numberOfImages) + 1);
	
	setZ(5);
	show();
	
	dead = false;
	seki = false;
	checked = false;
}

void Stone::setColor(StoneColor c)
{
	setFrame(c == stoneBlack ? 0 : (rand() % 8) + 1);
	color = c;
}

void Stone::toggleOneColorGo(bool oneColor)
{
  // if we play one color go, the black stones are repainted white, else normal black
  if (color ==  stoneBlack)
    setFrame(oneColor ? (rand() % 8) + 1 : 0);
}

