/*
 * STQGLExampleObjects.cpp
 * $Id:
 *
 * Copyright (C) 2001 Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Definition of example nodes


    
// Own
////////
#include "STQGLExampleObjects.h"



// Function   : draw
// Parameters :
// Purpose    : draws the sphere
// Comments   :
void STQGLExampleWiredSphere::draw()
/******************************************************************/
{
  GLUquadricObj  *quadObj;
  int sphere_slices = m_n1;
  int sphere_stacks = m_n2;

  if (m_ViewingMode != hidden) {
    CP3D LowerLeft, UpperRight;
    switch (m_ViewingMode) {
    case boxed:
      // Determine bounding box
      ///////////////////////////
      LowerLeft = getBoundingBox().getLowerLeft();
      UpperRight = getBoundingBox().getUpperRight();

      // Draw box
      /////////////
      glPushAttrib(GL_LIGHTING);
      glDisable(GL_LIGHTING);
      glLineWidth(1.5);
      glColor3f(1.0, 1.0, 1.0);

      glBegin(GL_LINE_LOOP);
      glVertex3f(LowerLeft[0],  LowerLeft[1],  LowerLeft[2]);
      glVertex3f(UpperRight[0], LowerLeft[1],  LowerLeft[2]);
      glVertex3f(UpperRight[0], UpperRight[1], LowerLeft[2]);
      glVertex3f(LowerLeft[0],  UpperRight[1], LowerLeft[2]);
      glEnd();

      glBegin(GL_LINE_LOOP);
      glVertex3f(LowerLeft[0],  LowerLeft[1],  UpperRight[2]);
      glVertex3f(UpperRight[0], LowerLeft[1],  UpperRight[2]);
      glVertex3f(UpperRight[0], UpperRight[1], UpperRight[2]);
      glVertex3f(LowerLeft[0],  UpperRight[1], UpperRight[2]);
      glEnd();

      glBegin(GL_LINES);
      glVertex3f(LowerLeft[0],  LowerLeft[1],  LowerLeft[2]);
      glVertex3f(LowerLeft[0],  LowerLeft[1],  UpperRight[2]);
      glEnd();

      glBegin(GL_LINES);
      glVertex3f(UpperRight[0], LowerLeft[1],  LowerLeft[2]);
      glVertex3f(UpperRight[0], LowerLeft[1],  UpperRight[2]);
      glEnd();

      glBegin(GL_LINES);
      glVertex3f(UpperRight[0], UpperRight[1], LowerLeft[2]);
      glVertex3f(UpperRight[0], UpperRight[1], UpperRight[2]);
      glEnd();
  
      glBegin(GL_LINES);
      glVertex3f(LowerLeft[0],  UpperRight[1], LowerLeft[2]);
      glVertex3f(LowerLeft[0],  UpperRight[1], UpperRight[2]);
      glEnd();

      glPopAttrib();
      break;
    case highlighted:
      glColor3f(1.0, 1.0, 1.0);
      break;
    case normal:
      glColor3f(m_red, m_green, m_blue);
      break;
    case disabled:
      glColor3f(m_red, m_green, m_blue);
      glLineStipple(1,0xAAAA);
      glEnable(GL_LINE_STIPPLE);
      break;
    }

    if (m_ViewingMode == highlighted ||
	m_ViewingMode == normal ||
	m_ViewingMode == disabled) {
      glLineWidth(m_lw);
      glEnable(GL_COLOR_MATERIAL);
      quadObj = gluNewQuadric ();
      gluQuadricDrawStyle (quadObj, (GLenum)GLU_LINE);
      gluQuadricOrientation(quadObj, (GLenum)GLU_OUTSIDE);
      gluQuadricNormals (quadObj, (GLenum)GLU_SMOOTH);
      gluSphere (quadObj, m_radius, sphere_slices, sphere_stacks);
      gluDeleteQuadric(quadObj);

      glDisable(GL_COLOR_MATERIAL);
      glDisable(GL_LINE_STIPPLE);
    }
  }

  return;
}



// Function   : draw
// Parameters :
// Purpose    : draws the sphere
// Comments   :
void STQGLExampleSolidSphere::draw()
/******************************************************************/
{
  GLUquadricObj  *quadObj;
  int sphere_slices = m_n1;
  int sphere_stacks = m_n2;

  if (m_ViewingMode != hidden) {
    CP3D LowerLeft, UpperRight;
    switch (m_ViewingMode) {
    case boxed:
      // Determine bounding box
      ///////////////////////////
      LowerLeft = getBoundingBox().getLowerLeft();
      UpperRight = getBoundingBox().getUpperRight();

      // Draw box
      /////////////
      glPushAttrib(GL_LIGHTING);
      glDisable(GL_LIGHTING);
      glLineWidth(1.5);
      glColor3f(1.0, 1.0, 1.0);

      glBegin(GL_LINE_LOOP);
      glVertex3f(LowerLeft[0],  LowerLeft[1],  LowerLeft[2]);
      glVertex3f(UpperRight[0], LowerLeft[1],  LowerLeft[2]);
      glVertex3f(UpperRight[0], UpperRight[1], LowerLeft[2]);
      glVertex3f(LowerLeft[0],  UpperRight[1], LowerLeft[2]);
      glEnd();

      glBegin(GL_LINE_LOOP);
      glVertex3f(LowerLeft[0],  LowerLeft[1],  UpperRight[2]);
      glVertex3f(UpperRight[0], LowerLeft[1],  UpperRight[2]);
      glVertex3f(UpperRight[0], UpperRight[1], UpperRight[2]);
      glVertex3f(LowerLeft[0],  UpperRight[1], UpperRight[2]);
      glEnd();

      glBegin(GL_LINES);
      glVertex3f(LowerLeft[0],  LowerLeft[1],  LowerLeft[2]);
      glVertex3f(LowerLeft[0],  LowerLeft[1],  UpperRight[2]);
      glEnd();

      glBegin(GL_LINES);
      glVertex3f(UpperRight[0], LowerLeft[1],  LowerLeft[2]);
      glVertex3f(UpperRight[0], LowerLeft[1],  UpperRight[2]);
      glEnd();

      glBegin(GL_LINES);
      glVertex3f(UpperRight[0], UpperRight[1], LowerLeft[2]);
      glVertex3f(UpperRight[0], UpperRight[1], UpperRight[2]);
      glEnd();
  
      glBegin(GL_LINES);
      glVertex3f(LowerLeft[0],  UpperRight[1], LowerLeft[2]);
      glVertex3f(LowerLeft[0],  UpperRight[1], UpperRight[2]);
      glEnd();

      glPopAttrib();
      break;
    case highlighted:
      glColor3f(1.0, 1.0, 1.0);
      break;
    case normal:
      glColor3f(m_red, m_green, m_blue);
      break;
    case disabled:
      glColor3f(m_red, m_green, m_blue);
      glPolygonStipple(m_anMask);
      glEnable(GL_POLYGON_STIPPLE);
      break;
    }
    if (m_ViewingMode == highlighted ||
	m_ViewingMode == normal ||
	m_ViewingMode == disabled) {
      glEnable(GL_COLOR_MATERIAL);
      quadObj = gluNewQuadric ();
      gluQuadricDrawStyle (quadObj, (GLenum)GLU_FILL);
      gluQuadricOrientation(quadObj, (GLenum)GLU_OUTSIDE);
      gluQuadricNormals (quadObj, (GLenum)GLU_SMOOTH);
      gluSphere (quadObj, m_radius, sphere_slices, sphere_stacks);
      gluDeleteQuadric(quadObj);

      glDisable(GL_COLOR_MATERIAL);
      glDisable(GL_POLYGON_STIPPLE);
    }
  }

  return;
}



// Function   : draw
// Parameters :
// Purpose    : "draws" the node
// Comments   :
void STQGLExampleInitNode::draw()
/******************************************************************/
{
  float		mat_specular[] = { .72, .8, .93, 1.0 };

  // render bounding box
  /////////////////////////
  glDepthFunc(GL_LEQUAL);
  glEnable(GL_DEPTH_TEST);

  glEnable(GL_LINE_SMOOTH);
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glLineWidth(1.5);

  glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
  glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, 128.0);
  
  glEnable(GL_NORMALIZE);
}
