# -*- coding: utf-8 -*-

"""
***************************************************************************
    las2dem.py
    ---------------------
    Date                 : August 2012
    Copyright            : (C) 2012 by Victor Olaya
    Email                : volayaf at gmail dot com
    ---------------------
    Date                 : September 2013
    Copyright            : (C) 2013 by Martin Isenburg
    Email                : martin near rapidlasso point com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Victor Olaya'
__date__ = 'August 2012'
__copyright__ = '(C) 2012, Victor Olaya'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
from PyQt4 import QtGui

from processing.lidar.lastools.LAStoolsUtils import LAStoolsUtils
from processing.lidar.lastools.LAStoolsAlgorithm import LAStoolsAlgorithm

from processing.parameters.ParameterString import ParameterString
from processing.parameters.ParameterBoolean import ParameterBoolean
from processing.parameters.ParameterSelection import ParameterSelection


class las2dem(LAStoolsAlgorithm):

    ATTRIBUTE = 'ATTRIBUTE'
    PRODUCT = 'PRODUCT'
    ATTRIBUTES = ['elevation', 'slope', 'intensity', 'rgb']
    PRODUCTS = ['actual values', 'hillshade', 'gray', 'false']

    def defineCharacteristics(self):
        self.name = 'las2dem'
        self.group = 'LAStools'
        self.addParametersVerboseGUI()
        self.addParametersPointInputGUI()
        self.addParametersFilter1ReturnClassFlagsGUI()
        self.addParametersStepGUI()
        self.addParameter(ParameterSelection(las2dem.ATTRIBUTE, 'Attribute',
                          las2dem.ATTRIBUTES, 0))
        self.addParameter(ParameterSelection(las2dem.PRODUCT, 'Product',
                          las2dem.PRODUCTS, 0))
        self.addParametersRasterOutputGUI()

    def processAlgorithm(self, progress):
        commands = [os.path.join(LAStoolsUtils.LAStoolsPath(), 'bin',
                    'las2dem.exe')]
        self.addParametersVerboseCommands(commands)
        self.addParametersPointInputCommands(commands)
        self.addParametersFilter1ReturnClassFlagsCommands(commands)
        self.addParametersStepCommands(commands)
        attribute = self.getParameterValue(las2dem.ATTRIBUTE)
        if attribute != 0:
            commands.append('-' + las2dem.ATTRIBUTES[attribute])
        product = self.getParameterValue(las2dem.PRODUCT)
        if product != 0:
            commands.append('-' + las2dem.PRODUCTS[product])
        self.addParametersRasterOutputCommands(commands)

        LAStoolsUtils.runLAStools(commands, progress)
