/***************************************************************************
    qgsvectordataprovider.cpp - DataProvider Interface for vector layers
     --------------------------------------
    Date                 : 26-Oct-2004
    Copyright            : (C) 2004 by Marco Hugentobler
    email                : marco.hugentobler@autoform.ch
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* $Id: qgsvectordataprovider.cpp 5595 2006-07-14 03:11:25Z morb_au $ */

#include "qgsvectordataprovider.h"
#include "qgsfeature.h"
#include "qgsfield.h"
#include "qgssearchtreenode.h"

QgsVectorDataProvider::QgsVectorDataProvider()
    : mEncoding(QTextCodec::codecForLocale())
{
}

QgsVectorDataProvider::QgsVectorDataProvider( QString const & uri )
    : QgsDataProvider(uri),
      mEncoding(QTextCodec::codecForLocale())
{
}


bool QgsVectorDataProvider::addFeatures(std::list<QgsFeature*> flist)
{
  return false;
}

bool QgsVectorDataProvider::deleteFeatures(std::list<int> const & id)
{
  return false;
}

bool QgsVectorDataProvider::addAttributes(std::map<QString,QString> const & name)
{
  return false;
}

bool QgsVectorDataProvider::deleteAttributes(std::set<QString> const & name)
{
  return false;
}

bool QgsVectorDataProvider::changeAttributeValues(std::map<int,std::map<QString,QString> > const & attr_map)
{
  return false;
}

QString QgsVectorDataProvider::getDefaultValue(const QString& attr, 
    QgsFeature* f) {
  return "";
}

bool QgsVectorDataProvider::changeGeometryValues(std::map<int, QgsGeometry> & geometry_map)
{
  return false;
}

bool QgsVectorDataProvider::createSpatialIndex()
{
    return false;
}

void QgsVectorDataProvider::setEncoding(const QString& e)
{
    QTextCodec* ncodec=QTextCodec::codecForName(e.toLocal8Bit().data());
    if(ncodec)
    {
	mEncoding=ncodec;
    }
    else
    {
#ifdef QGISDEBUG
	qWarning("error finding QTextCodec in QgsVectorDataProvider::setEncoding");
#endif
    }
}

QString QgsVectorDataProvider::encoding() const
{
    if(mEncoding)
    {
	return mEncoding->name();
    }
    else
    {
	return "";
    }
}

QString QgsVectorDataProvider::capabilitiesString() const
{
  QStringList abilitiesList;

  int abilities = capabilities();

  if (abilities & QgsVectorDataProvider::AddFeatures)
  {
    abilitiesList += "Add Features";
#ifdef QGISDEBUG
        std::cerr << "QgsVectorDataProvider::capabilitiesString "
          << "Add Features" << std::endl;
#endif

  }

  if (abilities & QgsVectorDataProvider::DeleteFeatures)
  {
    abilitiesList += "Delete Features";
#ifdef QGISDEBUG
        std::cerr << "QgsVectorDataProvider::capabilitiesString "
          << "Delete Features" << std::endl;
#endif
  }

  if (abilities & QgsVectorDataProvider::ChangeAttributeValues)
  {
    abilitiesList += "Change Attribute Values";
#ifdef QGISDEBUG
        std::cerr << "QgsVectorDataProvider::capabilitiesString "
          << "Change Attribute Values" << std::endl;
#endif
  }

  if (abilities & QgsVectorDataProvider::AddAttributes)
  {
    abilitiesList += "Add Attributes";
#ifdef QGISDEBUG
        std::cerr << "QgsVectorDataProvider::capabilitiesString "
          << "Add Attributes" << std::endl;
#endif
  }

  if (abilities & QgsVectorDataProvider::DeleteAttributes)
  {
    abilitiesList += "Delete Attributes";
#ifdef QGISDEBUG
        std::cerr << "QgsVectorDataProvider::capabilitiesString "
          << "Delete Attributes" << std::endl;
#endif
  }

  if (abilities & QgsVectorDataProvider::SaveAsShapefile)
  {
    abilitiesList += "Save As Shapefile";
#ifdef QGISDEBUG
        std::cerr << "QgsVectorDataProvider::capabilitiesString "
          << "Save As Shapefile" << std::endl;
#endif
  }

  if (abilities & QgsVectorDataProvider::CreateSpatialIndex)
  {
    // TODO: Tighten up this test.  See QgsOgrProvider for details.
    abilitiesList += "Create Spatial Index";
#ifdef QGISDEBUG
        std::cerr << "QgsVectorDataProvider::capabilitiesString "
          << "Create Spatial Index" << std::endl;
#endif
  }

  if (abilities & QgsVectorDataProvider::SelectAtId)
  {
    // Not really meaningful to the user.
    // abilitiesList += "Select at ID";
#ifdef QGISDEBUG
        std::cerr << "QgsVectorDataProvider::capabilitiesString "
          << "Select at ID" << std::endl;
#endif
  }

  if (abilities & QgsVectorDataProvider::ChangeGeometries)
  {
    abilitiesList += "Change Geometries";
#ifdef QGISDEBUG
        std::cerr << "QgsVectorDataProvider::capabilitiesString "
          << "Change Geometries" << std::endl;
#endif
  }

  if (abilities & QgsVectorDataProvider::SelectGeometryAtId)
  {

    if (abilities & QgsVectorDataProvider::RandomSelectGeometryAtId)
    {
      abilitiesList += "Select Geometries by ID (random access)";
#ifdef QGISDEBUG
          std::cerr << "QgsVectorDataProvider::capabilitiesString "
            << "Select Geometries by ID (random access)" << std::endl;
#endif
    }
    else if (abilities & QgsVectorDataProvider::SequentialSelectGeometryAtId)
    {
      abilitiesList += "Select Geometries by ID (sequential access)";
#ifdef QGISDEBUG
          std::cerr << "QgsVectorDataProvider::capabilitiesString "
            << "Select Geometries by ID (sequential access)" << std::endl;
#endif
    }
    else
    {
      abilitiesList += "Select Geometries by ID (unknown access method)";
#ifdef QGISDEBUG
          std::cerr << "QgsVectorDataProvider::capabilitiesString "
            << "Select Geometries by ID (unknown access method)" << std::endl;
#endif
    }
  }

  return abilitiesList.join(", ");

}

bool QgsVectorDataProvider::setAttributeFilter(const QgsSearchString& attributeFilter)
{
  mAttributeFilter = attributeFilter;
  // TODO: maybe check if all referenced columns are there, return false if not
  return true;
}

int QgsVectorDataProvider::indexFromFieldName(const QString& fieldName) const
{
  const std::vector<QgsField> theFields = fields();
  int counter = 0;

  for(std::vector<QgsField>::const_iterator it = theFields.begin(); it != theFields.end(); ++it)
    {
      if(it->name() == fieldName)
	{
	  return counter;
	}
      ++counter;
    }
  return -1;
}
