/***************************************************************************
                          splashscreen.cpp  -  description
                             -------------------
    begin                : Sat May 17 2003
    copyright            : (C) 2003 by Tim Sutton
    email                : tim@linfiniti.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    Based on an example provided by Trolltech                                                                     *
 ***************************************************************************/
/* $Id: splashscreen.cpp,v 1.19 2005/05/22 10:51:36 timlinux Exp $ */
#include <qapplication.h>
#include <qpainter.h>
#include <qpixmap.h>
#include "splashscreen.h"
#include "qfont.h"
#include "qgis.h"
#include "qbitmap.h"
#if defined(WIN32) || defined(Q_OS_MACX)
QString PKGDATAPATH = qApp->applicationDirPath() + "/share/qgis";
#endif
#define STATUS_TEXT_X 90
#define STATUS_TEXT_Y 30
SplashScreen::SplashScreen():QWidget(0, 0, WStyle_Customize | WStyle_Splash)
{
  //set up masking
  splashImage.load(QString(PKGDATAPATH) + QString("/images/splash/splash.png"), 0, Qt::ThresholdDither |   Qt::AvoidDither );
  resize(splashImage.size());
  //
  // NOTES! the mask must be a 1 BIT IMAGE or it wont work!
  //
  QPixmap myMaskPixmap( 564, 300, -1, QPixmap::BestOptim );  
  myMaskPixmap.load( QString(PKGDATAPATH) + QString("/images/splash/splash_mask.png"), 0, Qt::ThresholdDither |   Qt::ThresholdAlphaDither | Qt::AvoidDither );
  setBackgroundPixmap(splashImage);
  setMask( myMaskPixmap.createHeuristicMask() );


  setErasePixmap(splashImage);
  
  QRect scr = QApplication::desktop()->screenGeometry();
  move(scr.center() - rect().center());

  QPainter painter(&splashImage);
  painter.setPen(Qt::black);
  QFont myQFont("arial", 18, QFont::Bold);
  painter.setFont(myQFont);

  QString myCaption = tr("Version ");
  // myCaption += QString("%1 ('%2')").arg(QGis::qgisVersion).arg(QGis::qgisReleaseName);
  myCaption += QString("%1").arg(QGis::qgisVersion);

  painter.drawText(150, 240, myCaption);
  repaint();

  show();
}

void SplashScreen::repaint()
{
  QWidget::repaint();
  QApplication::flush();
}

#if defined(Q_WS_X11)
void qt_wait_for_window_manager(QWidget * widget);
#endif

void SplashScreen::finish(QWidget * mainWin)
{
#if defined(Q_WS_X11)
  qt_wait_for_window_manager(mainWin);
#endif
  close();
}

void SplashScreen::mousePressEvent(QMouseEvent *)
{
  hide();
}

void SplashScreen::setStatus(const QString & message, int alignment, const QColor & color)
{
  QPixmap textPix = splashImage;
  QPainter painter(&textPix, this);
  painter.setPen(color);
  QFont myQFont("arial", 10, QFont::Bold);
  painter.setFont(myQFont);
  painter.drawText(STATUS_TEXT_X, textPix.height() - STATUS_TEXT_Y, message);
  setErasePixmap(textPix);
  repaint();
}
