/***************************************************************************
                         rprojectview.cpp  -  description
                             -------------------
    begin                : Sun Sep 12 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rlistview.h"

#include <qpixmap.h>
#include <qevent.h>
#include <qheader.h>
#include <qpoint.h>
#include <qmessagebox.h>
#include <qdragobject.h>
#include <qmime.h>
#include <qstrlist.h>

#include "xpm/folderclosed.xpm"
#include "xpm/folderopen.xpm"


/**
 * \class RListViewItem
 *  An Item in a project view. Can contain Projects, Pages and Paragraphs.
 */

/**
 * Constructor for sub-items (pages, paragraphs)
 */
RListViewItem::RListViewItem( RListViewItem* _parent,
                              const QString& _label,
                              bool _open,
                              int _id )
  : QListViewItem( _parent )
{
  p = _parent;
  label = _label;
  id = _id;

  setPixmap( 0, QPixmap( (_open ? folderopen_xpm : folderclosed_xpm) ) );

  setOpen( _open );
}


/**
 * Constructor for root items (Projects).
 */
RListViewItem::RListViewItem( QListView * _parent,
                              const QString& _label,
                              bool _open,
                              int _id )
  : QListViewItem( _parent )
{
  p = 0;
  label = _label;
  id = _id;

  setPixmap( 0, QPixmap( (_open ? folderopen_xpm : folderclosed_xpm) ) );

  setOpen( _open );
}



/**
 * Opens or closes the item.
 */
void
RListViewItem::setOpen( bool o )
{
  if( o ) setPixmap( 0, QPixmap( folderopen_xpm ) );
  else    setPixmap( 0, QPixmap( folderclosed_xpm ) );

  QListViewItem::setOpen( o );
}


/**
 * Called in the beginning.
 */
void
RListViewItem::setup()
{
  QListViewItem::setup();
}


/**
 * Returns the "path" of this item (like: "Project/Page1/Paragraph1/").
 */
QString
RListViewItem::getFullPath()
{
  QString s;
  if( p ) {
    s = p->getFullPath();
    s.append( text(0) );
    s.append( "/" );
  }
  else {
    s = text(0);
    s.append( "/" );
  }
  return s;
}


/**
 * Returns the text of the given column of this item.
 */
QString
RListViewItem::text( int column ) const
{
  if ( column==0 )
    return label;
  else
    return "Column1";
}






/**
 * \class RListView
 * This class implements a three view used for projects. The view shows
 *   folders, documents and the paragraphs in the documents.
 */

/**
 * Constructor.
 */
RListView::RListView( QWidget *_parent, const char *_name )
  : QListView( _parent, _name )
{
  connect( this, SIGNAL( doubleClicked( QListViewItem * ) ),
           this, SLOT( slotFolderSelected( QListViewItem * ) ) );
  connect( this, SIGNAL( returnPressed( QListViewItem * ) ),
           this, SLOT( slotFolderSelected( QListViewItem * ) ) );
}



/**
 * Called on selection of an item.
 */
void
RListView::slotFolderSelected( QListViewItem *i )
{
  if( !i ) return;

  RListViewItem *item = (RListViewItem*)i;
  emit folderSelected( item->getLabel() );
}


/**
 * Returns the full path of the given item.
 */
QString
RListView::fullPath( QListViewItem* item )
{
  QString fullpath = item->text(0);
  while ( (item=item->parent()) ) {
    if( item->parent() )
      fullpath = item->text(0) + "/" + fullpath;
    else
      fullpath = item->text(0) + fullpath;
  }
  return fullpath;
}


QSize
RListView::minimumSizeHint()
const
{
  return QSize(0,0);
}

// EOF







