/****************************************************************************
** $Id: rhelpwindow.cpp,v 1.3 2002/07/31 22:53:07 andrew23 Exp $
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
** Modified (Simplified) by RibbonSoft, Andrew Mustun, 2000
**
*****************************************************************************/

#include "rhelpwindow.h"
#include <qtoolbutton.h>
#include <qtoolbar.h>
#include <qstatusbar.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qstylesheet.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qapplication.h>
#include <qcombobox.h>
#include <qevent.h>
#include <qlineedit.h>
#include <qobjectlist.h>
#include <qfileinfo.h>
#include <qfile.h>
#include <qdatastream.h>
#include <qprinter.h>
#include <qsimplerichtext.h>
#include <qpaintdevicemetrics.h>
#include <qpainter.h>
#include <ctype.h>

#include "xpm/back.xpm"
#include "xpm/forward.xpm"
//#include "xpm/tile.xpm"

RHelpWindow::RHelpWindow( const QString& _path, QWidget* _parent, const char *_name )
    : QMainWindow( _parent, _name, WDestructiveClose ),
      path( QFileInfo( _path ).dirPath( TRUE ), "*.html *.htm" )
{
  browser = new QTextBrowser( this );
  browser->mimeSourceFactory()->setFilePath( QFileInfo( _path ).dirPath( TRUE ) );
  browser->setFrameStyle( QFrame::Panel | QFrame::Sunken );

  setCentralWidget( browser );
  //TODO FIXME ///////!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  //browser->setLinkColor( QColor("#626993") );
  // Too slow :(
  //browser->setPaper( QBrush( QColor("#FFFFFF"), QPixmap( tile_xpm )) );

  if ( !_path.isEmpty() ) {
    browser->setSource( _path );
  }

  connect( browser, SIGNAL( highlighted( const QString&) ),
           statusBar(), SLOT( message( const QString&)) );

  resize( 630,QApplication::desktop()->height()-100 );

  QToolBar* toolbar = new QToolBar( this );
  addToolBar( toolbar, "Toolbar");
  QToolButton* button;

  button = new QToolButton( QPixmap(back_xpm), tr("Backward"), "", browser, SLOT(backward()), toolbar );
  connect( browser, SIGNAL( backwardAvailable(bool) ), button, SLOT( setEnabled(bool) ) );
  button->setEnabled( FALSE );
  button = new QToolButton( QPixmap(forward_xpm), tr("Forward"), "", browser, SLOT(forward()), toolbar );
  connect( browser, SIGNAL( forwardAvailable(bool) ), button, SLOT( setEnabled(bool) ) );
  button->setEnabled( FALSE );

  setDockEnabled( Right, FALSE );
  setDockEnabled( Bottom, FALSE );

  browser->setFocus();
}



RHelpWindow::~RHelpWindow()
{
}


void RHelpWindow::print()
{
  QPrinter printer;
  printer.setFullPage(TRUE);
  if ( printer.setup() ) {
    QPainter p( &printer );
    QPaintDeviceMetrics metrics(p.device());
    int dpix = metrics.logicalDpiX();
    int dpiy = metrics.logicalDpiY();
    const int margin = 72; // pt
    QRect body(margin*dpix/72, margin*dpiy/72,
               metrics.width()-margin*dpix/72*2,
               metrics.height()-margin*dpiy/72*2 );
    QFont lFont("times", 10);
    QSimpleRichText richText( browser->text(), lFont, browser->context(), browser->styleSheet(),
                              browser->mimeSourceFactory(), body.height() );
    richText.setWidth( &p, body.width() );
    QRect view( body );
    int page = 1;
    do {
      richText.draw( &p, body.left(), body.top(), view, colorGroup() );
      view.moveBy( 0, body.height() );
      p.translate( 0 , -body.height() );
      p.setFont( lFont );
      p.drawText( view.right() - p.fontMetrics().width( QString::number(page) ),
      view.bottom() + p.fontMetrics().ascent() + 5, QString::number(page) );
      if ( view.top()  >= richText.height() )
        break;
      printer.newPage();
      page++;
    } while (TRUE);
  }
}



void RHelpWindow::textChanged()
{
  if ( browser->documentTitle().isNull() )
    setCaption( browser->context() );
  else
    setCaption( browser->documentTitle() ) ;
}

