/***************************************************************************
                          rdlgline.cpp  -  description
                             -------------------
    begin                : Fri Feb 4 2000
    copyright            : (C) 2000 by Gerald Pichler
    email                : geripi@sbox.tu-graz.ac.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "rdlgline.h"
#include "relement.h"
#include "rmath.h"
#include <qvalidator.h>

RDlgLine::RDlgLine(QWidget *_parent, const char *_name, RElement *_line)
				 : QDialog(_parent,_name,true){
	initDialog();
	setCaption(tr("Line"));
	
  val= new QDoubleValidator(-1.0e300, 1.0e300, 8, this);
	
  QLineEdit_x1->setValidator(val);
  QLineEdit_y1->setValidator(val);
  QLineEdit_x2->setValidator(val);
  QLineEdit_y2->setValidator(val);

  //setCaption(tr("L: Clip element"));

	QPushButton_Ok->setText(tr("Ok"));
  connect(QPushButton_Ok, SIGNAL(clicked()), SLOT(accept()));

	QPushButton_Cancel->setText(tr("Cancel"));
  connect(QPushButton_Cancel, SIGNAL(clicked()), SLOT(reject()));

  QString tempStr;

  tempStr.setNum(_line->getX1());
  QLineEdit_x1->setText(tempStr);
  tempStr.setNum(_line->getY1());
  QLineEdit_y1->setText(tempStr);
  tempStr.setNum(_line->getX2());
  QLineEdit_x2->setText(tempStr);
  tempStr.setNum(_line->getY2());
  QLineEdit_y2->setText(tempStr);


}

RDlgLine::~RDlgLine(){
}

// Gives the Values that are written in the Editfields
double
RDlgLine::getX1(bool *isOk){
	//QString tmpStr=QLineEdit_x1->text();
	//return tmpStr.toDouble(isOk);
	return mtCalculate( QLineEdit_x1->text(), 0.0, isOk );
}

double
RDlgLine::getY1(bool *isOk){
	//QString tmpStr=QLineEdit_y1->text();
	//return tmpStr.toDouble(isOk);
	return mtCalculate( QLineEdit_y1->text(), 0.0, isOk );
}

double
RDlgLine::getX2(bool *isOk){
	//QString tmpStr=QLineEdit_x2->text();
	//return tmpStr.toDouble(isOk);
	return mtCalculate( QLineEdit_x2->text(), 0.0, isOk );
}

double
RDlgLine::getY2(bool *isOk){
	//QString tmpStr=QLineEdit_y2->text();
	//return tmpStr.toDouble(isOk);
	return mtCalculate( QLineEdit_y2->text(), 0.0, isOk );
}
