#include "dialog.h"

#include <qheader.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qtoolbutton.h>
#include <qwhatsthis.h>

#include <iostream>
#include <cstdlib>
#include "images.h"

playlistDialog::playlistDialog( QWidget* parent,  const char* name)
    : QWidget( parent, name), m_manager(playlistManager::self()), m_currentlyPlaying(-1)
{
    if ( !name )
	setName( "Qbble" );
    resize( 600, 600 ); 
    setCaption( tr( "Qbble"  ) );
    grid = new QGridLayout( this ); 
    grid->setSpacing( 6 );
    grid->setMargin( 11 );

	/* TOOLBAR */
	// this is satanic, and I will fix it one day.
	m_toolbar = new QToolBar(dynamic_cast<QMainWindow*>(parent), "hmm");
	
	/* TOOLBAR PIXMAPS */
	QPixmap * pix_play = new QPixmap( play_back_xpm );
	QPixmap * pix_next = new QPixmap( next_t_xpm );
	QPixmap * pix_prev = new QPixmap( prev_t_xpm );
	QPixmap * pix_stop = new QPixmap( stop_back_xpm );
	QPixmap * pix_pause = new QPixmap( pause_xpm );

	/* TOOLBAR BUTTONS */
	QToolButton * prev_button = new QToolButton(*pix_prev, "Previous", QString::null, this, SLOT( prevPressed() ), m_toolbar, "Previous");
	QToolButton * play_button = new QToolButton(*pix_play, "Play", QString::null, this, SLOT( playPressed() ), m_toolbar, "Play");
	QToolButton * stop_button = new QToolButton(*pix_stop, "Stop", QString::null, this, SLOT( stopPressed() ), m_toolbar, "Stop");
	QToolButton * pause_button = new QToolButton(*pix_pause, "Pause", QString::null, this, SLOT( pausePressed() ), m_toolbar, "Pause");
	QToolButton * next_button = new QToolButton(*pix_next, "Next", QString::null, this, SLOT( nextPressed() ), m_toolbar, "Next");
   
	/* SEARCH DROP DOWN */
	searchComboBox = new QComboBox(m_toolbar, "searchComboBox" );
	searchComboBox->setEditable(true);
	searchComboBox->setMinimumWidth(200);
	connect( searchComboBox, SIGNAL( activated(const QString &) ), this, SLOT( searchTextReturn() ) );

	/* SEARCH BUTTON */
	// m_toolbar->addSeparator();
	QPushButton * searchButton = new QPushButton("Search", m_toolbar);
	connect( searchButton, SIGNAL( clicked() ), this, SLOT( searchTextReturn() ) );

	m_toolbar->addSeparator();

	/* RANDOM/REPEAT BUTTONS */
	m_randomButton = new QPushButton(tr("Random"), m_toolbar, "Random");
	m_randomButton->setToggleButton(true);
	m_randomButton->setOn(false);
	connect( m_randomButton, SIGNAL( clicked() ), this, SLOT( randomToggle() ) );

	/* MAIN LIST WIDGET */
	playList = new QListView( this, "playList" );
    playList->addColumn( tr( "Position" ), 50 );
    playList->addColumn( tr( "Track Name" ), 250 );
    playList->addColumn( tr( "Length" ), 50 );
	playList->addColumn( tr( "Filename" ), 250 );
    playList->setSelectionMode( QListView::Single );
    playList->setAllColumnsShowFocus( TRUE );
	playList->setShowSortIndicator( TRUE );
    grid->addMultiCellWidget( playList, 1, 1, 0, 1 );
	connect( playList, SIGNAL( doubleClicked(QListViewItem*) ), this, SLOT( doubleClickOnList(QListViewItem*) ) );

	/* STATUS BAR */
	m_statusbar = new QStatusBar( this, "StatusBar" );
	grid->addMultiCellWidget( m_statusbar, 2, 2, 0, 1 );

	/* GUI UPDATES */
	QTimer * guiTimer = new QTimer(this);
	connect( guiTimer, SIGNAL(timeout()), this, SLOT(guiUpdate()) );
	guiTimer->start(500, false);

	/* PLAYLIST UPDATES */
	m_timer = new QTimer(this);
	connect( m_timer, SIGNAL(timeout()), this, SLOT(timedUpdate()) );
	m_timer->start(10000, false);
	searchTextUpdated(tr(""));
	guiUpdate();
}

void playlistDialog::guiUpdate()
{
	// update the status bar
	QString temp = m_manager.getStatusBarText();
	m_statusbar->message(temp);

	// update the currently selected item
	updateSelectedItem();

	// get the manager to update the status of our random button.
	if (m_manager.getRandomStatus())
		m_randomButton->setOn(true);
	else
		m_randomButton->setOn(false);
}

void playlistDialog::timedUpdate()
{
	// every ten or so seconds, ask the playlist manager to update its play list
	m_manager.updatePlaylist();
}

/*  
 *  Destroys the object and frees any allocated resources
 */
playlistDialog::~playlistDialog()
{
    // no need to delete child widgets, Qt does it all for us
}

void playlistDialog::clearList()
{
	// clear the map
	m_itemlist.clear();
	playList->clear();
}

void playlistDialog::addToList(const t_songInfo &item)
{
	playlistViewItem * i;
	QString strPosition, strTime;
	strTime = formatTime(item.m_time);
	strPosition.sprintf("%d", item.m_position);
	i = new playlistViewItem(playList, item.m_position, item.m_time, strPosition, item.m_title.c_str(), strTime, item.m_filename.c_str() );
	// update our index of items
	m_itemlist[item.m_position] = i;
}

void playlistDialog::updateSelectedItem()
{
	int id = m_manager.getPlayingId();
	playlistViewItem * item;
	
	// if there has been a song change, unbold the old one, if available.
	if (id != m_currentlyPlaying)
	{
		item = m_itemlist[m_currentlyPlaying];
		if (item)
		{
			item->setBold(false);
			playList->repaintItem(item);
			// cout << "Asking " << m_currentlyPlaying << " to go unbold" << endl;
		}
		// update what's currently playing.
		m_currentlyPlaying = id;
	}

	// make sure the currently playing song is always bold.
	item = m_itemlist[id];
	if (item && item->isBold() == false)
	{
		item->setBold(true);
		playList->repaintItem(item);
		// cout << "Asking " << id << " to go bold" << endl;
	}
}

void playlistDialog::doubleClickOnList(QListViewItem * listItem)
{
	playlistViewItem * item = dynamic_cast<playlistViewItem*>(listItem);
	m_manager.doubleClickOnList(*this, item->getid());
}

void playlistDialog::searchTextUpdated(const QString &text)
{
	m_manager.searchTextUpdated(*this, text.latin1());
}

void playlistDialog::searchTextReturn()
{
	m_manager.searchTextUpdated(*this, searchComboBox->currentText().latin1());
	updateSelectedItem();
}

void playlistDialog::stopPressed()
{
	m_manager.stopPressed();
}

void playlistDialog::playPressed()
{
	m_manager.playPressed();
}

void playlistDialog::nextPressed()
{
	m_manager.nextPressed();
}

void playlistDialog::prevPressed()
{
	m_manager.prevPressed();
}

void playlistDialog::pausePressed()
{
	m_manager.pausePressed();
}

void playlistDialog::randomToggle()
{
	m_manager.randomToggle();
}
