/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: exportedit.cpp 388 2006-03-08 15:38:34Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "exportedit.h"
#include "kbanking.h"
#include "refpointer.h"
#include "rulenameedit.h"
#include "transfinder.h"
#include "selectplugin.h"
#include "selectprofile.h"

#include <qcombobox.h>
#include <qlineedit.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qframe.h>

#include <list>
#include <string>

#include <gwenhywfar/debug.h>
#include <gwenhywfar/text.h>

#ifdef WIN32
# define strcasecmp stricmp
#endif



ExportEdit::ExportEdit(KBanking *app,
		       const char *ruleName,
                       QWidget* parent,
                       const char* name,
                       bool modal,
                       WFlags fl)
:ExportEditUI(parent, name, modal, fl)
,_app(app)
,_dbRules(0)
,_dbRule(0)
,_dbFilter(0)
,_dbProfile(0)
,_activeRule(false)
,_modifying(false)
,_isShort(false){
  GWEN_DB_NODE *dbT;
  int i;
  int idx;

  _dbRules=GWEN_DB_Group_dup(_app->getExportRules());

  QObject::connect(newButton, SIGNAL(clicked()),
                   this, SLOT(slotNewClicked()));
  QObject::connect(deleteButton, SIGNAL(clicked()),
                   this, SLOT(slotDeleteClicked()));
  QObject::connect(saveButton, SIGNAL(clicked()),
                   this, SLOT(slotSaveClicked()));
  QObject::connect(rulesCombo, SIGNAL(activated(int)),
                   this, SLOT(slotRuleActivated(int)));
  QObject::connect(transactionsButton, SIGNAL(clicked()),
                   this, SLOT(slotTransactionsClicked()));
  QObject::connect(exporterButton, SIGNAL(clicked()),
                   this, SLOT(slotExporterClicked()));
  QObject::connect(profileButton, SIGNAL(clicked()),
                   this, SLOT(slotProfileClicked()));
  QObject::connect(fileButton, SIGNAL(clicked()),
                   this, SLOT(slotFileClicked()));
  QObject::connect(fileEdit, SIGNAL(textChanged(const QString&)),
		   this, SLOT(slotFileNameChanged(const QString &)));

  /* fill rule select combo */
  dbT=GWEN_DB_FindFirstGroup(_dbRules, "rule");
  i=0;
  idx=-1;
  while(dbT) {
    const char *s;

    s=GWEN_DB_GetCharValue(dbT, "name", 0, 0);
    if (s) {
      if (strcasecmp(s, ruleName)==0 && idx==-1) {
        _dbRule=dbT;
        idx=i;
      }
    }
    _addRule(dbT);
    i++;
    dbT=GWEN_DB_FindNextGroup(dbT, "rule");
  }
  if (idx==-1) {
    DBG_NOTICE(0, "Rule %s does not exist", ruleName);
    _dbRule=GWEN_DB_GetGroup(_dbRules, GWEN_PATH_FLAGS_CREATE_GROUP,
                             "rule");
    assert(_dbRule);
    GWEN_DB_SetCharValue(_dbRule, GWEN_DB_FLAGS_DEFAULT,
                         "name", ruleName);
    rulesCombo->insertItem(QString::fromUtf8(ruleName));
    rulesCombo->setCurrentItem(i);
    slotRuleActivated(i);
  }
  else {
    rulesCombo->setCurrentItem(idx);
    slotRuleActivated(idx);
  }


}



ExportEdit::ExportEdit(KBanking *app,
                       GWEN_DB_NODE *dbRule,
		       QWidget* parent,
                       const char* name,
                       bool modal,
                       WFlags fl)
:ExportEditUI(parent, name, modal, fl)
,_app(app)
,_dbRules(0)
,_dbRule(0)
,_dbFilter(0)
,_dbProfile(0)
,_activeRule(false)
,_modifying(false)
,_isShort(true){

  _dbRules=GWEN_DB_Group_new("dummy");

  QObject::connect(newButton, SIGNAL(clicked()),
                   this, SLOT(slotNewClicked()));
  QObject::connect(deleteButton, SIGNAL(clicked()),
                   this, SLOT(slotDeleteClicked()));
  QObject::connect(saveButton, SIGNAL(clicked()),
                   this, SLOT(slotSaveClicked()));
  QObject::connect(rulesCombo, SIGNAL(activated(int)),
                   this, SLOT(slotRuleActivated(int)));
  QObject::connect(transactionsButton, SIGNAL(clicked()),
                   this, SLOT(slotTransactionsClicked()));
  QObject::connect(exporterButton, SIGNAL(clicked()),
                   this, SLOT(slotExporterClicked()));
  QObject::connect(profileButton, SIGNAL(clicked()),
                   this, SLOT(slotProfileClicked()));
  QObject::connect(fileButton, SIGNAL(clicked()),
                   this, SLOT(slotFileClicked()));
  QObject::connect(fileEdit, SIGNAL(textChanged(const QString&)),
		   this, SLOT(slotFileNameChanged(const QString &)));

  /* fill rule select combo */
  _dbRule=GWEN_DB_GetGroup(_dbRules, GWEN_DB_FLAGS_DEFAULT, "rule");
  GWEN_DB_AddGroupChildren(_dbRule, dbRule);
  GWEN_DB_SetCharValue(_dbRule, GWEN_DB_FLAGS_DEFAULT,
		       "name", "noname");
  slotRuleActivated(0);

  profileGroup->hide();
  upperLine->hide();
  transactionsCheck->hide();
  exporterCheck->hide();
  profileCheck->hide();
  fileCheck->hide();
  newButton->hide();
  deleteButton->hide();
  saveButton->hide();

}



ExportEdit::~ExportEdit(){
  GWEN_DB_Group_free(_dbFilter);
  GWEN_DB_Group_free(_dbRules);
}



bool ExportEdit::init(){
  return true;
}



bool ExportEdit::fini(){
  return true;
}



void ExportEdit::accept(){
  _saveRule();
  QDialog::accept();
}



void ExportEdit::reject(){
  _saveRule();
  QDialog::reject();
}



void ExportEdit::slotNewClicked(){
  QString qs;
  GWEN_DB_NODE *dbRule;

  RuleNameEdit w(tr("Create New Rule..."),
                 0,
                 0,
                 this,
                 "RuleNameEdit",
                 true);
  for (;;) {
    GWEN_DB_NODE *dbT;

    if (w.exec()!=QDialog::Accepted)
      return;
    qs=w.getName();

    dbT=GWEN_DB_FindFirstGroup(_dbRules, "rule");
    while(dbT) {
      const char *n;

      n=GWEN_DB_GetCharValue(dbT, "name", 0, 0);
      if (n) {
        if (strcasecmp(n, qs.utf8())==0)
          break;
      }
      dbT=GWEN_DB_FindNextGroup(dbT, "rule");
    }
    if (!dbT)
      break;

    int res = QMessageBox::critical(this,
                              tr("Name already exists"),
                              tr("Please choose another name."),
                              QMessageBox::Ok,QMessageBox::Abort);
    if (res !=0 && res != QMessageBox::Ok)
      return;
  } // for


  dbRule=GWEN_DB_Group_new("rule");
  qs=w.getName();
  GWEN_DB_SetCharValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "name", qs.utf8());
  qs=w.getShortDescription();
  if (!qs.isEmpty())
    GWEN_DB_SetCharValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                         "short", qs.utf8());

  _addRule(dbRule);
  GWEN_DB_AddGroup(_dbRules, dbRule);
  rulesCombo->setCurrentItem(rulesCombo->count()-1);
  slotRuleActivated(rulesCombo->count()-1);
}



void ExportEdit::slotSaveClicked(){
  QString qs;
  GWEN_DB_NODE *dbRule;
  GWEN_DB_NODE *dbData;

  assert(_dbRule);

  RuleNameEdit w(tr("Save Rule As..."),
                 GWEN_DB_GetCharValue(_dbRule, "name", 0, 0),
                 GWEN_DB_GetCharValue(_dbRule, "short", 0, 0),
                 this,
                 "RuleNameEdit",
                 true);
  for (;;) {
    GWEN_DB_NODE *dbT;

    if (w.exec()!=QDialog::Accepted)
      return;
    qs=w.getName();

    dbT=GWEN_DB_FindFirstGroup(_dbRules, "rule");
    while(dbT) {
      const char *n;

      n=GWEN_DB_GetCharValue(dbT, "name", 0, 0);
      if (n) {
        if (strcasecmp(n, qs.utf8())==0)
          break;
      }
      dbT=GWEN_DB_FindNextGroup(dbT, "rule");
    }
    if (!dbT)
      break;

    int res = QMessageBox::critical(this,
                              tr("Name already exists"),
                              tr("Please choose another name."),
                              QMessageBox::Ok,QMessageBox::Abort);
    if (res !=0 && res != QMessageBox::Ok)
      return;
  } // for


  dbRule=GWEN_DB_Group_new("rule");
  qs=w.getName();
  GWEN_DB_SetCharValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "name", qs.utf8());
  qs=w.getShortDescription();
  if (!qs.isEmpty())
    GWEN_DB_SetCharValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                         "short", qs.utf8());

  dbData=GWEN_DB_GetGroup(dbRule, GWEN_DB_FLAGS_DEFAULT, "data");
  if (_toDb(dbData)) {
    GWEN_DB_Dump(dbRule, stderr, 2);
    _addRule(dbRule);
    GWEN_DB_AddGroup(_dbRules, dbRule);
    _activeRule=false;
    rulesCombo->setCurrentItem(rulesCombo->count()-1);
    slotRuleActivated(rulesCombo->count()-1);
  }
  else {
    DBG_ERROR(0, "Could not save rule");
    GWEN_DB_Group_free(dbRule);
  }
}



void ExportEdit::slotDeleteClicked(){
  if (rulesCombo->count()>1 && _dbRule) {
    int res = QMessageBox::warning(this,
                             tr("Delete Rule"),
                             tr("Do you really want to delete this rule?"),
			     QMessageBox::Yes,QMessageBox::No);
    if (res !=0 && res != QMessageBox::Yes)
      return;

    assert(_dbRule);
    _activeRule=false;
    rulesCombo->removeItem(rulesCombo->currentItem());
    GWEN_DB_UnlinkGroup( _dbRule);
    GWEN_DB_Group_free(_dbRule);
    _dbRule=GWEN_DB_FindFirstGroup(_dbRules, "rule");
    if (_dbRule) {
      rulesCombo->setCurrentItem(0);
      slotRuleActivated(0);
    }
    DBG_NOTICE(0, "Removed, ruleset now:");
    GWEN_DB_Dump(_dbRules, stderr, 2);
  }
  else {
    QMessageBox::critical(this,
                          tr("Error"),
                          tr("You can not delete all rules"),
                          QMessageBox::Ok,QMessageBox::NoButton);
  }
}



void ExportEdit::slotTransactionsClicked(){
  int rv;
  GWEN_DB_NODE *dbFilters;
  QString qname;
  std::string name;
  GWEN_DB_NODE *dbT;

  dbFilters=GWEN_DB_Group_dup(_app->getTransactionMatcherRules());
  name=_app->tr("current");

  dbT=GWEN_DB_GetFirstGroup(dbFilters);
  while(dbT) {
    const char *s;

    s=GWEN_DB_GetCharValue(dbT, "name", 0, 0);
    if (s) {
      if (strcasecmp(name.c_str(), s)==0) {
        GWEN_DB_UnlinkGroup(dbT);
        GWEN_DB_Group_free(dbT);
        break;
      }
    }
    dbT=GWEN_DB_GetNextGroup(dbT);
  }

  assert(_dbFilter);
  GWEN_DB_SetCharValue(_dbFilter, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "name", name.c_str());
  dbT=GWEN_DB_GetGroup(dbFilters, GWEN_PATH_FLAGS_CREATE_GROUP, "rule");
  GWEN_DB_AddGroupChildren(dbT, _dbFilter);
  TransactionFinder tf(_app,
                       dbFilters,
                       name.c_str(),
                       TRANSFINDER_FLAGS_USE_CATEGORY |
                       TRANSFINDER_FLAGS_EXT_PAYEES,
                       this, "TransactionFinder",
                       true);

  tf.init();
  rv=tf.exec();
  _app->setTransactionMatcherRules(tf.getRules());
  if (rv==QDialog::Accepted) {
    QString qs;

    GWEN_DB_Group_free(_dbFilter);
    _dbFilter=GWEN_DB_Group_dup(tf.getRule());
    GWEN_DB_SetCharValue(_dbFilter, GWEN_DB_FLAGS_OVERWRITE_VARS,
                         "name", qname.utf8());
    GWEN_DB_DeleteVar(_dbFilter, "short");
    _transactions=tf.getMatchingTransactions();
    qs=QString::fromUtf8(GWEN_DB_GetCharValue(_dbFilter, "name", 0, ""));
    transactionsLabel->setText(tr("<qt><font color=green>set</font></qt>"));
  }
  tf.fini();
  _validate();
}



void ExportEdit::slotExporterClicked(){
  GWEN_PLUGIN_DESCRIPTION_LIST2 *tmpImporterList;
  GWEN_PLUGIN_DESCRIPTION_LIST2 *importerList;
  GWEN_PLUGIN_DESCRIPTION_LIST2_ITERATOR *it;
  GWEN_PLUGIN_DESCRIPTION *pd;
  int count;

  tmpImporterList=AB_Banking_GetImExporterDescrs(_app->getCInterface());
  if (!tmpImporterList) {
    QMessageBox::critical(this,
			  tr("No Exporters"),
			  tr("<qt>"
			     "<p>"
			     "There are currently no exporters installed."
			     "</p>"
			     "</qt>"
			    ),
			  tr("Dismiss"), QString::null);
    return;
  }

  it=GWEN_PluginDescription_List2_First(tmpImporterList);
  assert(it);
  importerList=GWEN_PluginDescription_List2_new();
  pd=GWEN_PluginDescription_List2Iterator_Data(it);
  count=0;
  while(pd) {
    GWEN_XMLNODE *node;

    node=GWEN_PluginDescription_GetXmlNode(pd);
    assert(node);
    if (atoi(GWEN_XMLNode_GetProperty(node, "export", "0"))) {
      GWEN_PluginDescription_SetIsActive(pd, 1);
      GWEN_PluginDescription_List2_PushBack(importerList, pd);
      count++;
    }
    else
      GWEN_PluginDescription_free(pd);
    pd=GWEN_PluginDescription_List2Iterator_Next(it);
  }
  GWEN_PluginDescription_List2Iterator_free(it);
  GWEN_PluginDescription_List2_free(tmpImporterList);

  if (!count) {
    GWEN_PluginDescription_List2_free(importerList);
    QMessageBox::critical(this,
			  tr("No Exporters"),
			  tr("<qt>"
			     "<p>"
			     "There are currently no exporters installed."
			     "</p>"
			     "</qt>"
			    ),
			  tr("Dismiss"), QString::null);
    return;
  }

  SelectPlugin w(_app, tr("Select Exporter"), importerList,
		 exporterLabel->text().utf8(), this);
  if (w.exec()==QDialog::Accepted) {
    GWEN_PLUGIN_DESCRIPTION *pd;
    const char *s;

    pd=w.getSelectedPlugin();
    assert(pd);
    s=GWEN_PluginDescription_GetName(pd);
    assert(s);
    exporterLabel->setText(QString::fromUtf8(s));
    profileLabel->setText(QString::null);
  }
  GWEN_PluginDescription_List2_freeAll(importerList);
  _validate();
}



void ExportEdit::slotProfileClicked(){
  GWEN_DB_NODE *profiles;

  if (exporterLabel->text().isEmpty()) {
    QMessageBox::critical(this,
			  tr("No Exporter"),
			  tr("<qt>"
			     "<p>"
                             "Please select the exporter plugin first."
			     "</p>"
			     "</qt>"
			    ),
			  tr("Dismiss"), QString::null);
    return;
  }
  profiles=AB_Banking_GetImExporterProfiles(_app->getCInterface(),
                                            exporterLabel->text().utf8());
  if (profiles) {
    GWEN_DB_NODE *dbT;
    int count;

    dbT=GWEN_DB_GetFirstGroup(profiles);
    count=0;
    while(dbT) {
      const char *n;
      GWEN_DB_NODE *dbNext;
      bool usable;

      usable=false;
      dbNext=GWEN_DB_GetNextGroup(dbT);
      n=GWEN_DB_GetCharValue(dbT, "name", 0, 0);
      if (n)
	if (GWEN_DB_GetIntValue(dbT, "export", 0, 0))
	  usable=true;
      if (!usable) {
	GWEN_DB_UnlinkGroup(dbT);
	GWEN_DB_Group_free(dbT);
      }
      else
        count++;

      dbT=dbNext;
    } // while */
    if (count) {
      SelectProfile w(_app, tr("Select Exporter Profile"),
		      profiles,
		      profileLabel->text().utf8(),
		      this);
      if (w.exec()==QDialog::Accepted) {
        const char *name;

	dbT=w.getSelectedProfile();
        assert(dbT);
        GWEN_DB_Group_free(_dbProfile);
        _dbProfile=GWEN_DB_Group_dup(dbT);
        name=GWEN_DB_GetCharValue(dbT, "name", 0, 0);
	assert(name);
	profileLabel->setText(QString::fromUtf8(name));
      }
      GWEN_DB_Group_free(profiles);
      _validate();
      return;
    } // if count
    GWEN_DB_Group_free(profiles);
  }

  QMessageBox::critical(this,
                        tr("No Profiles"),
                        tr("<qt>"
                           "<p>"
                           "There are no profiles installed for the "
                           "selected importer."
                           "</p>"
                           "<p>"
                           "</p>"
                           "Please select another one or abort."
                           "</qt>"
                          ),
                        tr("Dismiss"), QString::null);
}



void ExportEdit::slotFileClicked(){
}



void ExportEdit::_saveRule(){
  GWEN_DB_NODE *dbData;

  dbData=GWEN_DB_Group_new("data");
  if (_toDb(dbData)) {
    GWEN_DB_DeleteGroup(_dbRule, "data");
    GWEN_DB_AddGroup(_dbRule, dbData);
#ifndef WIN32
	GWEN_DB_Dump(_dbRule, stderr, 2);
#endif
  }
  else {
    DBG_ERROR(0, "Could not save rule");
    GWEN_DB_Group_free(dbData);
  }
}



void ExportEdit::_addRule(GWEN_DB_NODE *dbT){
  const char *s;
  QString qs;

  s=GWEN_DB_GetCharValue(dbT, "name", 0, 0);
  if (s) {
    qs=QString::fromUtf8(s);
  }
  else
    qs=tr("[unnamed]");
  s=GWEN_DB_GetCharValue(dbT, "short", 0, 0);
  if (s) {
    qs+=" (";
    qs+=QString::fromUtf8(s);
    qs+=")";
  }
  rulesCombo->insertItem(qs);
}



void ExportEdit::_resetRule(){
}



bool ExportEdit::_fromDb(GWEN_DB_NODE *db){
  const char *s;
  QString qs;
  GWEN_DB_NODE *dbFilter;
  GWEN_DB_NODE *dbT;

  dbFilter=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "filter");
  if (dbFilter) {
    GWEN_DB_Group_free(_dbFilter);
    _dbFilter=GWEN_DB_Group_dup(dbFilter);
    transactionsLabel->setText(tr("<qt><font color=green>set</font></qt>"));
  }
  else {
    GWEN_DB_Group_free(_dbFilter);
    _dbFilter=GWEN_DB_Group_new("filter");
    transactionsLabel->setText(tr("<qt><font color=red>not set</font></qt>"));
  }

  dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "profile");
  if (dbT) {
    GWEN_DB_Group_free(_dbProfile);
    _dbProfile=GWEN_DB_Group_dup(dbT);
    s=GWEN_DB_GetCharValue(dbT, "name", 0, 0);
    assert(s);
    profileLabel->setText(QString::fromUtf8(s));
  }
  else {
    GWEN_DB_Group_free(_dbProfile);
    _dbProfile=GWEN_DB_Group_new("profile");
    profileLabel->setText(QString::null);
  }

  transactionsCheck->setChecked(GWEN_DB_GetIntValue(db,
                                                    "transactionsAsk", 0, 0));

  s=GWEN_DB_GetCharValue(db, "exporterText", 0, "");
  exporterLabel->setText(QString::fromUtf8(s));
  exporterCheck->setChecked(GWEN_DB_GetIntValue(db, "exporterAsk", 0, 0));
  s=GWEN_DB_GetCharValue(db, "profileText", 0, "");
  profileCheck->setChecked(GWEN_DB_GetIntValue(db, "profileAsk", 0, 0));
  s=GWEN_DB_GetCharValue(db, "outfileText", 0, "");
  fileEdit->setText(QString::fromUtf8(s));
  fileCheck->setChecked(GWEN_DB_GetIntValue(db, "outfileAsk", 0, 0));

  return true;
}



bool ExportEdit::_toDb(GWEN_DB_NODE *db){
  QString qs;
  GWEN_DB_NODE *dbT;

  /* copy filter */
  dbT=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                       "filter");
  GWEN_DB_AddGroupChildren(dbT, _dbFilter);

  /* copy profile */
  dbT=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                       "profile");
  GWEN_DB_AddGroupChildren(dbT, _dbProfile);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "transactionsAsk",
                      transactionsCheck->isChecked());
  qs=exporterLabel->text();
  if (!qs.isEmpty())
    GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                         "exporterText", qs.utf8());
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "exporterAsk",
                      exporterCheck->isChecked());

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "profileAsk",
                      profileCheck->isChecked());

  qs=fileEdit->text();
  if (!qs.isEmpty())
    GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                         "outfileText", qs.utf8());
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "outfileAsk",
                      fileCheck->isChecked());
  return true;
}



void ExportEdit::slotRuleActivated(int idx){
  GWEN_DB_NODE *dbT;
  int i;

  DBG_NOTICE(0, "Rule %d activated", idx);

  if (_activeRule)
    _saveRule();

  dbT=GWEN_DB_FindFirstGroup(_dbRules, "rule");
  i=idx;
  while(dbT && i--) dbT=GWEN_DB_FindNextGroup(dbT, "rule");
  if (!dbT) {
    DBG_ERROR(0, "Uuuups, index %d out of range?", idx);
    GWEN_DB_Dump(_dbRules, stderr, 2);
    abort();
  }
  _dbRule=dbT;
  dbT=GWEN_DB_GetGroup(_dbRule, GWEN_DB_FLAGS_DEFAULT, "data");
  assert(dbT);
  _fromDb(dbT);

  _activeRule=true;
  _validate();
}



void ExportEdit::_validate() {
  if (_isShort) {
    if (fileEdit->text().isEmpty() ||
	profileLabel->text().isEmpty() ||
	exporterLabel->text().isEmpty() ||
	_transactions.empty())
      doneButton->setEnabled(false);
    else
      doneButton->setEnabled(true);
  }
  else
    doneButton->setEnabled(true);
}



GWEN_DB_NODE *ExportEdit::getRules(){
  return _dbRules;
}



GWEN_DB_NODE *ExportEdit::getRule(){
  return _dbRule;
}



void ExportEdit::slotFileNameChanged(const QString &qs) {
  _validate();
}



const std::list<RefPointer<Transaction> > &ExportEdit::getTransactions(){
  return _transactions;
}




