/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: askaccount.cpp 388 2006-03-08 15:38:34Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "askaccount.h"
#include "accountlist.h"
#include "kbanking.h"

#include <qbanking/qbselectbackend.h>
#include <qbanking/qbeditaccount.h>

#include <qlayout.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qmessagebox.h>
#include <qtextcodec.h>



AskAccount::AskAccount(KBanking *app,
                       const char *bankCode,
                       const char *accountId,
                       QWidget* parent,
                       const char* name,
                       bool modal,
                       WFlags fl)
:AskAccountUi(parent, name, modal, fl)
,_app(app){
  if (bankCode)
    _bankCode=bankCode;
  if (accountId)
    _accountId=accountId;

  accountList->addAccounts(app->getAppAccounts());

  bankCodeEdit->setText(_bankCode);
  if (_bankCode.isEmpty())
    bankCodeEdit->setEnabled(false);

  accountIdEdit->setText(_accountId);
  if (_accountId.isEmpty())
    accountIdEdit->setEnabled(false);

  QObject::connect(createAccountButton, SIGNAL(clicked()),
                   this, SLOT(slotCreateAccount()));

  QObject::connect(helpButton, SIGNAL(clicked()),
                   this, SLOT(slotHelp()));
}



AskAccount::~AskAccount(){
}



Account *AskAccount::selectedAccount(){
  AccountListViewItem *entry;
  QListViewItemIterator it(accountList);

  // iterate through all items of the listview
  for (;it.current();++it) {
    if (it.current()->isSelected()) {
      entry=dynamic_cast<AccountListViewItem*>(it.current());
      if (entry)
        return entry->getAccount();
    }
  } // for
  return 0;
}



void AskAccount::accept(){
  if (selectedAccount()==0) {
    QMessageBox::critical(this,
                          tr("No Account Selected"),
                          tr("Please select the matching account."),
                          tr("Dismiss"), QString::null);
    return;
  }

  return QDialog::accept();
}



void AskAccount::reject(){
  return QDialog::reject();
}



void AskAccount::slotCreateAccount(){
  QString backend;
  QString preBackend;
  const char *l;

  l=QTextCodec::locale();
  if (l) {
    QString ql;

    ql=QString::fromUtf8(l).lower();
    if (ql=="de" || ql=="de_de")
      preBackend="aqhbci";
  }
  backend=QBSelectBackend::selectBackend(_app,
                                         preBackend,
                                         this);
  if (backend.isEmpty()) {
    DBG_INFO(0, "Aborted");
  }
  else {
    AB_ACCOUNT *a;
    std::string s;

    s=QBanking::QStringToUtf8String(backend);
    DBG_ERROR(0, "Selected backend: %s", s.c_str());

    a=AB_Banking_CreateAccount(_app->getCInterface(),
                               s.c_str());
    assert(a);
    if (!_bankCode.isEmpty()) {
      std::string s;

      s=QBanking::QStringToUtf8String(_bankCode);
      AB_Account_SetBankCode(a, s.c_str());
    }
    if (!_accountId.isEmpty()) {
      std::string s;

      s=QBanking::QStringToUtf8String(_accountId);
      AB_Account_SetAccountNumber(a, s.c_str());
    }

    if (QBEditAccount::editAccount(_app, a, this)) {
      DBG_INFO(0, "Accepted, adding account");
      AB_Banking_AddAccount(_app->getCInterface(), a);
      _app->updateAccountList();
      accountList->clear();
      accountList->addAccounts(_app->getAppAccounts());
    }
    else {
      DBG_INFO(0, "Rejected");
      AB_Account_free(a);
    }
  }
}



void AskAccount::slotHelp(){
  _app->invokeHelp("AskAccount", "dialog/askAccount");
}











