/***************************************************************************
 $RCSfile: payeelist.h,v $
                             -------------------
    cvs         : $Id: payeelist.h,v 1.4 2006/03/10 02:20:53 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef KBANKING_PAYEELIST_H
#define KBANKING_PAYEELIST_H


#include <qlistview.h>

#include <list>


class PayeeListView;
class PayeeListViewItem;

#include "payee.h"


class PayeeListViewItem: public QListViewItem {
private:
  Payee *_payee;

  void _populate();

public:
  PayeeListViewItem(PayeeListView *parent,
                    Payee *py);
  PayeeListViewItem(PayeeListView *parent,
                    QListViewItem *after,
                    Payee *py);
  PayeeListViewItem(const PayeeListViewItem &item);

  virtual ~PayeeListViewItem();

  virtual QString key(int column, bool ascending) const;

  Payee *getPayee();

};



class PayeeListView: public QListView {
private:
public:
  PayeeListView(QWidget *parent=0, const char *name=0);
  virtual ~PayeeListView();

  void addPayee(Payee *py);
  void addPayees(const std::list<Payee*> &accs);

  Payee *getCurrentPayee();
  std::list<Payee*> getSelectedPayees();

  void selectPayee(const char *id, bool s);
  void selectPayeeOnly(const char *id, bool s);
  void ensureSelectionVisible();
};


#endif /* KBANKING_ACCOUNTLIST_H */

