/***************************************************************************
 $RCSfile: editeutransaction.h,v $
                             -------------------
    cvs         : $Id: editeutransaction.h,v 1.3 2005/08/24 16:52:02 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQBANKING_KDE_EDITEUTRANS_H
#define AQBANKING_KDE_EDITEUTRANS_H

class KBanking;


#include "editeutransaction.ui.h"
#include "transfer.h"
#include "refpointer.h"



class EditEuTransaction: public EditEuTransactionUi {
  Q_OBJECT
public:
  EditEuTransaction(KBanking *app,
                    RefPointer<Transfer> t,
                    QWidget* parent=0,
                    const char* name=0,
                    bool modal=false,
                    WFlags fl=0);
  ~EditEuTransaction();

  static bool editEuTransfer(KBanking *app,
                             RefPointer<Transfer> t,
                             const QString &title,
                             QWidget* parent=0,
                             bool modal=false,
                             WFlags fl=0);


public slots:
  void accept();
  void reject();
  void slotBankCode();
  void slotAccountChanged(int i);
  void slotCountryChanged(const QString &qs);
  void slotGetBankCode();
  void slotGetPayee();
  void slotAccountIdToggled(bool on);
  void slotIbanToggled(bool on);

  void slotIbanChanged(const QString &qs);
  void slotBankCodeLostFocus();

private:
  KBanking *_app;
  RefPointer<Transfer> _transfer;
  int _maxPurpose;
  int _maxLenPurpose;
  int _maxOtherNameLines;
  int _maxLenOtherName;
  bool _ibanAllowed;
  std::string _countryCode;

  QString _nullCountryName;

  void _setComboTextNoDup(QComboBox *qb, const QString &s);
  bool _selectCountry(const QString &qs, bool byLong,
                      bool withCombo=true);
};







#endif // AQBANKING_KDE_EDITEUTRANS_H


