/***************************************************************************
 $RCSfile: editcategory.h,v $
                             -------------------
    cvs         : $Id: editcategory.h,v 1.2 2005/08/26 16:12:09 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQBANKING_KDE_EDITCATEGORY_H
#define AQBANKING_KDE_EDITCATEGORY_H

class KBanking;
class Category;

#include "editcategory.ui.h"
#include "refpointer.h"




class EditCategory : public EditCategoryUi {
    Q_OBJECT

public:
  EditCategory(KBanking *kb,
               Category *cat,
               Category *parentCat,
               bool isCreate,
               QWidget* parent=0,
               const char* name=0,
               bool modal=FALSE,
               WFlags fl=0);
  ~EditCategory();

  bool init();
  bool fini();

  Category *getParentCategory();

  static Category *createCategory(KBanking *kb, QWidget *parent=0);
  static bool editCategory(KBanking *kb,
                           Category *cat,
                           QWidget *parent=0);

  static bool editNewCategory(KBanking *kb,
                              Category *cat,
                              QWidget *parent);

public slots:
  void accept();

private:
  KBanking *_app;
  Category *_category;
  Category *_parentCategory;
  bool _isCreate;
};



#endif

