/***************************************************************************
 $RCSfile: payee.cpp,v $
                             -------------------
    cvs         : $Id: payee.cpp,v 1.2 2005/03/27 06:52:32 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "payee.h"



Payee::Payee(const std::string &id)
:_id(id), _rules(GWEN_DB_Group_new("rules")){
  _inValue=AB_Value_new(0.0, 0);;
  _outValue=AB_Value_new(0.0, 0);;
}



Payee::~Payee(){
  GWEN_DB_Group_free(_rules);
  AB_Value_free(_inValue);
  AB_Value_free(_outValue);
}



bool Payee::fromDb(GWEN_DB_NODE *db){
  const char *s;
  GWEN_DB_NODE *dbR;

  GWEN_DB_ClearGroup(_rules, 0);
  AB_Value_free(_inValue);
  _inValue=0;
  AB_Value_free(_outValue);
  _outValue=0;
  s=GWEN_DB_GetCharValue(db, "id", 0, 0);
  assert(s);
  assert(*s);
  _id=s;

  _name=GWEN_DB_GetCharValue(db, "name", 0, "");
  _street=GWEN_DB_GetCharValue(db, "street", 0, "");
  _zipCode=GWEN_DB_GetCharValue(db, "zipCode", 0, "");
  _city=GWEN_DB_GetCharValue(db, "city", 0, "");
  _state=GWEN_DB_GetCharValue(db, "state", 0, "");
  _country=GWEN_DB_GetCharValue(db, "country", 0, "");
  if (_country.empty())
    _country="de";
  _phone=GWEN_DB_GetCharValue(db, "phone", 0, "");
  _fax=GWEN_DB_GetCharValue(db, "fax", 0, "");
  _email=GWEN_DB_GetCharValue(db, "email", 0, "");

  _bankCode=GWEN_DB_GetCharValue(db, "bankCode", 0, "");
  _accountNumber=GWEN_DB_GetCharValue(db, "accountNumber", 0, "");

  dbR=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "inValue");
  if (dbR)
    _inValue=AB_Value_fromDb(dbR);
  if (_inValue==0)
    _inValue=AB_Value_new(0.0, 0);
  dbR=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "outValue");
  if (dbR)
    _outValue=AB_Value_fromDb(dbR);
  if (_outValue==0)
    _outValue=AB_Value_new(0.0, 0);

  dbR=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "rules");
  if (dbR)
    GWEN_DB_AddGroupChildren(_rules, dbR);

  return true;
}



bool Payee::toDb(GWEN_DB_NODE *db) const {
  std::list<std::string>::const_iterator it;
  GWEN_DB_NODE *dbR;

  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "id", _id.c_str());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "name", _name.c_str());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "street", _street.c_str());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "zipCode", _zipCode.c_str());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "city", _city.c_str());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "state", _state.c_str());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "country", _country.c_str());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "phone", _phone.c_str());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "fax", _fax.c_str());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "email", _email.c_str());

  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "bankCode", _bankCode.c_str());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "accountNumber", _accountNumber.c_str());

  dbR=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS, "inValue");
  assert(dbR);
  AB_Value_toDb(_inValue, dbR);

  dbR=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS, "outValue");
  assert(dbR);
  AB_Value_toDb(_outValue, dbR);

  dbR=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS, "rules");
  assert(dbR);
  GWEN_DB_AddGroupChildren(dbR, _rules);
  return true;
}



void Payee::resetValues(){
  AB_Value_SetValue(_inValue, 0.0);
  AB_Value_SetValue(_outValue, 0.0);
}



bool Payee::addInValue(const AB_VALUE *v){
  assert(v);
  return (0==AB_Value_AddValue(_inValue, v));
}



bool Payee::addOutValue(const AB_VALUE *v){
  assert(v);
  return (0==AB_Value_AddValue(_outValue, v));
}
















