/***************************************************************************
 $RCSfile: mainwindow.h,v $
                             -------------------
    cvs         : $Id: mainwindow.h,v 1.22 2005/08/31 05:24:20 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/



#ifndef KBANKING_MAINWINDOW_H
#define KBANKING_MAINWINDOW_H


#include <qmainwindow.h>


class QTabWidget;
class QPopupMenu;

class KBanking;
class IntroView;
class AccountView;
class TransferView;
class StandingOrderView;
class DatedTransferView;
class JobView;
class ReportView;
class PayeeView;
class CategoryView;

class MainWindow;



class MainWindow: public QMainWindow {
  Q_OBJECT
public:
  MainWindow(KBanking *kb,
             QWidget * parent=0,
             const char * name=0,
             WFlags f=Qt::WType_TopLevel );
  ~MainWindow();

  bool init();
  bool fini();

  bool setTabWidget(const QString &name);

private:
  KBanking *_app;
  QTabWidget *_tabs;
  AccountView *_accountView;
  IntroView *_introView;
  JobView *_jobView;
  TransferView *_transferView;
  DatedTransferView *_datedTransferView;
  StandingOrderView *_standingOrderView;
  ReportView *_reportView;
  PayeeView *_payeeView;
  CategoryView *_categoryView;

  QPopupMenu *_exportMenu;

protected:
  void closeEvent(QCloseEvent *e);

public slots:
  void slotAbout();
  void slotImport();
  void slotOutboxCountChanged(int count);
  void slotStatusMessage(const QString &s);
  void slotRebuildExportMenu();

  void slotEditExports();
  void slotExportTransactions();
  void slotUseExport(int id);
  void slotDebugTransfinder();
  void slotRemoveDupes();
  void slotAssignPayees();
  void slotAssignCategories();
  void slotCheckCategories();
  void slotDebugAqHBCI();

  void slotCurrentDebug();
};




#endif /* KBANKING_MAINWINDOW_H */



