/***************************************************************************
 $RCSfile: mainwindow.cpp,v $
                             -------------------
    cvs         : $Id: mainwindow.cpp,v 1.35 2005/08/31 05:24:20 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "mainwindow.h"
#include "accountview.h"
#include "introview.h"
#include "jobview.h"
#include "transferview.h"
#include "stoview.h"
#include "datedxferview.h"
#include "payeeview.h"
#include "categoryview.h"
#include "reportview.h"
#include "kbanking.h"
#include "checkduplicates.h"
#include "assignpayees.h"
#include "assigncategories.h"

#include "transfinder.h"
#include "exportedit.h"
#include "editsto.h"

#include <qbanking/qbimporter.h>
#include <qbanking/qbprocesswatcher.h>
#include <qbanking/qbprogress.h>

#include <qtabwidget.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qstatusbar.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <qprocess.h>


#include <gwenhywfar/debug.h>
#include <gwenhywfar/version.h>
#include <aqbanking/version.h>

#include <unistd.h>


MainWindow::MainWindow(KBanking *kb,
                       QWidget * parent, const char * name, WFlags f)
:QMainWindow(parent, name, f), _app(kb), _tabs(0) {

  _tabs=new QTabWidget(this, "Tabs");
  setCentralWidget(_tabs);

  _introView=new IntroView(kb, _tabs, "IntroView");
  _tabs->addTab(_introView, tr("Intro"));

  _accountView=new AccountView(kb, _tabs, "AccountView");
  _tabs->addTab(_accountView, tr("Accounts"));

  _transferView=new TransferView(kb, _tabs, "TransferView");
  _tabs->addTab(_transferView, tr("Transfers"));

  _datedTransferView=new DatedTransferView(kb, _tabs, "DatedTransferView");
  _tabs->addTab(_datedTransferView, tr("Dated Transfers"));

  _standingOrderView=new StandingOrderView(kb, _tabs, "StandingOrderView");
  _tabs->addTab(_standingOrderView, tr("Standing Orders"));

  _payeeView=new PayeeView(kb, _tabs, "PayeeView");
  _tabs->addTab(_payeeView, tr("Payees"));

  _categoryView=new CategoryView(kb, _tabs, "CategoryView");
  _tabs->addTab(_categoryView, tr("Categories"));

  _reportView=new ReportView(kb, _tabs, "ReportView");
  _tabs->addTab(_reportView, tr("Reports"));

  _jobView=new JobView(kb, _tabs, "JobView");
  _tabs->addTab(_jobView, tr("Outbox"));

  _exportMenu=new QPopupMenu();

  QPopupMenu *fileMenu=new QPopupMenu(this);
  menuBar()->insertItem(tr("File"), fileMenu);
  fileMenu->insertItem(tr("Import"), this, SLOT(slotImport()));
  QPopupMenu *exportMenu=new QPopupMenu();
  fileMenu->insertItem(tr("Export"), exportMenu);
  exportMenu->insertItem(tr("Export Transactions..."), this,
                         SLOT(slotExportTransactions()));
  exportMenu->insertItem(tr("Predefined"), _exportMenu);

  fileMenu->insertSeparator();
  fileMenu->insertItem(tr("Remove Duplicates"),
                       this, SLOT(slotRemoveDupes()));
  fileMenu->insertItem(tr("Assign &Payees"),
                       this, SLOT(slotAssignPayees()));
  fileMenu->insertSeparator();
  fileMenu->insertItem(tr("Assign &Categories"),
                       this, SLOT(slotAssignCategories()));
  fileMenu->insertItem(tr("Check Categories"),
                       this, SLOT(slotCheckCategories()));
  fileMenu->insertSeparator();
  fileMenu->insertItem(tr("Quit"), this, SLOT(close()));

  QPopupMenu *debugMenu=new QPopupMenu(this);
  menuBar()->insertItem(tr("Debug"), debugMenu);
  debugMenu->insertItem(tr("Transfinder"), this,
                        SLOT(slotDebugTransfinder()));
  debugMenu->insertItem(tr("CurrentDebug"), this,
                        SLOT(slotCurrentDebug()));

  QPopupMenu *helpMenu=new QPopupMenu(this);
  menuBar()->insertItem(tr("&Help"), helpMenu);
  helpMenu->insertItem(tr("&About"), this, SLOT(slotAbout()));
  helpMenu->insertItem(tr("AqHBCI-&Debugger"), this, SLOT(slotDebugAqHBCI()));

  slotRebuildExportMenu();

  statusBar()->addWidget(new QLabel(tr("QBanking v%1 "
                                       "(c) 2004, 2005 Martin Preuss")
                                    .arg(VERSION),
                                    statusBar(),
                                    "CopyrightLabel"),
                         0, true);

  QObject::connect((QObject*)kb->flagStaff(),
                   SIGNAL(signalOutboxCountChanged(int)),
                   this, SLOT(slotOutboxCountChanged(int)));
  QObject::connect((QObject*)kb->flagStaff(),
                   SIGNAL(signalStatusMessage(const QString&)),
                   this, SLOT(slotStatusMessage(const QString&)));
  QObject::connect((QObject*)kb->flagStaff(),
                   SIGNAL(signalRebuildExportMenu()),
                   this, SLOT(slotRebuildExportMenu()));

}



MainWindow::~MainWindow(){
}



bool MainWindow::init() {
  GWEN_DB_NODE *db;

  db=_app->getAppData();
  assert(db);
  db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                      "gui/windows/mainWindow");
  if (db) {
    int w, h;

    w=GWEN_DB_GetIntValue(db, "width", 0, 640);
    h=GWEN_DB_GetIntValue(db, "height", 0, 480);
    resize(w, h);
  }
  _introView->init();
  _accountView->init();
  _transferView->init();
  _datedTransferView->init();
  _standingOrderView->init();
  _payeeView->init();
  _categoryView->init();
  _reportView->init();
  _jobView->init();
  return true;
}



bool MainWindow::fini() {
  GWEN_DB_NODE *db;

  _jobView->fini();
  _categoryView->fini();
  _payeeView->fini();
  _reportView->fini();
  _standingOrderView->fini();
  _datedTransferView->fini();
  _transferView->fini();
  _accountView->fini();
  _introView->fini();

  db=_app->getAppData();
  assert(db);
  GWEN_DB_ClearGroup(db, "gui/windows/mainWindow");
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "gui/windows/mainWindow/width", width());
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "gui/windows/mainWindow/height", height());
  return true;
}



bool MainWindow::setTabWidget(const QString &name) {
  QString current;
  QString qs;
  QWidget *w;
  int i;

  qs=name.lower();
  current=_tabs->currentPage()->name();
  if (current.lower()==qs)
    return true;

  for (i=0; ; i++) {
    w=_tabs->page(i);
    if (w==0)
      break;
    if (QString(w->name()).lower()==qs) {
      _tabs->setCurrentPage(i);
      return true;
    }
  }
  DBG_ERROR(0, "Tab \"%s\" not found", name.latin1());
  return false;
}



void MainWindow::slotRebuildExportMenu() {
  GWEN_DB_NODE *dbT;
  int idx;

  _exportMenu->clear();
  _exportMenu->insertItem(tr("&Edit Profiles..."), this,
                          SLOT(slotEditExports()));
  _exportMenu->insertSeparator();
  dbT=_app->getExportRules();
  assert(dbT);
  dbT=GWEN_DB_FindFirstGroup(dbT, "rule");
  idx=0;
  while(dbT) {
    const char *s;

    s=GWEN_DB_GetCharValue(dbT, "name", 0, 0);
    if (s) {
      int id;
      const char *d;
      GWEN_BUFFER *dbuf;

      dbuf=GWEN_Buffer_new(0, 256, 0, 1);
      GWEN_Buffer_AppendString(dbuf, s);
      d=GWEN_DB_GetCharValue(dbT, "short", 0, 0);
      if (d) {
        GWEN_Buffer_AppendString(dbuf, " (");
        GWEN_Buffer_AppendString(dbuf, d);
        GWEN_Buffer_AppendString(dbuf, ")");
      }
      id=_exportMenu->insertItem(GWEN_Buffer_GetStart(dbuf),
                                 this, SLOT(slotUseExport(int)));
      _exportMenu->setItemParameter(id, idx);
      GWEN_Buffer_free(dbuf);
    }
    idx++;
    dbT=GWEN_DB_FindNextGroup(dbT, "rule");
  }
}



void MainWindow::slotEditExports() {
  int rv;
  ExportEdit w(_app,
               "default", this, "ExportEdit",
               true);
  w.init();
  rv=w.exec();
  if (rv==QDialog::Accepted) {
    _app->setExportRules(w.getRules());
  }
  slotRebuildExportMenu();
  w.fini();
}



void MainWindow::slotExportTransactions(){
  int rv;
  GWEN_DB_NODE *dbProfile;

  dbProfile=GWEN_DB_Group_new("exportRule");
  ExportEdit w(_app,
               dbProfile, this, "ExportEdit",
               true);
  GWEN_DB_Group_free(dbProfile);
  w.init();
  rv=w.exec();
  if (rv==QDialog::Accepted) {
    int res;

    //DBG_NOTICE(0, "Profile is now:");
    dbProfile=w.getRule();
    assert(dbProfile);
    //GWEN_DB_Dump(dbProfile, stderr, 2);
    dbProfile=GWEN_DB_GetGroup(dbProfile, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                               "data");
    if (!dbProfile) {
      DBG_ERROR(0, "Uuups, no data?");
      abort();
    }
    res=_app->exportTransactions(dbProfile, w.getTransactions());
    if (res) {
      DBG_ERROR(0, "Error exporting transactions (%d)", res);
    }
  }
  w.fini();
}



void MainWindow::slotUseExport(int id) {
  DBG_NOTICE(0, "UseExport(%d)", id);
}



void MainWindow::slotAbout(){
  QString sAbout;

  QMessageBox::information(0,
			   tr("About QBankManager"),
			   tr("<qt>"
			      "<p>"
			      "This is QBankManager v%1<br>"
			      "(c) 2004, 2005 Martin Preuss"
			      "</p>"
			      "<p>"
			      "QBankManager is based on <b>AqBanking</b>, "
			      "the generic banking interface."
			      "</p>"
			      "<p>"
			      "Please refer to "
			      "http://www.aquamaniac.de/aqbanking/ "
			      "for details."
			      "</p>"
			      "<p>"
			      "I would very much like to thank the following "
			      "people for their important help in realizing "
                              "this project:"
			      "<ul>"
			      "<li>Christian Stimming</li>"
			      "<li>... maybe you? Please contact me if "
			      "you want to contribute as well</li>"
			      "</ul>"
			      "</p>"
			      "<br>"
			      "<p>"
			      "Library versions:"
			      "</p>"
			      "<ul>"
			      "<li>Gwenhywfar v%2</li>"
			      "<li>AqBanking v%3</li>"
                              "</ul>"
			      "</qt>"
			     )
			   .arg(QString(AQBANKING_KDE_VERSION_FULL_STRING))
			   .arg(QString(GWENHYWFAR_VERSION_FULL_STRING))
			   .arg(QString(AQBANKING_VERSION_FULL_STRING)),
                           tr("Dismiss"), 0, 0, 0);
}



void MainWindow::slotImport(){
  QBImporter w(_app, this, "Importer", true);

  if (!w.init()) {
    return;
  }
  if (w.exec()==QDialog::Accepted) {
  }
  w.fini();
}





void MainWindow::slotOutboxCountChanged(int count){
  QString s;

  s=tr("Outbox");
  if (count)
    s+=QString(" (%1)").arg(count);

  _tabs->changeTab(_jobView, s);
}



void MainWindow::slotStatusMessage(const QString &s) {
  statusBar()->message(s, 5000);
}



void MainWindow::slotDebugTransfinder() {
  TransactionFinder tf(_app,
                       _app->getTransactionMatcherRules(),
                       "default",
                       TRANSFINDER_FLAGS_USE_CATEGORY |
                       TRANSFINDER_FLAGS_EXT_PAYEES,
                       this, "TransactionFinder",
                       true);
  tf.init();
  if (tf.exec()==QDialog::Accepted) {
  }
  _app->setTransactionMatcherRules(tf.getRules());
  tf.fini();
}



void MainWindow::slotRemoveDupes(){
  CheckDuplicates w(_app, 0, "CheckDuplicates");
  w.show();
  w.check();
}



void MainWindow::slotAssignPayees(){
  AssignPayees w(_app, 0, "AssignPayees");
  w.show();
  if (!w.assign()) {
    DBG_ERROR(0, "Error assigning payees");
  }
}



void MainWindow::slotAssignCategories(){
  AssignCategories w(_app, 0, "AssignCategories");
  w.show();
  if (!w.assign()) {
    DBG_ERROR(0, "Error assigning categories");
  }
}



void MainWindow::slotCheckCategories(){
  AssignCategories w(_app, 0, "AssignCategories");
  w.show();
  if (!w.check()) {
    DBG_ERROR(0, "Error checking categories");
  }
}




void MainWindow::slotDebugAqHBCI(){
  GWEN_BUFFER *pbuf;
  QString qs;
  int rv;
  GWEN_DB_NODE *dbAppData;
  bool wasActive;

  dbAppData=_app->getAppData();
  wasActive=AB_Banking_IsProviderActive(_app->getCInterface(),
                                       "aqhbci");

  pbuf=GWEN_Buffer_new(0, 256, 0, 1);
  if (AB_Banking_FindDebugger(_app->getCInterface(),
                              "aqhbci",
                              "kde;qt;gtk;gnome",
                              pbuf)) {
    DBG_ERROR(0, "No debugger found");
    QMessageBox::critical(0,
                          tr("Debugger Not Installed"),
                          tr("<qt>"
                             "<p>"
                             "No matching debugger for this backend "
                             "installed."
                             "</p>"
                             "</qt>"),
                          tr("Dismiss"),0,0,0);
    GWEN_Buffer_free(pbuf);
    return;
  }

  qs=GWEN_Buffer_GetStart(pbuf);
  GWEN_Buffer_free(pbuf);

  if (wasActive) {
    rv=AB_Banking_SuspendProvider(_app->getCInterface(),
                                  "aqhbci");
    if (rv) {
      DBG_ERROR(0, "Error suspending backend \"%s\" (%d)",
                "aqhbci", rv);
      QMessageBox::critical(0,
                            tr("Backend Error"),
                            tr("<qt>"
                               "<p>"
                               "Error suspending the backend."
                               "</p>"
                               "<p>"
                               "To debug a backend we need "
                               "to temporarily suspend it, otherwise "
                               "your new settings would be silently "
                               "overwritten upon shutdown of the program."
                               "</p>"
                               "</qt>"),
                            tr("Dismiss"),0,0,0);
      return;
    }
  }

  QProcess wp(qs);

  if (!wp.launch(QString())) {
    QMessageBox::critical(0,
                          tr("Debugger Not Started"),
                          tr("<qt>"
                             "<p>"
                             "The debugger for this backend could "
                             "not be started."
                             "</p>"
                             "</qt>"),
                          tr("Dismiss"),0,0,0);
    if (wasActive)
      // resume provider if we suspended it
      AB_Banking_ResumeProvider(_app->getCInterface(),
                                "aqhbci");
    return;
  }

  QBProcessWatcher pwatcher(&wp,
                            tr("<qt>"
                               "<p>"
                               "Running debugger, this window will close "
                               "automatically when the debugger finishes."
                               "</p>"
                               "<p>"
                               "Please wait..."
                               "</p>"
                               "</qt>"
                              ),
                            this,
                            "ProcessWatcher",
                            true);
  pwatcher.setCaption(caption());
  pwatcher.exec();

  if (pwatcher.getDuration()<3) {
    QMessageBox::critical(0,
                          tr("Error"),
                          tr("<qt>"
                             "<p>"
                             "Wizard terminated too fast, please check "
                             "the console logs."
                             "</p>"
                             "</qt>"),
                          tr("Dismiss"),0,0,0);
  }

  if (wasActive) {
    rv=AB_Banking_ResumeProvider(_app->getCInterface(),
                                 "aqhbci");
    if (rv) {
      QMessageBox::critical(0,
                            tr("Backend Error"),
                            tr("<qt>"
                               "<p>"
                               "Could not resume the backend."
                               "</p>"
                               "</qt>"),
                            tr("Dismiss"),0,0,0);
      return;
    }
  }

}



void MainWindow::closeEvent(QCloseEvent *e){
  _app->delTransactionWindows();
  e->accept();
}




void MainWindow::slotCurrentDebug() {
  QBProgress *pr;
  int i;

  pr=new QBProgress(99,
                    QBProgress::ProgressTypeFast,
                    "Test-Progress",
                    "This is a simple test",
                    "second(s)",
                    this, "ProgressWidget",
                    Qt::WType_Dialog | Qt::WShowModal);
  if (pr->start(AB_BANKING_PROGRESS_NONE /*20*/)) {
    DBG_ERROR(0, "Could not start progress dialog");
    delete pr;
    return ;
  }
  pr->show();

  for (i=0; i<21; i++) {
    sleep(1);
    DBG_ERROR(0, "Progress %d", i);
    pr->advance(i);
    if (i==10) {
      pr->log(AB_Banking_LogLevelNotice, "Test-Notice");
    }
    if (i==15) {
      pr->log(AB_Banking_LogLevelWarn, "Test-Warning");
    }
  }

  pr->end();

  if (!pr->shouldStay()) {
    delete pr;
  }

}



