# -*- coding: ISO-8859-1 -*-

# Copyright (C) 2002 Jrg Lehmann <joerg@luga.de>
#
# This file is part of PyTone (http://www.luga.de/pytone/)
#
# PyTone is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# PyTone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PyX; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import time
import hub

# Maybe, we should generate a timer thread. Let's look...

class timer:

    """ sends events at a specified time """

    def __init__(self):
        """ constructs timer, which sends its events through eventhub """
        # each element in alarms is a tuple (alarmtime, event, repeat)
        self.alarms = []

    def process(self):
        """ check for pending events. Has to be called regularly """

        # short circuit, if not alarms are pending
        if not self.alarms: return

        acttime = time.time()
        
        for alarmtime, event, repeat in self.alarms:
            if alarmtime<=acttime:
                hub.hub.notify(event)
                self.alarms.remove((alarmtime, event, repeat))
                if repeat:
                    self.alarmsa.append((alarmtime+repeat, event, repeat))

    def sendeventat(self, event, alarmtime, repeat=0, replace=0):
        if replace:
            for i in range(len(self.alarms)):
                aalarmtime, aevent, arepeat = self.alarms[i]
                if aevent is event and arepeat==repeat:
                    self.alarms[i] = (alarmtime, event, repeat)
                    return
                
        self.alarms.append((alarmtime, event, repeat))
        
    def sendeventin(self, event, alarmtimediff, repeat=0, replace=0):
        acttime = time.time()
        self.sendeventat(event, acttime+alarmtimediff, repeat, replace)
