#!/usr/bin/python

"""
__version__ = "$Revision: 1.15 $"
__date__ = "$Date: 2002/12/28 15:16:52 $"

I'll add support for editing the .txt file scripts once we have a multi-window
framework in place and a decent way of doing at least rudimentary editing,
syntax highlighting, syntax checking, etc. In other words, not until scintilla
is running inside the PythonCard framework to give us styled text fields and
more.
"""

from PythonCardPrototype import config, dialog, model, turtle
import os
import time
from math import * # Also for export
from wxPython import wx

class TurtleBg(model.Background):

    """
    as per other samples, __init__ will go away once we are doing
    openStack, openBackground messages
    the font initialization, dc, and other wxPython code exposed below
    will be hidden as those features are added to the PythonCard
    framework
    """
    def on_openBackground(self, event):
        self.fNameTurtleScript = "scripts/4bugs.txt"

        sizer1 = wx.wxBoxSizer(wx.wxVERTICAL)
        comp = self.components
        #flags = wx.wxLEFT | wx.wxRIGHT | wx.wxBOTTOM | wx.wxALIGN_BOTTOM
        #sizer1.Add(comp.btnColor._delegate, 0, flags, 5)
        sizer1.Add(comp.bufOff, 1, wx.wxEXPAND)
        
        sizer1.Fit(self)
        sizer1.SetSizeHints(self)
        self.panel.SetSizer(sizer1)
        self.panel.SetAutoLayout(1)
        self.panel.Layout()

        self.components.bufOff.backgroundColor = 'white'
        #if wx.wxPlatform == '__WXGTK__':
        #    self.font = wx.wxFont(12, wx.wxMODERN, wx.wxNORMAL, wx.wxNORMAL)
        #else:
        #    self.font = wx.wxFont(10, wx.wxMODERN, wx.wxNORMAL, wx.wxNORMAL)
        #self.SetFocus()

        if wx.wxPlatform == '__WXMAC__':
            self.menuBar.setChecked('menuCommandsAutoRefresh', 0)
            self.components.bufOff.autoRefresh = 0

    def doDraw(self):
        starttime = time.time()

        ###dc = wxTurtle.TurtleDC(self.panel)
        ###dc.BeginDrawing()
        input = open(self.fNameTurtleScript, 'r')
        codeString = input.read()
        input.close()
        namespace = {}   # Just an empty dictionary
        exec(codeString, None, namespace)
        func = namespace['drawMain']  # or some other predefined name
        func(self.components.bufOff, self)
        if not self.components.bufOff.autoRefresh:
            self.components.bufOff.refresh()
        # in case a script doesn't cleanup after itself, get the buffer
        # back in sync with the menu
        self.components.bufOff.autoRefresh = self.menuBar.getChecked('menuCommandsAutoRefresh')
            
        ###dc.EndDrawing()
        
        stoptime = time.time()
        elapsed = stoptime - starttime
        self.statusBar.text = "Draw time: %f seconds" % (elapsed)

    def on_menuFileOpen_select(self, event):
        currentDir = os.getcwd()
        wildcard = "Turtle files (*.txt)|*.txt"
        path = 'scripts'
        filename = ''
        result = dialog.openFileDialog(self, 'Open', path, filename, wildcard)
        if result['accepted']:
            self.fNameTurtleScript = result['paths'][0]
            os.chdir(currentDir)
            self.doDraw()

    def on_menuFileDrawTurtle_select(self, event):
        self.doDraw()

    def on_menuFileExit_select(self, event):
        self.Close()

    def on_menuCommandsClear_select(self, event):
        # this is unclean and will need to be changed
        # I'll change it after I think more about what sorts
        # of commands I want to support in the menu and whether
        # they should be global or specific to individual turtles
        ###self.panel._getDelegate().Refresh()
        self.components.bufOff.clear()
        if not self.components.bufOff.autoRefresh:
            self.components.bufOff.refresh()

    def on_menuCommandsAutoRefresh_select(self, event):
        self.components.bufOff.autoRefresh = self.menuBar.getChecked('menuCommandsAutoRefresh')

if __name__ == '__main__':
    if wx.wxPlatform != '__WXMAC__KEA_FIXED':
        # now force the shell to be enabled
        config.setOption('showShell', 1)

    app = model.PythonCardApp(TurtleBg)
    app.MainLoop()
