#!/usr/bin/python

"""
__version__ = "$Revision: 1.1 $"
__date__ = "$Date: 2001/11/25 06:56:04 $"

A lot of the record structure and logic mirrors Winkler's approach used in
the textIndexer, but I coded this from scratch to see what kind of differences
would appear. I also didn't bother using a separate class to hold the internal
data structures initially, so this version will get refactored. I realized that
once I started porting the Addresses stack from HyperCard, we could use this
addresses sample to test different approaches to storage formats: ZODB, mySQL,
plain text files using lists and dictionaries, CSV text files, etc.

"""

from PythonCardPrototype import dialog, model, res
import os, sys
import pprint
import outlook

DATA_FILE = 'data.txt'
USER_DATA_FILE = 'userdata.txt'

class Addresses(model.Background):

    def on_openBackground(self, source, event):

        disableOutlook = 0
        if not outlook.WIN32_FOUND:
            disableOutlook = 1
        else:
            oOutlook = outlook.MSOutlook()
            if not oOutlook.outlookFound:
                disableOutlook = 1
        if disableOutlook:
            # use some wxPython code to disable the menu item
            # since we don't have this in the framework yet
            #menubar = self.GetMenuBar()
            #id = menubar.FindMenuItem('File', 'Import Outlook')
            #menubar.Enable(id, 0)
            self.menuBar.enable('menuFileImportOutlook', 0)
        

        self.records = []
        self.current = -1
        self.importListData()


    def doExit(self):
        # always save the records list
        # for transparent saves
        self.saveRecord(self.current)
        try:
            f = open(USER_DATA_FILE, "w")
            pprint.pprint(self.records, f)
            f.close()
            #pprint.pprint(self.records)
        except:
            pass    # argh

    # we don't have window events hooked up yet to our own event model yet
    def OnCloseWindow(self, event):
        self.doExit()
        model.Background.OnCloseWindow(self, event)


    def importListData(self):
        try:
            # if there is a user file, then use that rather than
            # example data, this prevents the data.txt file from
            # getting modified and accidentally updated in cvs
            if os.path.exists(USER_DATA_FILE):
                #addresses = eval(open(USER_DATA_FILE).read())
                addresses = res.readAndEvalFile(USER_DATA_FILE)
            else:
                #addresses = eval(open(DATA_FILE).read())
                addresses = res.readAndEvalFile(DATA_FILE)
            for c in addresses:
                self.records.append(c)
            if self.current == -1 and len(self.records) > 0:
                self.displayRecord(0)
        except:
            pass

    def on_importListData_command(self, target, event):
        self.importListData()

    def saveRecord(self, recordNumber):
        """
        it would be more efficient to set a 'dirty' flag per field
        or at least per record if any fields change
        but this still works
        """
        n = len(self.records)
        # in HyperCard there is always at least one record
        # which is not always what you want, so if we're going to
        # support 0 records our logic will be different for creating
        # an empty record initially

        # the boundary condition of no records will break the code right now        
        if recordNumber == -1:
            pass

        if n > 0 and recordNumber > -1 and recordNumber < n:
            for wName in self.components.keys():
                widget = self.components[wName]
                wClass = widget.__class__.__name__
                if wClass in ['TextField', 'TextArea'] and widget.editable:
                    self.records[recordNumber][wName] = self.components[wName].text

    def clearFields(self):
        for wName in self.components.keys():
            widget = self.components[wName]
            wClass = widget.__class__.__name__
            if wClass in ['TextField', 'TextArea'] and widget.editable:
                self.components[wName].text = ""
        
    def displayRecord(self, recordNumber):
        self.clearFields()
        self.current = recordNumber
        if self.current != -1:
            record = self.records[recordNumber]
            for fld in record.keys():
                self.components[fld].text = record[fld]

    def goPrevRecord(self):
        if len(self.records) > 1:
            prevRec = self.current - 1
            if prevRec == -1:
                prevRec = len(self.records) - 1
            self.saveRecord(self.current)
            self.displayRecord(prevRec)
            
    def goNextRecord(self):
        if len(self.records) > 1:
            nextRec = self.current + 1
            if nextRec == len(self.records):
                nextRec = 0
            self.saveRecord(self.current)
            self.displayRecord(nextRec)

    def goFirstRecord(self):
        if len(self.records) > 1:
            if self.current != 0:
                self.saveRecord(self.current)
                self.displayRecord(0)

    def goLastRecord(self):
        n = len(self.records) - 1
        if n > 0:
            if self.current != n:
                self.saveRecord(self.current)
                self.displayRecord(n)

    def findRecord(self):
        pass

    def newRecord(self):
        self.saveRecord(self.current)
        if self.current == -1:
            self.current = 0
            #self.records.append({})
        else:
            self.current += 1
        self.records.insert(self.current, {})
        self.clearFields()

    def deleteRecord(self):
        # should probably do a dialog here to give the user
        # a chance to cancel
        if self.current != -1:
            del self.records[self.current]
            if len(self.records) == 0:
                self.current = -1
        self.displayRecord(self.current)


    def on_fileImportOutlook_command(self, target, event):
        addressesToOutlookMap = {'Name':'FullName',
                                 'Company':'CompanyName',
                                 'Street':'MailingAddressStreet',
                                 'City':'MailingAddressCity',
                                 'State':'MailingAddressState',
                                 'Zip':'MailingAddressPostalCode',
                                 'Phone1':'HomeTelephoneNumber',
                                 'Phone2':'BusinessTelephoneNumber',
                                 'Phone3':'MobileTelephoneNumber',
                                 'Phone4':'Email1Address',
                                 'Notes':'Body'
                                 }
        print "attempting to load Outlook"
        oOutlook = outlook.MSOutlook()
        print "loading records..."
        oOutlook.loadRecords()
        print "importing into addresses"
        for r in oOutlook.records:
            aRecord = {}
            for fld in addressesToOutlookMap.keys():
                """
                if fld == 'Name':
                    names = addressesToOutlookMap[fld]
                     fullName = r[names[0]] + " " + r[names[1]]
                     aRecord['Name'] = fullName.strip()
                else:
                """
                aRecord[fld] = r[addressesToOutlookMap[fld]]
            self.records.append(aRecord)
        print "done importing"
        self.goNextRecord() # show that we imported at least one record

    def on_exit_command(self, menu, event):
        self.Close()


    def on_goPrev_command(self, target, event):
        self.goPrevRecord()

    def on_goNext_command(self, target, event):
        self.goNextRecord()

    def on_goFirst_command(self, target, event):
        self.goFirstRecord()

    def on_goLast_command(self, target, event):
        self.goLastRecord()

    def on_findRecord_command(self, target, event):
        dlg = dialog.FindDialog(self)
        if dlg.accepted():
            print "FindDialog result:\naccepted: %s\nText: %s\nWhole word only: %s\nCase sensitive: %s" % (dlg.accepted(),
                                                                                                          dlg.getText(),
                                                                                                          dlg.getWholeWord(),
                                                                                                          dlg.getCaseSensitive()),

        self.findRecord()

    def on_editNewCard_command(self, target, event):
        self.newRecord()

    def on_editDeleteCard_command(self, target, event):
        self.deleteRecord()

    def on_showNotes_command(self, target, event):
        if target.label == 'Show Notes':
            self.components.Notes.visible = 1
            target.label = 'Hide Notes'
        else:
            self.components.Notes.visible = 0
            target.label = 'Show Notes'



if __name__ == '__main__':
    app = model.PythonCardApp(Addresses)
    app.MainLoop()
