
"""
__version__ = "$Revision: 1.30 $"
__date__ = "$Date: 2003/07/31 22:37:06 $"
"""

from wxPython import wx
from wxPython.lib.dialogs import wxScrolledMessageDialog, wxMultipleChoiceDialog
import font

ICON_EXCLAMATION = wx.wxICON_EXCLAMATION   # Shows an exclamation mark icon.  
ICON_HAND = wx.wxICON_HAND                 # Shows an error icon.  
ICON_ERROR = wx.wxICON_ERROR               # Shows an error icon - the same as wxICON_HAND.  
ICON_QUESTION = wx.wxICON_QUESTION         # Shows a question mark icon.  
ICON_INFORMATION = wx.wxICON_INFORMATION   # Shows an information (i) icon.

BUTTON_OK = wx.wxOK                        # Show an OK button.  
BUTTON_CANCEL = wx.wxCANCEL                # Show a Cancel button.  
BUTTON_YES_NO = wx.wxYES_NO                # Show Yes and No buttons.  
BUTTON_YES_DEFAULT = wx.wxYES_DEFAULT      # Used with wxYES_NO, makes Yes button the default - which is the default behaviour.  
BUTTON_NO_DEFAULT = wx.wxNO_DEFAULT        # Used with wxYES_NO, makes No button the default.  

RETURNED_OK = wx.wxID_OK
RETURNED_CANCEL = wx.wxID_CANCEL
RETURNED_YES = wx.wxID_YES
RETURNED_NO = wx.wxID_NO

FILE_OPEN = wx.wxOPEN                      # This is an open dialog.
FILE_SAVE = wx.wxSAVE                      # This is a save dialog.
FILE_HIDE_READONLY = wx.wxHIDE_READONLY    # Hide read-only files.
# For save dialog only: prompt for a confirmation if a file will be overwritten.
FILE_OVERWRITE_PROMPT = wx.wxOVERWRITE_PROMPT
# For open dialog only: allows selecting multiple files.
FILE_MULTIPLE = wx.wxMULTIPLE
# Change the current working directory to the directory where the file(s) chosen by the user are.
FILE_CHANGE_DIR = wx.wxCHANGE_DIR  

# For dir dialog only: allow creation of new directories
DIR_NEWDIR_BUTTON = wx.wxDD_NEW_DIR_BUTTON

TEXT_MULTILINE = wx.wxTE_MULTILINE
TEXT_PASSWORD = wx.wxTE_PASSWORD

class ModalDialog :
                       
    def __init__( self, aParent ) :
        self._parent = aParent
        self._accepted = 0
        self._returned = 0
        self._dialog = None

    #def _getParent( self ) :
    #    return self._parent

    def _setDialog( self, aWxDialog ) :
        self._dialog = aWxDialog

    def _getDialog( self ) :
        return self._dialog

    # KEA I don't think we need this
    def _setAccepted( self, aBoolean ) :
        self._accepted = aBoolean

    def _showModal( self ) :
        # KEA added wxID_YES to accepted condition
        # and added a returned value
        self._returned = self._dialog.ShowModal()
        if self._returned == wx.wxID_OK or self._returned == wx.wxID_YES :
            self._accepted = 1
        # KEA don't destroy until after we get the results
        # so self._destroy() added to each dialog class below
        #self._destroy()
        self.result = {'accepted':self._accepted, 'returned':self.returned()}

    # KEA should these be getAccepted, getReturned?
    def accepted( self ) :
        return self._accepted

    # KEA added accessor for self._returned
    # should we just return numeric values instead?
    # should the the strings all be lowercase
    # Ok is actually displayed as OK in dialogs
    def returned( self ) :
        ret = self._returned
        if ret == RETURNED_OK:
            return "Ok"
        elif ret == RETURNED_CANCEL:
            return "Cancel"
        elif ret == RETURNED_YES:
            return "Yes"
        elif ret == RETURNED_NO:
            return "No"

    def _destroy( self ) :
        self._dialog.Destroy()

class FindDialog(ModalDialog):

    def __init__(self, aParent, searchText='', wholeWordsOnly=0, caseSensitive=0):
        ModalDialog.__init__( self, aParent )
        
        dlg = wx.wxDialog(aParent, -1, "Find", wx.wxDefaultPosition, wx.wxSize(370, 120))

        wx.wxStaticText(dlg, -1, 'Find what:', wx.wxPoint(7, 10))
        wSearchText = wx.wxTextCtrl(dlg, -1, searchText,
                                    wx.wxPoint(70, 7), wx.wxSize(195, -1))
        wSearchText.SetValue(searchText)
        wx.wxButton(dlg, wx.wxID_OK, "Find Next", wx.wxPoint(280, 5), wx.wxDefaultSize).SetDefault()
        wx.wxButton(dlg, wx.wxID_CANCEL, "Cancel", wx.wxPoint(280, 35), wx.wxDefaultSize)
        wWholeWord = wx.wxCheckBox(dlg, -1, 'Match whole word only',
                                wx.wxPoint(7, 35), wx.wxDefaultSize, wx.wxNO_BORDER)
        if wholeWordsOnly:
            wWholeWord.SetValue(1)
        wCase = wx.wxCheckBox(dlg, -1, 'Match case',
                            wx.wxPoint(7, 55), wx.wxDefaultSize, wx.wxNO_BORDER)
        if caseSensitive:
            wCase.SetValue(1)
        wSearchText.SetSelection(0, len(wSearchText.GetValue()))
        wSearchText.SetFocus()
        
        self._setDialog( dlg )
        self._showModal()
        self._text = wSearchText.GetValue()
        self._wholeWord = wWholeWord.GetValue()
        self._caseSensitive = wCase.GetValue()
        self._destroy()
        self.result['text'] = self._text
        self.result['wholeword'] = self._wholeWord
        self.result['casesensitive'] = self._caseSensitive

    def getText( self ) :
        return self._text

    def getWholeWord( self ) :
        return self._wholeWord

    def getCaseSensitive( self ) :
        return self._caseSensitive

def findDialog(parent, searchText='', wholeWordsOnly=0, caseSensitive=0):
    dialog = FindDialog(parent, searchText, wholeWordsOnly, caseSensitive)
    result = {'accepted':dialog.accepted(),
              'searchText': dialog.getText(),
              'wholeWordsOnly': dialog.getWholeWord(),
              'caseSensitive': dialog.getCaseSensitive()}
    return result


class ColorDialog( ModalDialog ) :
    
    def __init__( self, aParent ) :
        self._color = None
        ModalDialog.__init__( self, aParent )
        dialog = wx.wxColourDialog( self._parent ) # add color data support later
        dialog.GetColourData().SetChooseFull(1)
        self._setDialog( dialog )
        self._showModal()
        # KEA why does this work? the dialog should already be destroyed
        # by _showModal()
        self._colorData = dialog.GetColourData()
        self._color = self._colorData.GetColour().Get()
        self._destroy()
        self.result['color'] = self._color
        
    def getColor( self ) :
        return self._color

# should we just return numeric values instead?
# should the the strings all be lowercase
# Ok is actually displayed as OK in dialogs
def returnedString(ret):
    if ret == RETURNED_OK:
        return "Ok"
    elif ret == RETURNED_CANCEL:
        return "Cancel"
    elif ret == RETURNED_YES:
        return "Yes"
    elif ret == RETURNED_NO:
        return "No"

def colorDialog(parent):
    dialog = wx.wxColourDialog(parent)
    dialog.GetColourData().SetChooseFull(1)
    returned = dialog.ShowModal()
    if returned == wx.wxID_OK or returned == wx.wxID_YES:
        accepted = 1
    else:
        accepted = 0
    colorData = dialog.GetColourData()
    color = colorData.GetColour().Get()
    dialog.Destroy()
    return {'accepted':accepted, 'returned':returnedString(returned), 'color':color}

# do not rely on the return value of getFont
# I just added this today 2001-07-28 and haven't
# done enough with fonts to know what I need to use and ignore
class FontDialog( ModalDialog ) :
    
    def __init__( self, aParent, aFont=None) :
        self._color = None
        self._font = None
        self._fontDescription = None
        ModalDialog.__init__( self, aParent )
        # RDS: You have to pass a wxFontData instance below,
        # None causes a seg fault.
        aFontData = wx.wxFontData()
        if aFont is not None:
            aFontData.SetInitialFont(aFont._getFont())
            
        dialog = wx.wxFontDialog( self._parent, aFontData ) # add font data support later
        self._setDialog( dialog )
        self._showModal()
        # KEA why does this work? the dialog should already be destroyed
        # by _showModal()
        if self.accepted():
            fontData = dialog.GetFontData()
            self._color = fontData.GetColour().Get()
            fontWx = fontData.GetChosenFont()
            self._fontDescription = font.fontDescription(fontWx)
            self._font = font.Font(self._fontDescription)
            #self._font = (font.GetFamily(), font.GetFaceName(), font.GetPointSize(), font.GetStyle())
            #self._font = (font.GetFaceName(), font.GetPointSize())
        self._destroy()
        self.result['color'] = self._color
        self.result['font'] = self._font

    def getColor( self ) :
        return self._color

    def getFont( self ) :
        return self._font

def fontDialog(parent, aFont=None):
    return FontDialog(parent, aFont).result

class TextEntryDialog( ModalDialog ) :
    
    def __init__( self, aParent, aWindowTitle, aMessage, aDefaultText, aStyle=0 ) :
        self._text = None
        ModalDialog.__init__( self, aParent )
        dialog = wx.wxTextEntryDialog( self._parent, 
                                    aMessage,
                                    aWindowTitle,
                                    aDefaultText,
                                    aStyle | wx.wxOK | wx.wxCANCEL )
        self._setDialog( dialog )
        self._showModal()
        # KEA why does this work? the dialog should already be destroyed
        # by _showModal()
        self._text = dialog.GetValue()
        self._destroy()
        self.result['text'] = self._text
        
    def getText( self ) :
        return self._text

def textEntryDialog(aParent, aWindowTitle, aMessage, aDefaultText, aStyle=0):
    return TextEntryDialog(aParent, aWindowTitle, aMessage, aDefaultText, aStyle).result


class MessageDialog( ModalDialog ) :
    
    def __init__( self, aParent, aMessage, aTitle,
                  aIcon = ICON_INFORMATION,
                  aButtons = BUTTON_OK | BUTTON_CANCEL) :
        ModalDialog.__init__( self, aParent )
        dialog = wx.wxMessageDialog(self._parent, 
                                  aMessage,
                                  aTitle, 
                                  aIcon | aButtons )
        self._setDialog( dialog )
        self._showModal()
        self._destroy()

def messageDialog(aParent, aMessage, aTitle,
                  aIcon = ICON_INFORMATION,
                  aButtons = BUTTON_OK | BUTTON_CANCEL):
    return MessageDialog(aParent, aMessage, aTitle, aIcon, aButtons).result


# KEA this class should go away
# it does the exact same thing as the default for MessageDialog
"""
class ConfirmationDialog( ModalDialog ) :
    
    def __init__( self, aParent, aMessage, aTitle ) :
        ModalDialog.__init__( self, aParent )
        dialog = wxMessageDialog( self._parent, 
                                  aMessage,
                                  aTitle, 
                                  ICON_INFORMATION | BUTTON_OK | BUTTON_CANCEL )
        self._setDialog( dialog )
        self._showModal()
"""

# KEA alerts are common, so providing a class rather than requiring the user code
# to set up the right icons and buttons with MessageDialog
class AlertDialog(MessageDialog) :
    def __init__(self, aParent, aMessage, aTitle) :
        MessageDialog.__init__(self, aParent, aMessage, aTitle, ICON_EXCLAMATION, BUTTON_OK)

def alertDialog(aParent, aMessage, aTitle):
    return AlertDialog(aParent, aMessage, aTitle).result

class ScrolledMessageDialog( ModalDialog ) :
    
    def __init__( self, aParent, aMessage, aTitle ) :
        ModalDialog.__init__( self, aParent )
        dialog = wxScrolledMessageDialog( self._parent, 
                                  aMessage,
                                  aTitle)
        self._setDialog( dialog )
        self._showModal()
        self._destroy()

def scrolledMessageDialog(aParent, aMessage, aTitle):
    return ScrolledMessageDialog(aParent, aMessage, aTitle).result


class FileDialog( ModalDialog ) :
 
    def __init__(self, aParent, aMessage, aPath, aFileName, aFilter,
                  aStyle=FILE_OPEN | FILE_MULTIPLE):
        ModalDialog.__init__( self, aParent )
        self._message = aMessage
        self._path = aPath
        self._fileName = aFileName
        self._filter = aFilter
        self._value = None
        self._paths = None

        dialog = wx.wxFileDialog( self._parent, 
                               aMessage,
                               aPath, 
                               aFileName, 
                               aFilter, 
                               aStyle )

        self._setDialog( dialog )

        # KEA changed to self, was:
        # ModalDialog._showModal( self )
        self._showModal()

        if self.accepted() :
            self._paths = self._dialog.GetPaths()
        self._destroy()
        self.result['paths'] = self._paths
 
    def getPaths( self ) :
        return self._paths

def fileDialog(aParent, aMessage, aPath, aFileName, aFilter, aStyle=FILE_OPEN | FILE_MULTIPLE):
    return FileDialog(aParent, aMessage, aPath, aFileName, aFilter, aStyle).result

def openFileDialog(parent=None, title='Open', directory='', filename='', wildcard='All Files (*.*)|*.*', style=FILE_OPEN | FILE_MULTIPLE):
    return FileDialog(parent, title, directory, filename, wildcard, style).result

def saveFileDialog(parent=None, title='Save', directory='', filename='', wildcard='All Files (*.*)|*.*', style=FILE_SAVE | FILE_HIDE_READONLY | FILE_OVERWRITE_PROMPT):
    return FileDialog(parent, title, directory, filename, wildcard, style).result

class DirectoryDialog( ModalDialog ) :
 
    def __init__( self, aParent, aMessage, aPath, aStyle=DIR_NEWDIR_BUTTON ) :
        ModalDialog.__init__( self, aParent )
        self._message = aMessage
        self._path = aPath
        self._value = None
        self._setDialog( wx.wxDirDialog( self._parent, aMessage, aPath, aStyle ) )

        if self._message is not None :
            self._dialog.SetMessage( self._message )

        if self._path is not None :
            self._dialog.SetPath( self._path )

        # KEA changed to self, was:
        # ModalDialog._showModal( self )
        self._showModal()

        if self.accepted() :
            self._value = self._dialog.GetPath()
        self._destroy()
        self.result['path'] = self._value
 
    def getPath( self ) :
        return self._value

def directoryDialog(aParent, aMessage, aPath, aStyle=DIR_NEWDIR_BUTTON):
    return DirectoryDialog(aParent, aMessage, aPath, aStyle).result


class SingleChoiceDialog( ModalDialog ) :
    
    def __init__( self, aParent, aWindowTitle, aMessage, aList,
                  aStyle=wx.wxOK | wx.wxCANCEL | wx.wxCENTRE) :
        self._text = None
        ModalDialog.__init__( self, aParent )
        # KEA 2003-07-30
        # added wx.wxDEFAULT_DIALOG_STYLE below
        # to workaround wxPython 2.4.1.2 bug
        dialog = wx.wxSingleChoiceDialog( self._parent, 
                                    aMessage,
                                    aWindowTitle,
                                    aList,
                                    style=aStyle | wx.wxDEFAULT_DIALOG_STYLE )
        self._setDialog( dialog )
        self._showModal()
        # KEA why does this work? the dialog should already be destroyed
        # by _showModal()
        self._text = dialog.GetStringSelection()
        self._destroy()
        self.result['selection'] = self._text
        
    def getSelection( self ) :
        return self._text

def singleChoiceDialog(aParent, aWindowTitle, aMessage, aList,
                  aStyle=wx.wxOK | wx.wxCANCEL | wx.wxCENTRE):
    return SingleChoiceDialog(aParent, aWindowTitle, aMessage, aList, aStyle).result


class MultipleChoiceDialog( ModalDialog ) :
    
    def __init__( self, aParent, aWindowTitle, aMessage, aList) :
        self._list = None
        ModalDialog.__init__( self, aParent )
        dialog = wxMultipleChoiceDialog( self._parent, 
                                    aMessage,
                                    aWindowTitle,
                                    aList)
        self._setDialog( dialog )
        self._showModal()
        # KEA why does this work? the dialog should already be destroyed
        # by _showModal()
        self._list = dialog.GetValueString()
        self._destroy()
        self.result['selection'] = self._list
        
    def getSelection( self ) :
        return self._list

def multipleChoiceDialog(aParent, aWindowTitle, aMessage, aList):
    return MultipleChoiceDialog(aParent, aWindowTitle, aMessage, aList).result
