
"""
__version__ = "$Revision: 1.4 $"
__date__ = "$Date: 2002/02/16 18:35:41 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import binding, event, registry, widget


class StaticLineSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'StaticLine'
        self.parent = 'Widget'
        self.parentName = self.parent
        self._attributes.update({
            'layout' : { 'presence' : 'optional', 'default' : 'horizontal', 'values' : [ 'horizontal', 'vertical' ]  }
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


class StaticLine(widget.Widget, wx.wxStaticLine):
    """
    A static line is just a line which may be used to separate
    a groups of controls. The line may be only vertical or horizontal.
    """

    _spec = StaticLineSpec()

    def __init__( self, aParent, aResource ) :
        widget.Widget.__init__( self, aParent, aResource )

        wx.wxStaticLine.__init__(
            self,
            aParent, 
            self.getId(), 
            wx.wxPoint( aResource.position[ 0 ], aResource.position[ 1 ] ), 
            wx.wxSize( aResource.size[ 0 ], aResource.size[ 1 ] ),
            style = self.__getLayout( aResource.layout ) | wx.wxCLIP_SIBLINGS,
            name = aResource.name 
        )

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

        attributes = ['_layout']
        self._createAttributes(attributes)
        # set attributes directly that can only be set at initialization
        self._layout = aResource.layout

    def _bindEvents(self):
        adapter = binding.wxPython_EventBinding(self)
        adapter.bindEvents()

    def __getLayout( self, aString  ) :
        if aString == 'horizontal' :
            return wx.wxLI_HORIZONTAL
        elif aString == 'vertical' :
            return wx.wxLI_VERTICAL
        else :
            raise 'invalid StaticLine.layout value: ', aString

    #def _bindEvents( self ) :
    #    pass

    #def _setHelpText( self, aString ) :
    #    pass

    def _setLayout( self, aString ) :
        raise AttributeError, "layout attribute is read-only"

    def _getLayout( self ) :
        return self._layout


registry.getRegistry().register( sys.modules[__name__].StaticLine )
