
"""
__version__ = "$Revision: 1.3 $"
__date__ = "$Date: 2002/03/26 06:12:00 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import binding, registry, widget

class GaugeSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'Gauge'
        self.parent = 'Widget'
        self.parentName = self.parent
        self._attributes.update({ 
            'layout' : { 'presence' : 'optional', 'default' : 'horizontal', 'values' : [ 'horizontal', 'vertical' ]  },
            'max' : { 'presence' : 'optional', 'default' : 100 }, 
            'value' : { 'presence' : 'optional', 'default' : 0 } 
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


class Gauge(widget.Widget, wx.wxGauge):
    """
    A gauge component.
    """

    _spec = GaugeSpec()
    
    def __init__( self, aParent, aResource ) :
        widget.Widget.__init__( self, aParent, aResource )

        wx.wxGauge.__init__(
            self,
            aParent, 
            self.getId(), 
            aResource.max,
            wx.wxPoint( aResource.position[ 0 ], aResource.position[ 1 ] ), 
            wx.wxSize( aResource.size[ 0 ], aResource.size[ 1 ] ), 
            style= self.__getLayout( aResource.layout ) | wx.wxGA_SMOOTH | wx.wxCLIP_SIBLINGS,
            name = aResource.name 
        )

        if not hasattr(self.__class__, '_getValue'):
            self.__class__._getValue = self.__class__.GetValue
        if not hasattr(self.__class__, '_setValue'):
            self.__class__._setValue = self.__class__.SetValue
        if not hasattr(self.__class__, '_getMax'):
            self.__class__._getMax = self.__class__.GetRange
        if not hasattr(self.__class__, '_setMax'):
            self.__class__._setMax = self.__class__.SetRange

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

        self.SetValue(aResource.value)

        attributes = ['_layout']
        self._createAttributes(attributes)
        self._layout = aResource.layout

    def _bindEvents(self):
        adapter = binding.wxPython_EventBinding(self)
        adapter.bindEvents()

    def __getLayout( self, aString  ) :
        if aString == 'horizontal' :
            return wx.wxGA_HORIZONTAL
        elif aString == 'vertical' :
            return wx.wxGA_VERTICAL
        else :
            raise 'invalid Gauge.layout value: ', aString
            
    def _getLayout( self ) :
        return self._layout

    def _setLayout( self, aString ) :
        raise AttributeError, "layout attribute is read-only"


registry.getRegistry().register( sys.modules[__name__].Gauge )
