
"""
__version__ = "$Revision: 1.15 $"
__date__ = "$Date: 2004/03/17 23:26:10 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import binding, event, registry, widget

class ComboBoxSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'ComboBox'
        self.parent = 'Widget'
        self.parentName = self.parent
        self.events.extend([event.SelectEvent,
                            event.KeyPressEvent,
                            event.KeyDownEvent, 
                            event.KeyUpEvent,
                            event.TextEnterEvent,
                            event.TextUpdateEvent])
        self._attributes.update({ 
            'text' : { 'presence' : 'optional', 'default' : '' },
            'items' : { 'presence' : 'optional', 'default' : [] },
            'selected' : { 'presence' : 'optional', 'default' : None }
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()

class ComboBox(widget.Widget, wx.wxComboBox):
    """
    A combobox menu.
    """

    _spec = ComboBoxSpec()

    def __init__( self, aParent, aResource ) :
        widget.Widget.__init__( self, aParent, aResource )

        wx.wxComboBox.__init__(
            self,
            aParent, 
            self.getId(),
            '',
            wx.wxPoint( aResource.position[ 0 ], aResource.position[ 1 ] ), 
            wx.wxSize( aResource.size[ 0 ], aResource.size[ 1 ] ), 
            aResource.items,
            style =  wx.wxCB_DROPDOWN  | wx.wxCLIP_SIBLINGS,
            name = aResource.name 
        )

        if not hasattr(self.__class__, '_getText'):
            self.__class__._getText = self.__class__.GetValue
        if not hasattr(self.__class__, '_setText'):
            self.__class__._setText = self.__class__.SetValue

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

        # KEA 2001-08-12
        # need to fix this, these are supposed to be optional
        if aResource.selected != "" and aResource.selected :
            self._setSelection( aResource.selected )
        if aResource.text != '':
            self.SetValue(aResource.text)

    def _bindEvents(self):
        adapter = ComboBoxEventBinding(self)
        adapter.bindEvents()

    def _getItems(self):
        items = []
        try:
            for i in range(self.GetCount()):
                items.append(self.GetString(i))
        except:
            pass
        return items

    def _setItems(self, items):
        self.Clear()
        for item in items :
            self.Append(item)

    def _getSelection(self):
        try:
            return self.GetStringSelection()
        except:
            return ''

    def _setSelection(self, s):
        if s is None or s == '':
            return
        elif isinstance(s, int):
            self.SetSelection(s)
        else:
            self._setStringSelection(s)

    def _setStringSelection(self, s):
        self.SetSelection(self.FindString(s))

    # KEA 2001-08-14
    # temporary fix
    # naming of selected, selection, stringSelection, etc. needs to be clarified
    # and standardized across List, RadioGroup, Choice
    # and then spec.py, debug.py, etc. needs to be updated
    def _getSelected( self ) :
        return self.GetStringSelection()

    def _getStringSelection( self ) :
        return self.GetStringSelection()

    def _setSelected( self, aString ) :
        self._setStringSelection( aString )

    def append( self, aString ) :
        self.Append( aString )


class ComboBoxEventBinding( binding.wxPython_EventBinding ) :
    """
    Bind the Events supported by event.ComboBox to wxPython.
    """
    def __init__( self, aComponent ) :
        binding.wxPython_EventBinding.__init__( self, aComponent )

    def bindEvent( self, aEventClass ) :
        parent = self._component._parent

        if aEventClass is event.KeyDownEvent :
            wx.EVT_KEY_DOWN( self._component, self._dispatch )
        elif aEventClass is event.KeyUpEvent :
            wx.EVT_KEY_UP( self._component, self._dispatch )
        elif aEventClass is event.KeyPressEvent :
            wx.EVT_CHAR( self._component, self._dispatch )
        elif aEventClass is event.TextEnterEvent :
            wx.EVT_TEXT_ENTER( parent, self._component.getId(), self._dispatch )
        elif aEventClass is event.TextUpdateEvent :
            wx.EVT_TEXT( parent, self._component.getId(), self._dispatch )
        elif aEventClass is event.SelectEvent :
            wx.EVT_COMBOBOX( parent, self._component.getId(), self._dispatch )

    def _dispatch( self, aWxEvent ) :
        # Call our superclass to dispatch the standard mouse
        # events that every widget should get.
        if binding.wxPython_EventBinding._dispatch( self, aWxEvent ) :
            return

        evt = None

        if aWxEvent.GetEventType() == wx.wxEVT_KEY_DOWN :
            evt = self._createEvent( event.KeyDownEvent, aWxEvent )
        if aWxEvent.GetEventType() == wx.wxEVT_KEY_UP :
            evt = self._createEvent( event.KeyUpEvent, aWxEvent )
        if aWxEvent.GetEventType() == wx.wxEVT_CHAR :
            evt = self._createEvent( event.KeyPressEvent, aWxEvent )
        if aWxEvent.GetEventType() == wx.wxEVT_COMMAND_TEXT_ENTER :
            evt = self._createEvent( event.TextEnterEvent, aWxEvent )
        if aWxEvent.GetEventType() == wx.wxEVT_COMMAND_TEXT_UPDATED :
            evt = self._createEvent( event.TextUpdateEvent, aWxEvent )
        if aWxEvent.GetEventType() == wx.wxEVT_COMMAND_COMBOBOX_SELECTED :
            evt = self._createEvent( event.SelectEvent, aWxEvent )

        if evt is not None :
            self._component._notifyEventListeners( evt )
            if not evt.getUsed():
                aWxEvent.Skip()

registry.getRegistry().register(sys.modules[__name__].ComboBox)


