
"""
__version__ = "$Revision: 1.9 $"
__date__ = "$Date: 2004/03/17 23:26:10 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import binding, event, registry, widget

class ChoiceSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'Choice'
        self.parent = 'Widget'
        self.parentName = self.parent
        self.events.extend( [ event.SelectEvent ] )
        self._attributes.update({ 
            'items' : { 'presence' : 'optional', 'default' : [] },
            'selected' : { 'presence' : 'optional', 'default' : None }
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()

class Choice(widget.Widget, wx.wxChoice):
    """
    A popup menu.
    """

    _spec = ChoiceSpec()

    def __init__( self, aParent, aResource ) :
        attributes = ['_items']
        self._createAttributes(attributes)
        widget.Widget.__init__( self, aParent, aResource )

        wx.wxChoice.__init__(
            self,
            aParent, 
            self.getId(), 
            wx.wxPoint( aResource.position[ 0 ], aResource.position[ 1 ] ), 
            wx.wxSize( aResource.size[ 0 ], aResource.size[ 1 ] ), 
            aResource.items,
            style =  wx.wxCLIP_SIBLINGS,
            name = aResource.name 
        )

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

        # KEA 2001-08-12
        # need to fix this, these are supposed to be optional
        self._items = aResource.items
        self._setSelection( aResource.selected )

    def _bindEvents(self):
        adapter = ChoiceEventBinding(self)
        adapter.bindEvents()

    def _getItems( self ) :
        return self._items

    def _setItems( self, items ) :
        self._items = []
        self.Clear()
        for item in items :
            self._items.append(item)
            self.Append( item )

    def _getSelection(self):
        return self.GetStringSelection()

    def _setSelection(self, s):
        if s is None or s == '':
            return
        elif isinstance(s, int):
            self.SetSelection(s)
        else:
            self.SetStringSelection(s)

    def _setStringSelection(self, s):
        self.SetStringSelection(s)

    # KEA 2001-08-14
    # temporary fix
    # naming of selected, selection, stringSelection, etc. needs to be clarified
    # and standardized across List, RadioGroup, Choice
    # and then spec.py, debug.py, etc. needs to be updated
    def _getSelected( self ) :
        return self.GetStringSelection()

    def _getStringSelection( self ) :
        return self.GetStringSelection()

    def _setSelected( self, aString ) :
        self.SetStringSelection( aString )

    def append( self, aString ) :
        self.Append( aString )


class ChoiceEventBinding( binding.wxPython_EventBinding ) :
    """
    Bind the Events supported by event.Choice to wxPython.
    """
    def __init__( self, aComponent ) :
        binding.wxPython_EventBinding.__init__( self, aComponent )

    def bindEvent( self, aEventClass ) :
        parent = self._component._parent

        if aEventClass is event.SelectEvent :
            wx.EVT_CHOICE( parent, self._component.getId(), self._dispatch )

    def _dispatch( self, aWxEvent ) :
        # Call our superclass to dispatch the standard mouse
        # events that every widget should get.
        if binding.wxPython_EventBinding._dispatch( self, aWxEvent ) :
            return

        evt = None

        if aWxEvent.GetEventType() == wx.wxEVT_COMMAND_CHOICE_SELECTED :
            evt = self._createEvent( event.SelectEvent, aWxEvent )

        if evt is not None :
            self._component._notifyEventListeners( evt )

registry.getRegistry().register( sys.modules[__name__].Choice )


