%module slang

%{
#ifdef WIN32
#include <slang.h>
#else
#include "slconfig.h"

#ifdef HAVE_SLANG_H
#include <slang.h>
#endif

#ifdef HAVE_SLANG_SLANG_H
#include <slang/slang.h>
#endif
#endif

extern void SLsmg_print(char *str)
{
    SLsmg_print(str);
}

%}

// -----------------------------------------------------------------------------

extern int SLang_init_tty (int, int, int);
/* Initializes the tty for single character input.  If the first parameter *p1
 * is in the range 0-255, it will be used for the abort character;
 * otherwise, (unix only) if it is -1, the abort character will be the one
 * used by the terminal.  If the second parameter p2 is non-zero, flow
 * control is enabled.  If the last parmeter p3 is zero, output processing
 * is NOT turned on.  A value of zero is required for the screen management
 * routines. Returns 0 upon success. In addition, if SLang_TT_Baud_Rate ==
 * 0 when this function is called, SLang will attempt to determine the
 * terminals baud rate.  As far as the SLang library is concerned, if
 * SLang_TT_Baud_Rate is less than or equal to zero, the baud rate is
 * effectively infinite.
 */

extern void SLang_reset_tty (void);

//extern unsigned long SLtt_Num_Chars_Output;
//extern int SLtt_Baud_Rate;

typedef unsigned long SLtt_Char_Type;

#define SLTT_BOLD_MASK	0x01000000
#define SLTT_BLINK_MASK	0x02000000
#define SLTT_ULINE_MASK	0x04000000
#define SLTT_REV_MASK	0x08000000
#define SLTT_ALTC_MASK  0x10000000

extern int SLtt_Screen_Rows;
extern int SLtt_Screen_Cols;
extern int SLtt_Term_Cannot_Insert;
extern int SLtt_Term_Cannot_Scroll;
extern int SLtt_Use_Ansi_Colors;
extern int SLtt_Ignore_Beep;
#ifdef REAL_UNIX_SYSTEM
extern int SLtt_Force_Keypad_Init;
#endif

#ifndef IBMPC_SYSTEM
//extern char *SLtt_Graphics_Char_Pairs;
#endif

#ifndef __GO32__
#if defined(VMS) || defined(REAL_UNIX_SYSTEM)
extern int SLtt_Blink_Mode;
extern int SLtt_Use_Blink_For_ACS;
extern int SLtt_Newline_Ok;
extern int SLtt_Has_Alt_Charset;
extern int SLtt_Has_Status_Line;       /* if 0, NO.  If > 0, YES, IF -1, ?? */
# ifndef VMS
extern int SLtt_Try_Termcap;
# endif
#endif
#endif

#if defined(IBMPC_SYSTEM)
extern int SLtt_Msdos_Cheap_Video;
#endif

extern int SLtt_flush_output (void);
extern void SLtt_set_scroll_region(int, int);
extern void SLtt_reset_scroll_region(void);
extern void SLtt_reverse_video (int);
// extern void SLtt_bold_video (void);
extern void SLtt_begin_insert(void);
extern void SLtt_end_insert(void);
extern void SLtt_del_eol(void);
extern void SLtt_goto_rc (int, int);
extern void SLtt_delete_nlines(int);
extern void SLtt_delete_char(void);
extern void SLtt_erase_line(void);
extern void SLtt_normal_video(void);
extern void SLtt_cls(void);
extern void SLtt_beep(void);
extern void SLtt_reverse_index(int);
extern void SLtt_smart_puts(unsigned short *, unsigned short *, int, int);
extern void SLtt_write_string (char *);
extern void SLtt_putchar(char);
extern int SLtt_init_video (void);
extern int SLtt_reset_video (void);
extern void SLtt_get_terminfo(void);
extern void SLtt_get_screen_size (void);
extern int SLtt_set_cursor_visibility (int);

extern int SLtt_set_mouse_mode (int, int);

#if defined(VMS) || defined(REAL_UNIX_SYSTEM)
extern int SLtt_initialize (char *);
extern void SLtt_enable_cursor_keys(void);
extern void SLtt_set_term_vtxxx(int *);
extern void SLtt_set_color_esc (int, char *);
extern void SLtt_wide_width(void);
extern void SLtt_narrow_width(void);
extern void SLtt_set_alt_char_set (int);
extern int SLtt_write_to_status_line (char *, int);
extern void SLtt_disable_status_line (void);
# ifdef REAL_UNIX_SYSTEM
   extern char *SLtt_tgetstr (char *);
   extern int SLtt_tgetnum (char *);
   extern int SLtt_tgetflag (char *);
   extern char *SLtt_tigetent (char *);
   extern char *SLtt_tigetstr (char *, char **);
   extern int SLtt_tigetnum (char *, char **);
# endif
#endif

//#if !defined(WIN32)
#ifdef  REAL_UNIX_SYSTEM
extern SLtt_Char_Type SLtt_get_color_object (int);
extern void SLtt_set_color_object (int, SLtt_Char_Type);
extern void SLtt_add_color_attribute (int, SLtt_Char_Type);
extern void SLtt_set_color_fgbg (int, SLtt_Char_Type, SLtt_Char_Type);
#endif

extern void SLtt_set_color (int, char *, char *, char *);
extern void SLtt_set_mono (int, char *, SLtt_Char_Type);

/*}}}*/

extern void SLsmg_fill_region (int, int, unsigned int, unsigned int, unsigned char);
extern void SLsmg_set_char_set (int);
#ifndef IBMPC_SYSTEM
//extern int SLsmg_Scroll_Hash_Border;
#endif
extern int SLsmg_suspend_smg (void);
extern int SLsmg_resume_smg (void);
extern void SLsmg_erase_eol (void);
extern void SLsmg_gotorc (int, int);
extern void SLsmg_erase_eos (void);
extern void SLsmg_reverse_video (void);
extern void SLsmg_set_color (int);
extern void SLsmg_normal_video (void);
extern void SLsmg_print (char *);
extern void SLsmg_vprintf (char *, va_list);
extern void SLsmg_write_string (char *);
extern void SLsmg_write_nstring (char *, unsigned int);
extern void SLsmg_write_char (char);
extern void SLsmg_write_nchars (char *, unsigned int);
extern void SLsmg_write_wrapped_string (char *, int, int, unsigned int, unsigned int, int);
extern void SLsmg_cls (void);
extern void SLsmg_refresh (void);
extern void SLsmg_touch_lines (int, unsigned int);
extern int SLsmg_init_smg (void);
extern void SLsmg_reset_smg (void);
extern unsigned short SLsmg_char_at(void);
extern void SLsmg_set_screen_start (int *, int *);
extern void SLsmg_draw_hline (unsigned int);
extern void SLsmg_draw_vline (int);
extern void SLsmg_draw_object (int, int, unsigned char);
extern void SLsmg_draw_box (int, int, unsigned int, unsigned int);
extern int SLsmg_get_column(void);
extern int SLsmg_get_row(void);
extern void SLsmg_forward (int);
extern void SLsmg_write_color_chars (unsigned short *, unsigned int);
extern unsigned int SLsmg_read_raw (unsigned short *, unsigned int);
extern unsigned int SLsmg_write_raw (unsigned short *, unsigned int);
extern void SLsmg_set_color_in_region (int, int, int, unsigned int, unsigned int);
extern int SLsmg_Display_Eight_Bit;
extern int SLsmg_Tab_Width;

#define SLSMG_NEWLINE_IGNORED	0      /* default */
#define SLSMG_NEWLINE_MOVES	1      /* moves to next line, column 0 */
#define SLSMG_NEWLINE_SCROLLS	2      /* moves but scrolls at bottom of screen */
#define SLSMG_NEWLINE_PRINTABLE	3      /* prints as ^J */
extern int SLsmg_Newline_Behavior;
extern int SLsmg_Backspace_Moves;

#ifdef IBMPC_SYSTEM
# define SLSMG_HLINE_CHAR	0xC4
# define SLSMG_VLINE_CHAR	0xB3
# define SLSMG_ULCORN_CHAR	0xDA
# define SLSMG_URCORN_CHAR	0xBF
# define SLSMG_LLCORN_CHAR	0xC0
# define SLSMG_LRCORN_CHAR	0xD9
# define SLSMG_RTEE_CHAR	0xB4
# define SLSMG_LTEE_CHAR	0xC3
# define SLSMG_UTEE_CHAR	0xC2
# define SLSMG_DTEE_CHAR	0xC1
# define SLSMG_PLUS_CHAR	0xC5
/* There are several to choose from: 0xB0, 0xB1, and 0xB2 */
# define SLSMG_CKBRD_CHAR	0xB0
#else
# define SLSMG_HLINE_CHAR	'q'
# define SLSMG_VLINE_CHAR	'x'
# define SLSMG_ULCORN_CHAR	'l'
# define SLSMG_URCORN_CHAR	'k'
# define SLSMG_LLCORN_CHAR	'm'
# define SLSMG_LRCORN_CHAR	'j'
# define SLSMG_CKBRD_CHAR	'a'
# define SLSMG_RTEE_CHAR	'u'
# define SLSMG_LTEE_CHAR	't'
# define SLSMG_UTEE_CHAR	'w'
# define SLSMG_DTEE_CHAR	'v'
# define SLSMG_PLUS_CHAR	'n'
#endif

#ifndef IBMPC_SYSTEM
# define SLSMG_COLOR_BLACK		0x000000
# define SLSMG_COLOR_RED		0x000001
# define SLSMG_COLOR_GREEN		0x000002
# define SLSMG_COLOR_BROWN		0x000003
# define SLSMG_COLOR_BLUE		0x000004
# define SLSMG_COLOR_MAGENTA		0x000005
# define SLSMG_COLOR_CYAN		0x000006
# define SLSMG_COLOR_LGRAY		0x000007
# define SLSMG_COLOR_GRAY		0x000008
# define SLSMG_COLOR_BRIGHT_RED		0x000009
# define SLSMG_COLOR_BRIGHT_GREEN	0x00000A
# define SLSMG_COLOR_BRIGHT_BROWN	0x00000B
# define SLSMG_COLOR_BRIGHT_BLUE	0x00000C
# define SLSMG_COLOR_BRIGHT_CYAN	0x00000D
# define SLSMG_COLOR_BRIGHT_MAGENTA	0x00000E
# define SLSMG_COLOR_BRIGHT_WHITE	0x00000F
#endif

extern void SLsmg_set_terminal_info (SLsmg_Term_Type *);

/*}}}*/

/*{{{ SLang Keypad Interface */

#define SL_KEY_ERR		0xFFFF

#define SL_KEY_UP		0x101
#define SL_KEY_DOWN		0x102
#define SL_KEY_LEFT		0x103
#define SL_KEY_RIGHT		0x104
#define SL_KEY_PPAGE		0x105
#define SL_KEY_NPAGE		0x106
#define SL_KEY_HOME		0x107
#define SL_KEY_END		0x108
#define SL_KEY_A1		0x109
#define SL_KEY_A3		0x10A
#define SL_KEY_B2		0x10B
#define SL_KEY_C1		0x10C
#define SL_KEY_C3		0x10D
#define SL_KEY_REDO		0x10E
#define SL_KEY_UNDO		0x10F
#define SL_KEY_BACKSPACE	0x110
#define SL_KEY_ENTER		0x111
#define SL_KEY_IC		0x112
#define SL_KEY_DELETE		0x113

#define SL_KEY_F0		0x200
#define SL_KEY_F(X)		(SL_KEY_F0 + X)

/* I do not intend to use keysymps > 0x1000.  Applications can use those. */
/* Returns 0 upon success or -1 upon error. */
extern int SLkp_define_keysym (char *, unsigned int);

/* This function must be called AFTER SLtt_get_terminfo and not before. */
extern int SLkp_init (void);

/* This function uses SLang_getkey and assumes that what ever initialization
 * is required for SLang_getkey has been performed.
 */
extern unsigned int SLang_getkey (void);
extern int SLkp_getkey (void);
extern int SLang_input_pending (int);

/*}}}*/

/*{{{ SLang Scroll Interface */

extern int SLscroll_find_top (SLscroll_Window_Type *);
extern int SLscroll_find_line_num (SLscroll_Window_Type *);
extern unsigned int SLscroll_next_n (SLscroll_Window_Type *, unsigned int);
extern unsigned int SLscroll_prev_n (SLscroll_Window_Type *, unsigned int);
extern int SLscroll_pageup (SLscroll_Window_Type *);
extern int SLscroll_pagedown (SLscroll_Window_Type *);

/*}}}*/
