#!/usr/bin/env python
from __future__ import generators
from SimPy.Simulation import *
from random import Random,expovariate,uniform
# MMC.py simulation of an M/M/c/FCFS/inft/infty queue
# 2004 Dec updated and simplified
#  $Revision: 1.1.1.5 $ $Author: kgmuller $ $Date: 2006/02/02 13:35:45 $

"""Simulation of an M/M/c queue

Jobs arrive at random into a c-server queue with
exponential service-time distribution. Simulate to
determine the average  number and the average time
in the system.

- c = Number of servers = 3
- rate = Arrival rate = 2.0
- stime = mean service time = 1.0

"""
__version__='\nModel: MMC queue'

class Generator(Process):
    """ generates Jobs at random """

    def execute(self,maxNumber,rate,stime):
        ##print "%7.4f %s starts"%(now(), self.name)
        for i in range(maxNumber):
            L = Job("Job "+`i`)
            activate(L,L.execute(stime),delay=0)
            yield hold,self,grv.expovariate(rate)
 

class Job(Process):
    """ Jobs request a gatekeeper and hold it for an exponential time """
        
    def execute(self,stime):       
        global NoInSystem
        arrTime=now()
        self.trace("Hello World")
        NoInSystem +=1
        m.accum(NoInSystem)
        yield request,self,server
        self.trace("At last    ")
        t = jrv.expovariate(1.0/stime)
        msT.tally(t)
        yield hold,self,t
        yield release,self,server
        NoInSystem -=1
        m.accum(NoInSystem)
        mT.tally(now()-arrTime)
        self.trace("Geronimo   ")
       
    def trace(self,message):
        if TRACING:
            print "%7.4f %6s %10s (%2d)"%(now(),self.name,message,NoInSystem)


TRACING = 0

print __version__
c = 3
stime = 1.0
rate = 2.0
print "%2d servers, %6.4f arrival rate,%6.4f mean service time"%(c,rate,stime)
grv = Random(333555) #  RV for Source
jrv = Random(777999) #  RV for Job
NoInSystem = 0
m=Monitor()
mT=Monitor()
msT=Monitor()
server=Resource(c,name='Gatekeeper')

initialize()
g = Generator('gen')
activate(g,g.execute(maxNumber=10,rate=rate,stime=stime),delay=0)
simulate(until=3000.0)


print "Average number in the system is %6.4f"%(m.timeAverage(),)
print "Average time in the system is   %6.4f"%(mT.mean(),)
print "Actual average service-time is  %6.4f"%(msT.mean(),)

