#!/usr/bin/env python
"""Lister 1.6
Pretty-printer for SimPy class objects
'$Revision: 1.1.1.2.4.1.4.1 $ $Date: 2005/05/27 05:16:50 $ kgm'
"""
__version__ = '1.6 June 2005'
class Lister(object):
    indent=0
    def __str__(self):
        Lister.indent+=1
        result= ("<Instance of %s, id %s:\n%s"%(self.__class__.__name__,
                                               id(self),self.attrnames()))+"\t"*(Lister.indent-1)+">"
        Lister.indent-=1
        return result
    
    def attrnames(self):
        result=''
        for attr in self.__dict__.keys():
            if attr[:2] == "__": #builtin
                pass
            elif attr[0]=="_": #private
                pass
            else:
                result=result+"\t"*Lister.indent+".%s=%s\n" %(attr,self.__dict__[attr])
        return result
    def __repr__(self):
        Lister.indent+=1
        result= ("<Instance of %s, id %s:\n%s"%(self.__class__.__name__,
                                               id(self),self.attrnames()))+"\t"*(Lister.indent-1)+">"
        Lister.indent-=1
        return result

