#!/usr/bin/env python
### airport.py
### from  pyt079D.py (from sms079D.tex)
#        $Author: klaus $

### ################################
### NOT YET ADDD Random times
####################################

"""
  N2 planes arrive at an airport during the day. Of these
  N1  arrive in a bunch at the start of the day (time 0.0) and the
  remainder arrive at equal intervals of, int hr.  (Thus plane
  N1+1 arrives at time 0.0+int. Each plane lands on the single
  runway, blocking it for L hr, and stays at the airport for a
  fixed turnround time, T hr, and then leaves, using the same
  runway, taking the same time.
   
  - N1 = 4 = number of planes arriving in a bunch at the start of the day
  - N2 = 12 = The total number of planes landing in the day
  - int = 0.4 = equal arrival intervals for remaining planes
  - L = 0.1 hr = time runway is blocked with a plane on it
  - T = 0.65 hr = time plane stays at the airport

  The eventual objective of this simulation is to determine the degree of
  congestion by counting the total number in the airport at any time.
  The planes report the time and their identifier  on arrival
  before landing, on leaving (before using the runway) and on final
  departure (i.e. a trace).
  
"""

__version__ = '$Revision: 1.0 $ $Date: 2004-05-15 11:09:30+02 $'

from __future__ import generators
from SimPy.Simulation import *
from random import Random,expovariate,uniform
import unittest

T = 0.0
L = 0.1

class Generator(Process):
    """ Generates a series of N planes at int intervals.
    """
    def __init__(self,N1,N2,int):
        Process.__init__(self)
        self.N1 = N1
        self.N2 = N2
        self.int=int

    def execute(self):
        for i in range(self.N1):
            p = Plane(i)
            activate(p,p.execute(),0.0)

        n=self.N2-self.N1
        for i in range(n):
            p = Plane(self.N1+i)
            activate(p,p.execute())
            yield hold,self,self.int       
        
    def trace(self,message):
        if TRACING: print "%7.4f %s %s "%\
                  (now() , "Generator", message)

class Plane(Process):
    """ a Plane landing at the airport
    """
    def __init__(self,id):
        Process.__init__(self)
        self.id = id
        self.name = 'Plane'+`id`

    def execute(self):
        self.trace("arrived")
        yield request,self,runway
        self.trace("got runway arriving")
        yield hold,self,L
        yield release,self,runway
        self.trace("landed")

        yield hold,self,T

        yield request,self,runway
        self.trace("got runway leaving")
        yield hold,self,L
        yield release,self,runway

        self.trace("farewell!")
        
    def trace(self,message):
        if TRACING: print "%7.4f %s %s "%\
                  (now() , self.name, message)

run = 1

print "pyt079D "+__version__+" run: "+`run`
TRACING = 1

N1 = 4
N2 = 12
int = 0.4
T = 0.6
initialize()
g = Generator(N1,N2,int)
activate(g,g.execute(),0.0)
runway = Resource(1) # 1 runway
simulate(until=20.0)








