#!/usr/bin/env python
"""$Revision: 1.0 $ $Date: 2003-12-26 07:00:12+01 $ kgm

A simple test program to test/demo SimPlot plotLine, plotBars,
and plotScatter methods.
"""

from SimPy.SimPlot import *
from SimPy.Monitor import *


plt=SimPlot()

a=plt.plotLine([(0,0),(1,1),(2,-4),(3,9),(4,16),(4.5,9)],
             title='Basic line plot',color='blue',smooth=1,xaxis='minimal',yaxis='minimal')

a.postscr()

plt.plotStep([(0,0),(1,1),(2,-4),(3,9),(4,16),(4.5,9)],
             title='Basic step plot',color='green',width=3,xaxis='minimal',yaxis='minimal')

m=Monitor(name='Test',ylab='value',tlab='time')
for i in range(50):
    m.observe(i*i,i)
plt.plotLine(m,title="Monitor line plot")
plt.plotBars(m,title="Monitor bars plot",color='blue')
plt.plotScatter(m,title="Monitor scatter plot",size=1)
from random import *

plt.plotScatter([[random(),random()] for x in range(100)],windowsize=(700,700),size=4,title='Random scatter diagram',
                marker='triangle',fillcolor='red')

plt.mainloop()
