#!/usr/bin/env python

from OpenGL.GL import *
from OpenGL.Tk import *
from OpenGL.GLUT import *
from Tkinter import *
import sys

class MyApp(Frame):

    def init(self):
        glMaterial(GL_FRONT, GL_AMBIENT, [0.2, 0.2, 0.2, 1.0])
        glMaterial(GL_FRONT, GL_DIFFUSE, [0.8, 0.8, 0.8, 1.0])
        glMaterial(GL_FRONT, GL_SPECULAR, [1.0, 0.0, 1.0, 1.0])
        glMaterial(GL_FRONT, GL_SHININESS, 50.0)
        glLight(GL_LIGHT0, GL_AMBIENT, [0.0, 1.0, 0.0, 1.0])
        glLight(GL_LIGHT0, GL_DIFFUSE, [1.0, 1.0, 1.0, 1.0])
        glLight(GL_LIGHT0, GL_SPECULAR, [1.0, 1.0, 1.0, 1.0])
        glLight(GL_LIGHT0, GL_POSITION, [1.0, 1.0, 1.0, 0.0]);   
        glLightModel(GL_LIGHT_MODEL_AMBIENT, [0.2, 0.2, 0.2, 1.0])
        glEnable(GL_LIGHTING)
        glEnable(GL_LIGHT0)


    def redraw(self, o):
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
        glPushMatrix()
        glTranslate(0, -1, 0)
        glRotate(250, 1, 0, 0)
        glutSolidCone(1, 2, 50, 10)
        glPopMatrix()

    def save(self):
        #glSaveTiff("cone.tif", 0, 0, 0, 400, 400)
	glSavePPM("cone.ppm", 400, 400)
	#glSaveEPS("cone.ps", 400, 400)

    def __init__(self):
        self.f = Frame()
        self.f.pack()

        self.gl = Opengl(width = 400, height = 400, double = 1, depth = 1)
        self.gl.redraw = self.redraw
        self.gl.autospin_allowed = 1
        self.gl.pack(side = TOP, expand = YES, fill = BOTH)
        self.gl.set_background(255,255,255)
        self.init()

        self.b = Button(self.f, text="Save", command=self.save)
	self.b.pack(side='top')
	self.quit = Button(self.f, text = 'Quit', command = sys.exit)
	self.quit.pack(side = 'top')
        self.gl.mainloop()

app = MyApp()
