#!/usr/bin/python

from person                      import Person
from distribution_source_package import DistributionSourcePackage
from distro_series               import DistroSeries
from milestones                  import Milestones

# Distribution
#
class Distribution(object):
    # __init__
    #
    def __init__(self, service, lp_distribution):
        self.__service = service
        self.__lp_distribution = lp_distribution
        self.__owner        = None
        self.__display_name = None
        self.__current_series  = None
        self.__all_milestones  = None
        self.__active_milestones = None

    # __str__
    #
    def __str__(self):
        return self.display_name

    # owner
    #
    @property
    def owner(self):
        if self.__owner == None:
            self.__owner = Person(None, self.__lp_distribution.owner)
        return self.__owner

    # display_name
    #
    @property
    def display_name(self):
        if self.__display_name == None:
            self.__display_name = self.__lp_distribution.display_name
        return self.__display_name

    # current_series
    #
    @property
    def current_series(self):
        if self.__current_series == None:
            self.__current_series = DistroSeries(self.__service, None, self.__lp_distribution.current_series)

        return self.__current_series

    # all_milestones
    #
    @property
    def all_milestones(self):
        if self.__all_milestones == None:
            self.__all_milestones = Milestones(self.__service, self.__lp_distribution.all_milestones)

        return self.__all_milestones

    # active_milestones
    #
    @property
    def active_milestones(self):
        if self.__active_milestones == None:
            self.__active_milestones = Milestones(self.__service, self.__lp_distribution.active_milestones)

        return self.__active_milestones

    # get_source_package
    #
    def get_source_package(self, source_pkg):
        return DistributionSourcePackage(self.__service, self.__lp_distribution.getSourcePackage(name = source_pkg))

# vi:set ts=4 sw=4 expandtab:
