import os
import sys
sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..'))

from testbase import PyLPBugsTestSuite, PyLPBugsTestCase, ConfigTest, TestCaseIgnored

import launchpadbugs.utils as utils
from launchpadbugs.lpconstants import BASEURL


    
def _gen_test_valid_url(url, result):
    def _testcase(self):
        self.failIfRaises(ValueError, utils.valid_lp_url, url, BASEURL.BUG)
        x = utils.valid_lp_url(url, BASEURL.BUG)
        self.assert_(x == result, "returns '%s' but '%s' is expected" %(x, result))
    return _testcase

def _gen_test_invalid_url(url):
    def _testcase(self):
        self.assertRaises(ValueError, utils.valid_lp_url, url, BASEURL.BUG)
    return _testcase

class ValidUrlTestCase(PyLPBugsTestCase):
    invalid_url = ("", "www.google.de")
    valid_url = (
        ("https://bugs.launchpad.net/ubuntu/+source/bughelper/+bug/88521",
         "https://bugs.launchpad.net/ubuntu/+source/bughelper/+bug/88521"),
        ("/ubuntu/+source/bughelper/+bug/88521",
         "https://bugs.launchpad.net/ubuntu/+source/bughelper/+bug/88521"),
        ("launchpad.net/ubuntu/+source/bughelper/+bug/88521",
         "https://bugs.launchpad.net/ubuntu/+source/bughelper/+bug/88521"),
        ("https://launchpad.net/bugs/88521",
         "https://bugs.launchpad.net/bugs/88521"),
        ("bugs.launchpad.net/ubuntu/+source/bughelper/+bug/88521",
         "https://bugs.launchpad.net/ubuntu/+source/bughelper/+bug/88521"),
        ("/ubuntu/+source/bughelper/+bug/88521/+editpage",
         "https://bugs.launchpad.net/ubuntu/+source/bughelper/+bug/88521/+editpage"),
        ("/buglog-data/+bug/120593/attachments/120512",
         "https://bugs.launchpad.net/buglog-data/+bug/120593/attachments/120512"),
        ("https://edge.launchpad.net/bugs/bugtrackers/alsa-mantis",
         "https://bugs.edge.launchpad.net/bugs/bugtrackers/alsa-mantis"),
    )
            
for i, k in enumerate(ValidUrlTestCase.invalid_url):
    _testcase = _gen_test_invalid_url(k)
    _testcase.__doc__ = "test invalid url ('%s')" %k
    setattr(ValidUrlTestCase, "test_%.3d_invalid_lp_url" %i, _testcase)
            
for i, (url, result) in enumerate(ValidUrlTestCase.valid_url):
    _testcase = _gen_test_valid_url(url, result)
    _testcase.__doc__ = "test valid url ('%s')" %url
    setattr(ValidUrlTestCase, "test_%.3d_valid_lp_url" %(i+len(ValidUrlTestCase.invalid_url)), _testcase)
    
if __name__ == '__main__':
    import unittest
    
    ValidUrlTestSuite = unittest.TestLoader().loadTestsFromTestCase(ValidUrlTestCase)
    
    alltests = PyLPBugsTestSuite((ValidUrlTestSuite,))
    unittest.TextTestRunner(verbosity=2).run(alltests)
