/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __BOXWITHLINES2DSUBVOL_H
#define __BOXWITHLINES2DSUBVOL_H

// --- Project includes ---
#include "BoxWithLines2D.h"

// --- STL includes ---
#include <vector>

using std::vector;

/*!
  \class BoxWithLines2DSubVol

  A class for the generation of random particles inside a box. An arbitrary number 
  of lines can be added to which the particles are fitted.  The class supplies a number of 
  subvolumes for the getAPoint function 
*/
class BoxWithLines2DSubVol : public BoxWithLines2D
{
 private:
  double m_svdim_x,m_svdim_y;
  int m_nsv_x,m_nsv_y;

 public:
  BoxWithLines2DSubVol();
  BoxWithLines2DSubVol(const Vector3&,const Vector3&,double,double);
  virtual ~BoxWithLines2DSubVol(){};

  virtual Vector3 getAPoint(int) const;
  virtual int getNumberSubVolumes() const;
};
#endif // __BOXWITHLINES2DSUBVOL_H
