/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __AVOLUME3D_H
#define __AVOLUME3D_H

// --- Project includes ---
#include "AVolume.h"
#include "Plane.h"

// --- STL includes ---
#include <map>

using std::map;

class AVolume3D : public AVolume
{
 public:
  virtual ~AVolume3D(){};

  virtual const map<double,const AGeometricObject*> getClosestObjects(const Vector3&,int) const = 0;
  virtual bool isFullyOutside(const Sphere&) =0;
};

#endif // __AVOLUME3D_H
