/*
 * $Id: map_cp932ext.h,v 1.1.1.1 2003/09/24 17:45:26 perky Exp $
 */

static const ucs2_t __cp932ext_decmap[969] = {
  0xff3c, 0xff5e, 0x2225, 0xff5c, 0x2026, 0x2025, 0x2018, 0x2019,
  0x201c, 0x201d, 0xff08, 0xff09, 0x3014, 0x3015, 0xff3b, 0xff3d,
  0xff5b, 0xff5d, 0x3008, 0x3009, 0x300a, 0x300b, 0x300c, 0x300d,
  0x300e, 0x300f, 0x3010, 0x3011, 0xff0b, 0xff0d, 0x00b1, 0x00d7,
  UNIINV, 0x00f7, 0xff1d, 0x2260, 0xff1c, 0xff1e, 0x2266, 0x2267,
  0x221e, 0x2234, 0x2642, 0x2640, 0x00b0, 0x2032, 0x2033, 0x2103,
  0xffe5, 0xff04, 0xffe0, 0xffe1, 0xff05, 0xff03, 0xff06, 0xff0a,
  0xff20, 0x00a7, 0x2606, 0x2605, 0x25cb, 0x25cf, 0x25ce, 0x25c7,
  0x25c6, 0x25a1, 0x25a0, 0x25b3, 0x25b2, 0x25bd, 0x25bc, 0x203b,
  0x3012, 0x2192, 0x2190, 0x2191, 0x2193, 0x3013, UNIINV, UNIINV,
  UNIINV, UNIINV, UNIINV, UNIINV, UNIINV, UNIINV, UNIINV, UNIINV,
  UNIINV, 0x2208, 0x220b, 0x2286, 0x2287, 0x2282, 0x2283, 0x222a,
  0x2229, UNIINV, UNIINV, UNIINV, UNIINV, UNIINV, UNIINV, UNIINV,
  UNIINV, 0x2227, 0x2228, 0xffe2, 0x2460, 0x2461, 0x2462, 0x2463,
  0x2464, 0x2465, 0x2466, 0x2467, 0x2468, 0x2469, 0x246a, 0x246b,
  0x246c, 0x246d, 0x246e, 0x246f, 0x2470, 0x2471, 0x2472, 0x2473,
  0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 0x2167,
  0x2168, 0x2169, UNIINV, 0x3349, 0x3314, 0x3322, 0x334d, 0x3318,
  0x3327, 0x3303, 0x3336, 0x3351, 0x3357, 0x330d, 0x3326, 0x3323,
  0x332b, 0x334a, 0x333b, 0x339c, 0x339d, 0x339e, 0x338e, 0x338f,
  0x33c4, 0x33a1, UNIINV, UNIINV, UNIINV, UNIINV, UNIINV, UNIINV,
  UNIINV, UNIINV, 0x337b, UNIINV, 0x301d, 0x301f, 0x2116, 0x33cd,
  0x2121, 0x32a4, 0x32a5, 0x32a6, 0x32a7, 0x32a8, 0x3231, 0x3232,
  0x3239, 0x337e, 0x337d, 0x337c, 0x2252, 0x2261, 0x222b, 0x222e,
  0x2211, 0x221a, 0x22a5, 0x2220, 0x221f, 0x22bf, 0x2235, 0x2229,
  0x222a, 0x7e8a, 0x891c, 0x9348, 0x9288, 0x84dc, 0x4fc9, 0x70bb,
  0x6631, 0x68c8, 0x92f9, 0x66fb, 0x5f45, 0x4e28, 0x4ee1, 0x4efc,
  0x4f00, 0x4f03, 0x4f39, 0x4f56, 0x4f92, 0x4f8a, 0x4f9a, 0x4f94,
  0x4fcd, 0x5040, 0x5022, 0x4fff, 0x501e, 0x5046, 0x5070, 0x5042,
  0x5094, 0x50f4, 0x50d8, 0x514a, 0x5164, 0x519d, 0x51be, 0x51ec,
  0x5215, 0x529c, 0x52a6, 0x52c0, 0x52db, 0x5300, 0x5307, 0x5324,
  0x5372, 0x5393, 0x53b2, 0x53dd, 0xfa0e, 0x549c, 0x548a, 0x54a9,
  0x54ff, 0x5586, 0x5759, 0x5765, 0x57ac, 0x57c8, 0x57c7, 0xfa0f,
  UNIINV, 0xfa10, 0x589e, 0x58b2, 0x590b, 0x5953, 0x595b, 0x595d,
  0x5963, 0x59a4, 0x59ba, 0x5b56, 0x5bc0, 0x752f, 0x5bd8, 0x5bec,
  0x5c1e, 0x5ca6, 0x5cba, 0x5cf5, 0x5d27, 0x5d53, 0xfa11, 0x5d42,
  0x5d6d, 0x5db8, 0x5db9, 0x5dd0, 0x5f21, 0x5f34, 0x5f67, 0x5fb7,
  0x5fde, 0x605d, 0x6085, 0x608a, 0x60de, 0x60d5, 0x6120, 0x60f2,
  0x6111, 0x6137, 0x6130, 0x6198, 0x6213, 0x62a6, 0x63f5, 0x6460,
  0x649d, 0x64ce, 0x654e, 0x6600, 0x6615, 0x663b, 0x6609, 0x662e,
  0x661e, 0x6624, 0x6665, 0x6657, 0x6659, 0xfa12, 0x6673, 0x6699,
  0x66a0, 0x66b2, 0x66bf, 0x66fa, 0x670e, 0xf929, 0x6766, 0x67bb,
  0x6852, 0x67c0, 0x6801, 0x6844, 0x68cf, 0xfa13, 0x6968, 0xfa14,
  0x6998, 0x69e2, 0x6a30, 0x6a6b, 0x6a46, 0x6a73, 0x6a7e, 0x6ae2,
  0x6ae4, 0x6bd6, 0x6c3f, 0x6c5c, 0x6c86, 0x6c6f, 0x6cda, 0x6d04,
  0x6d87, 0x6d6f, 0x6d96, 0x6dac, 0x6dcf, 0x6df8, 0x6df2, 0x6dfc,
  0x6e39, 0x6e5c, 0x6e27, 0x6e3c, 0x6ebf, 0x6f88, 0x6fb5, 0x6ff5,
  0x7005, 0x7007, 0x7028, 0x7085, 0x70ab, 0x710f, 0x7104, 0x715c,
  0x7146, 0x7147, 0xfa15, 0x71c1, 0x71fe, 0x72b1, 0x72be, 0x7324,
  0xfa16, 0x7377, 0x73bd, 0x73c9, 0x73d6, 0x73e3, 0x73d2, 0x7407,
  0x73f5, 0x7426, 0x742a, 0x7429, 0x742e, 0x7462, 0x7489, 0x749f,
  0x7501, 0x756f, 0x7682, 0x769c, 0x769e, 0x769b, 0x76a6, 0xfa17,
  0x7746, 0x52af, 0x7821, 0x784e, 0x7864, 0x787a, 0x7930, 0xfa18,
  0xfa19, 0xfa1a, 0x7994, 0xfa1b, 0x799b, 0x7ad1, 0x7ae7, 0xfa1c,
  0x7aeb, 0x7b9e, 0xfa1d, 0x7d48, 0x7d5c, 0x7db7, 0x7da0, 0x7dd6,
  0x7e52, 0x7f47, 0x7fa1, 0xfa1e, 0x8301, 0x8362, 0x837f, 0x83c7,
  0x83f6, 0x8448, 0x84b4, 0x8553, 0x8559, UNIINV, 0x856b, 0xfa1f,
  0x85b0, 0xfa20, 0xfa21, 0x8807, 0x88f5, 0x8a12, 0x8a37, 0x8a79,
  0x8aa7, 0x8abe, 0x8adf, 0xfa22, 0x8af6, 0x8b53, 0x8b7f, 0x8cf0,
  0x8cf4, 0x8d12, 0x8d76, 0xfa23, 0x8ecf, 0xfa24, 0xfa25, 0x9067,
  0x90de, 0xfa26, 0x9115, 0x9127, 0x91da, 0x91d7, 0x91de, 0x91ed,
  0x91ee, 0x91e4, 0x91e5, 0x9206, 0x9210, 0x920a, 0x923a, 0x9240,
  0x923c, 0x924e, 0x9259, 0x9251, 0x9239, 0x9267, 0x92a7, 0x9277,
  0x9278, 0x92e7, 0x92d7, 0x92d9, 0x92d0, 0xfa27, 0x92d5, 0x92e0,
  0x92d3, 0x9325, 0x9321, 0x92fb, 0xfa28, 0x931e, 0x92ff, 0x931d,
  0x9302, 0x9370, 0x9357, 0x93a4, 0x93c6, 0x93de, 0x93f8, 0x9431,
  0x9445, 0x9448, 0x9592, 0xf9dc, 0xfa29, 0x969d, 0x96af, 0x9733,
  0x973b, 0x9743, 0x974d, 0x974f, 0x9751, 0x9755, 0x9857, 0x9865,
  0xfa2a, 0xfa2b, 0x9927, 0xfa2c, 0x999e, 0x9a4e, 0x9ad9, 0x9adc,
  0x9b75, 0x9b72, 0x9b8f, 0x9bb1, 0x9bbb, 0x9c00, 0x9d70, 0x9d6b,
  0xfa2d, 0x9e19, 0x9ed1, UNIINV, UNIINV, 0x2170, 0x2171, 0x2172,
  0x2173, 0x2174, 0x2175, 0x2176, 0x2177, 0x2178, 0x2179, 0xffe2,
  0xffe4, 0xff07, 0xff02, 0x2170, 0x2171, 0x2172, 0x2173, 0x2174,
  0x2175, 0x2176, 0x2177, 0x2178, 0x2179, 0x2160, 0x2161, 0x2162,
  0x2163, 0x2164, 0x2165, 0x2166, 0x2167, 0x2168, 0x2169, 0xffe2,
  0xffe4, 0xff07, 0xff02, 0x3231, 0x2116, 0x2121, 0x2235, 0x7e8a,
  0x891c, 0x9348, 0x9288, 0x84dc, 0x4fc9, 0x70bb, 0x6631, 0x68c8,
  0x92f9, 0x66fb, 0x5f45, 0x4e28, 0x4ee1, 0x4efc, 0x4f00, 0x4f03,
  0x4f39, 0x4f56, 0x4f92, 0x4f8a, 0x4f9a, 0x4f94, 0x4fcd, 0x5040,
  0x5022, 0x4fff, 0x501e, 0x5046, 0x5070, 0x5042, 0x5094, 0x50f4,
  0x50d8, 0x514a, UNIINV, 0x5164, 0x519d, 0x51be, 0x51ec, 0x5215,
  0x529c, 0x52a6, 0x52c0, 0x52db, 0x5300, 0x5307, 0x5324, 0x5372,
  0x5393, 0x53b2, 0x53dd, 0xfa0e, 0x549c, 0x548a, 0x54a9, 0x54ff,
  0x5586, 0x5759, 0x5765, 0x57ac, 0x57c8, 0x57c7, 0xfa0f, 0xfa10,
  0x589e, 0x58b2, 0x590b, 0x5953, 0x595b, 0x595d, 0x5963, 0x59a4,
  0x59ba, 0x5b56, 0x5bc0, 0x752f, 0x5bd8, 0x5bec, 0x5c1e, 0x5ca6,
  0x5cba, 0x5cf5, 0x5d27, 0x5d53, 0xfa11, 0x5d42, 0x5d6d, 0x5db8,
  0x5db9, 0x5dd0, 0x5f21, 0x5f34, 0x5f67, 0x5fb7, 0x5fde, 0x605d,
  0x6085, 0x608a, 0x60de, 0x60d5, 0x6120, 0x60f2, 0x6111, 0x6137,
  0x6130, 0x6198, 0x6213, 0x62a6, 0x63f5, 0x6460, 0x649d, 0x64ce,
  0x654e, 0x6600, 0x6615, 0x663b, 0x6609, 0x662e, 0x661e, 0x6624,
  0x6665, 0x6657, 0x6659, 0xfa12, 0x6673, 0x6699, 0x66a0, 0x66b2,
  0x66bf, 0x66fa, 0x670e, 0xf929, 0x6766, 0x67bb, 0x6852, 0x67c0,
  0x6801, 0x6844, 0x68cf, 0xfa13, 0x6968, 0xfa14, 0x6998, 0x69e2,
  0x6a30, 0x6a6b, 0x6a46, 0x6a73, 0x6a7e, 0x6ae2, 0x6ae4, 0x6bd6,
  0x6c3f, 0x6c5c, 0x6c86, 0x6c6f, 0x6cda, 0x6d04, 0x6d87, 0x6d6f,
  0x6d96, 0x6dac, 0x6dcf, 0x6df8, 0x6df2, 0x6dfc, 0x6e39, 0x6e5c,
  0x6e27, 0x6e3c, 0x6ebf, 0x6f88, 0x6fb5, 0x6ff5, 0x7005, 0x7007,
  0x7028, 0x7085, 0x70ab, 0x710f, 0x7104, 0x715c, 0x7146, 0x7147,
  0xfa15, 0x71c1, 0x71fe, 0x72b1, 0x72be, 0x7324, 0xfa16, 0x7377,
  0x73bd, 0x73c9, 0x73d6, 0x73e3, 0x73d2, 0x7407, 0x73f5, 0x7426,
  0x742a, 0x7429, 0x742e, 0x7462, 0x7489, 0x749f, 0x7501, 0x756f,
  0x7682, 0x769c, 0x769e, 0x769b, 0x76a6, 0xfa17, 0x7746, 0x52af,
  0x7821, 0x784e, 0x7864, 0x787a, 0x7930, 0xfa18, 0xfa19, UNIINV,
  0xfa1a, 0x7994, 0xfa1b, 0x799b, 0x7ad1, 0x7ae7, 0xfa1c, 0x7aeb,
  0x7b9e, 0xfa1d, 0x7d48, 0x7d5c, 0x7db7, 0x7da0, 0x7dd6, 0x7e52,
  0x7f47, 0x7fa1, 0xfa1e, 0x8301, 0x8362, 0x837f, 0x83c7, 0x83f6,
  0x8448, 0x84b4, 0x8553, 0x8559, 0x856b, 0xfa1f, 0x85b0, 0xfa20,
  0xfa21, 0x8807, 0x88f5, 0x8a12, 0x8a37, 0x8a79, 0x8aa7, 0x8abe,
  0x8adf, 0xfa22, 0x8af6, 0x8b53, 0x8b7f, 0x8cf0, 0x8cf4, 0x8d12,
  0x8d76, 0xfa23, 0x8ecf, 0xfa24, 0xfa25, 0x9067, 0x90de, 0xfa26,
  0x9115, 0x9127, 0x91da, 0x91d7, 0x91de, 0x91ed, 0x91ee, 0x91e4,
  0x91e5, 0x9206, 0x9210, 0x920a, 0x923a, 0x9240, 0x923c, 0x924e,
  0x9259, 0x9251, 0x9239, 0x9267, 0x92a7, 0x9277, 0x9278, 0x92e7,
  0x92d7, 0x92d9, 0x92d0, 0xfa27, 0x92d5, 0x92e0, 0x92d3, 0x9325,
  0x9321, 0x92fb, 0xfa28, 0x931e, 0x92ff, 0x931d, 0x9302, 0x9370,
  0x9357, 0x93a4, 0x93c6, 0x93de, 0x93f8, 0x9431, 0x9445, 0x9448,
  0x9592, 0xf9dc, 0xfa29, 0x969d, 0x96af, 0x9733, 0x973b, 0x9743,
  0x974d, 0x974f, 0x9751, 0x9755, 0x9857, 0x9865, 0xfa2a, 0xfa2b,
  0x9927, 0xfa2c, 0x999e, 0x9a4e, 0x9ad9, 0x9adc, 0x9b75, 0x9b72,
  0x9b8f, 0x9bb1, 0x9bbb, 0x9c00, 0x9d70, 0x9d6b, 0xfa2d, 0x9e19,
  0x9ed1,
};

static const struct dbcs_index cp932ext_decmap[256] = {
/* 0x00 */ {0, 0, 0},
/* 0x01 */ {0, 0, 0},
/* 0x02 */ {0, 0, 0},
/* 0x03 */ {0, 0, 0},
/* 0x04 */ {0, 0, 0},
/* 0x05 */ {0, 0, 0},
/* 0x06 */ {0, 0, 0},
/* 0x07 */ {0, 0, 0},
/* 0x08 */ {0, 0, 0},
/* 0x09 */ {0, 0, 0},
/* 0x0A */ {0, 0, 0},
/* 0x0B */ {0, 0, 0},
/* 0x0C */ {0, 0, 0},
/* 0x0D */ {0, 0, 0},
/* 0x0E */ {0, 0, 0},
/* 0x0F */ {0, 0, 0},
/* 0x10 */ {0, 0, 0},
/* 0x11 */ {0, 0, 0},
/* 0x12 */ {0, 0, 0},
/* 0x13 */ {0, 0, 0},
/* 0x14 */ {0, 0, 0},
/* 0x15 */ {0, 0, 0},
/* 0x16 */ {0, 0, 0},
/* 0x17 */ {0, 0, 0},
/* 0x18 */ {0, 0, 0},
/* 0x19 */ {0, 0, 0},
/* 0x1A */ {0, 0, 0},
/* 0x1B */ {0, 0, 0},
/* 0x1C */ {0, 0, 0},
/* 0x1D */ {0, 0, 0},
/* 0x1E */ {0, 0, 0},
/* 0x1F */ {0, 0, 0},
/* 0x20 */ {0, 0, 0},
/* 0x21 */ {0, 0, 0},
/* 0x22 */ {0, 0, 0},
/* 0x23 */ {0, 0, 0},
/* 0x24 */ {0, 0, 0},
/* 0x25 */ {0, 0, 0},
/* 0x26 */ {0, 0, 0},
/* 0x27 */ {0, 0, 0},
/* 0x28 */ {0, 0, 0},
/* 0x29 */ {0, 0, 0},
/* 0x2A */ {0, 0, 0},
/* 0x2B */ {0, 0, 0},
/* 0x2C */ {0, 0, 0},
/* 0x2D */ {0, 0, 0},
/* 0x2E */ {0, 0, 0},
/* 0x2F */ {0, 0, 0},
/* 0x30 */ {0, 0, 0},
/* 0x31 */ {0, 0, 0},
/* 0x32 */ {0, 0, 0},
/* 0x33 */ {0, 0, 0},
/* 0x34 */ {0, 0, 0},
/* 0x35 */ {0, 0, 0},
/* 0x36 */ {0, 0, 0},
/* 0x37 */ {0, 0, 0},
/* 0x38 */ {0, 0, 0},
/* 0x39 */ {0, 0, 0},
/* 0x3A */ {0, 0, 0},
/* 0x3B */ {0, 0, 0},
/* 0x3C */ {0, 0, 0},
/* 0x3D */ {0, 0, 0},
/* 0x3E */ {0, 0, 0},
/* 0x3F */ {0, 0, 0},
/* 0x40 */ {0, 0, 0},
/* 0x41 */ {0, 0, 0},
/* 0x42 */ {0, 0, 0},
/* 0x43 */ {0, 0, 0},
/* 0x44 */ {0, 0, 0},
/* 0x45 */ {0, 0, 0},
/* 0x46 */ {0, 0, 0},
/* 0x47 */ {0, 0, 0},
/* 0x48 */ {0, 0, 0},
/* 0x49 */ {0, 0, 0},
/* 0x4A */ {0, 0, 0},
/* 0x4B */ {0, 0, 0},
/* 0x4C */ {0, 0, 0},
/* 0x4D */ {0, 0, 0},
/* 0x4E */ {0, 0, 0},
/* 0x4F */ {0, 0, 0},
/* 0x50 */ {0, 0, 0},
/* 0x51 */ {0, 0, 0},
/* 0x52 */ {0, 0, 0},
/* 0x53 */ {0, 0, 0},
/* 0x54 */ {0, 0, 0},
/* 0x55 */ {0, 0, 0},
/* 0x56 */ {0, 0, 0},
/* 0x57 */ {0, 0, 0},
/* 0x58 */ {0, 0, 0},
/* 0x59 */ {0, 0, 0},
/* 0x5A */ {0, 0, 0},
/* 0x5B */ {0, 0, 0},
/* 0x5C */ {0, 0, 0},
/* 0x5D */ {0, 0, 0},
/* 0x5E */ {0, 0, 0},
/* 0x5F */ {0, 0, 0},
/* 0x60 */ {0, 0, 0},
/* 0x61 */ {0, 0, 0},
/* 0x62 */ {0, 0, 0},
/* 0x63 */ {0, 0, 0},
/* 0x64 */ {0, 0, 0},
/* 0x65 */ {0, 0, 0},
/* 0x66 */ {0, 0, 0},
/* 0x67 */ {0, 0, 0},
/* 0x68 */ {0, 0, 0},
/* 0x69 */ {0, 0, 0},
/* 0x6A */ {0, 0, 0},
/* 0x6B */ {0, 0, 0},
/* 0x6C */ {0, 0, 0},
/* 0x6D */ {0, 0, 0},
/* 0x6E */ {0, 0, 0},
/* 0x6F */ {0, 0, 0},
/* 0x70 */ {0, 0, 0},
/* 0x71 */ {0, 0, 0},
/* 0x72 */ {0, 0, 0},
/* 0x73 */ {0, 0, 0},
/* 0x74 */ {0, 0, 0},
/* 0x75 */ {0, 0, 0},
/* 0x76 */ {0, 0, 0},
/* 0x77 */ {0, 0, 0},
/* 0x78 */ {0, 0, 0},
/* 0x79 */ {0, 0, 0},
/* 0x7A */ {0, 0, 0},
/* 0x7B */ {0, 0, 0},
/* 0x7C */ {0, 0, 0},
/* 0x7D */ {0, 0, 0},
/* 0x7E */ {0, 0, 0},
/* 0x7F */ {0, 0, 0},
/* 0x80 */ {0, 0, 0},
/* 0x81 */ {__cp932ext_decmap+0, 0x5f, 0xca},
/* 0x82 */ {0, 0, 0},
/* 0x83 */ {0, 0, 0},
/* 0x84 */ {0, 0, 0},
/* 0x85 */ {0, 0, 0},
/* 0x86 */ {0, 0, 0},
/* 0x87 */ {__cp932ext_decmap+108, 0x40, 0x9c},
/* 0x88 */ {0, 0, 0},
/* 0x89 */ {0, 0, 0},
/* 0x8A */ {0, 0, 0},
/* 0x8B */ {0, 0, 0},
/* 0x8C */ {0, 0, 0},
/* 0x8D */ {0, 0, 0},
/* 0x8E */ {0, 0, 0},
/* 0x8F */ {0, 0, 0},
/* 0x90 */ {0, 0, 0},
/* 0x91 */ {0, 0, 0},
/* 0x92 */ {0, 0, 0},
/* 0x93 */ {0, 0, 0},
/* 0x94 */ {0, 0, 0},
/* 0x95 */ {0, 0, 0},
/* 0x96 */ {0, 0, 0},
/* 0x97 */ {0, 0, 0},
/* 0x98 */ {0, 0, 0},
/* 0x99 */ {0, 0, 0},
/* 0x9A */ {0, 0, 0},
/* 0x9B */ {0, 0, 0},
/* 0x9C */ {0, 0, 0},
/* 0x9D */ {0, 0, 0},
/* 0x9E */ {0, 0, 0},
/* 0x9F */ {0, 0, 0},
/* 0xA0 */ {0, 0, 0},
/* 0xA1 */ {0, 0, 0},
/* 0xA2 */ {0, 0, 0},
/* 0xA3 */ {0, 0, 0},
/* 0xA4 */ {0, 0, 0},
/* 0xA5 */ {0, 0, 0},
/* 0xA6 */ {0, 0, 0},
/* 0xA7 */ {0, 0, 0},
/* 0xA8 */ {0, 0, 0},
/* 0xA9 */ {0, 0, 0},
/* 0xAA */ {0, 0, 0},
/* 0xAB */ {0, 0, 0},
/* 0xAC */ {0, 0, 0},
/* 0xAD */ {0, 0, 0},
/* 0xAE */ {0, 0, 0},
/* 0xAF */ {0, 0, 0},
/* 0xB0 */ {0, 0, 0},
/* 0xB1 */ {0, 0, 0},
/* 0xB2 */ {0, 0, 0},
/* 0xB3 */ {0, 0, 0},
/* 0xB4 */ {0, 0, 0},
/* 0xB5 */ {0, 0, 0},
/* 0xB6 */ {0, 0, 0},
/* 0xB7 */ {0, 0, 0},
/* 0xB8 */ {0, 0, 0},
/* 0xB9 */ {0, 0, 0},
/* 0xBA */ {0, 0, 0},
/* 0xBB */ {0, 0, 0},
/* 0xBC */ {0, 0, 0},
/* 0xBD */ {0, 0, 0},
/* 0xBE */ {0, 0, 0},
/* 0xBF */ {0, 0, 0},
/* 0xC0 */ {0, 0, 0},
/* 0xC1 */ {0, 0, 0},
/* 0xC2 */ {0, 0, 0},
/* 0xC3 */ {0, 0, 0},
/* 0xC4 */ {0, 0, 0},
/* 0xC5 */ {0, 0, 0},
/* 0xC6 */ {0, 0, 0},
/* 0xC7 */ {0, 0, 0},
/* 0xC8 */ {0, 0, 0},
/* 0xC9 */ {0, 0, 0},
/* 0xCA */ {0, 0, 0},
/* 0xCB */ {0, 0, 0},
/* 0xCC */ {0, 0, 0},
/* 0xCD */ {0, 0, 0},
/* 0xCE */ {0, 0, 0},
/* 0xCF */ {0, 0, 0},
/* 0xD0 */ {0, 0, 0},
/* 0xD1 */ {0, 0, 0},
/* 0xD2 */ {0, 0, 0},
/* 0xD3 */ {0, 0, 0},
/* 0xD4 */ {0, 0, 0},
/* 0xD5 */ {0, 0, 0},
/* 0xD6 */ {0, 0, 0},
/* 0xD7 */ {0, 0, 0},
/* 0xD8 */ {0, 0, 0},
/* 0xD9 */ {0, 0, 0},
/* 0xDA */ {0, 0, 0},
/* 0xDB */ {0, 0, 0},
/* 0xDC */ {0, 0, 0},
/* 0xDD */ {0, 0, 0},
/* 0xDE */ {0, 0, 0},
/* 0xDF */ {0, 0, 0},
/* 0xE0 */ {0, 0, 0},
/* 0xE1 */ {0, 0, 0},
/* 0xE2 */ {0, 0, 0},
/* 0xE3 */ {0, 0, 0},
/* 0xE4 */ {0, 0, 0},
/* 0xE5 */ {0, 0, 0},
/* 0xE6 */ {0, 0, 0},
/* 0xE7 */ {0, 0, 0},
/* 0xE8 */ {0, 0, 0},
/* 0xE9 */ {0, 0, 0},
/* 0xEA */ {0, 0, 0},
/* 0xEB */ {0, 0, 0},
/* 0xEC */ {0, 0, 0},
/* 0xED */ {__cp932ext_decmap+201, 0x40, 0xfc},
/* 0xEE */ {__cp932ext_decmap+390, 0x40, 0xfc},
/* 0xEF */ {0, 0, 0},
/* 0xF0 */ {0, 0, 0},
/* 0xF1 */ {0, 0, 0},
/* 0xF2 */ {0, 0, 0},
/* 0xF3 */ {0, 0, 0},
/* 0xF4 */ {0, 0, 0},
/* 0xF5 */ {0, 0, 0},
/* 0xF6 */ {0, 0, 0},
/* 0xF7 */ {0, 0, 0},
/* 0xF8 */ {0, 0, 0},
/* 0xF9 */ {0, 0, 0},
/* 0xFA */ {__cp932ext_decmap+579, 0x40, 0xfc},
/* 0xFB */ {__cp932ext_decmap+768, 0x40, 0xfc},
/* 0xFC */ {__cp932ext_decmap+957, 0x40, 0x4b},
/* 0xFD */ {0, 0, 0},
/* 0xFE */ {0, 0, 0},
/* 0xFF */ {0, 0, 0},
};

static const DBCHAR __cp932ext_encmap[9686] = {
  0x8782, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0x8784, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0x8754, 0x8755, 0x8756, 0x8757, 0x8758, 0x8759,
  0x875a, 0x875b, 0x875c, 0x875d, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xeeef, 0xeef0, 0xeef1, 0xeef2, 0xeef3, 0xeef4,
  0xeef5, 0xeef6, 0xeef7, 0xeef8, 0x8794, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0x8798, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0x8161, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0x8793, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0x8799, 0x8740, 0x8741, 0x8742, 0x8743, 0x8744,
  0x8745, 0x8746, 0x8747, 0x8748, 0x8749, 0x874a, 0x874b, 0x874c,
  0x874d, 0x874e, 0x874f, 0x8750, 0x8751, 0x8752, 0x8753, 0x8780,
  NOCHAR, 0x8781, 0x878a, 0x878b, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0x878c, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0x8785, 0x8786, 0x8787,
  0x8788, 0x8789, 0x8765, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0x8769, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0x8760, NOCHAR, NOCHAR, NOCHAR, 0x8763,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0x8761, 0x876b, NOCHAR, NOCHAR, 0x876a, 0x8764, NOCHAR,
  NOCHAR, NOCHAR, 0x876c, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0x8766, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0x876e, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0x875f, 0x876d, NOCHAR, NOCHAR, 0x8762, NOCHAR, NOCHAR, NOCHAR,
  0x8767, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0x8768, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0x877e, 0x878f, 0x878e, 0x878d, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0x8772, 0x8773, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0x876f, 0x8770, 0x8771, NOCHAR, NOCHAR,
  0x8775, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0x8774, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0x8783, 0xed4c, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed4d, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xed4e, 0xed4f, NOCHAR, NOCHAR, 0xed50, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xed51, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xed52, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed54, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed53, NOCHAR, 0xed56, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed55, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xed45, NOCHAR, NOCHAR, NOCHAR, 0xed57,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xed5a, 0xed5b, NOCHAR, NOCHAR, NOCHAR, 0xed59, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed58, NOCHAR, 0xed5e, NOCHAR,
  NOCHAR, NOCHAR, 0xed5c, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed5d, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xed5f, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed61, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xed60, 0xed62, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xed63, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed64, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed65, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xed66, 0xed67, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xed68, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed69, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee5b, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed6a,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xed6b, 0xed6c, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xed6d, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed6e,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed6f, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed70, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed71, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xed72, 0xed75, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xed74, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xed76, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed77, 0xed78,
  0xed79, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed7a, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xed7b, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed7d, 0xed7c,
  0xed81, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed82, 0xed83, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed84, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed85, NOCHAR, 0xed86,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed87, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed88, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed89, 0xed8a, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed8b,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed8d,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xed8e, 0xed8f, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed90, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xed91, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xed92, 0xed93, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed96,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xed94, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xed97, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed98, 0xed99, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed9a, 0xed9b, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xed9c, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xed4b, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed9d, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed9e, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xed9f, 0xeda0, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeda1, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xeda2, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeda4, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeda3, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xeda6, 0xeda7, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xeda5, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xeda9, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xeda8, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xedaa, 0xedab, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedac, 0xedad, 0xedae,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedaf, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedb0, 0xedb1, 0xedb2,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xedb5, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedb3, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedb7, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xedb8, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedb6, NOCHAR, NOCHAR,
  0xed47, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xedb4, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedba, NOCHAR,
  0xedbb, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedb9, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xedbd, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xedbe, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedbf,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xedc0, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedc1, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xedc2, 0xed4a, 0xedc3, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xedc5, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xedc6, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedc8, 0xedc9, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xedca, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedc7,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed48, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedcb, 0xedcd, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedcf, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedd0,
  0xedd1, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedd3, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xedd2, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xedd4, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedd5, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xedd6, NOCHAR, 0xedd7, 0xedd8, 0xedd9, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xedda, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeddc, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeddb, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xeddd, 0xedde, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xede0, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeddf, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xede1, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xede2, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xede3, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xede5, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xede4, NOCHAR,
  NOCHAR, NOCHAR, 0xede6, 0xede9, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xede7, NOCHAR, NOCHAR,
  0xedea, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xede8, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xedeb, 0xedec, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xeded, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xedee, 0xedef, NOCHAR, 0xedf0, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedf1, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xedf2, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xedf3, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xed46, 0xedf5, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedf4, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xedf7, 0xedf8, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xedf6, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xedfa, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xedfb, 0xedfc, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xee40, 0xee41, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee43, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xee44, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee45,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xee48, NOCHAR, NOCHAR, NOCHAR, 0xee46, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xee47, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xee4a, 0xee49, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xee4b, NOCHAR, NOCHAR, 0xee4d, 0xee4c,
  NOCHAR, NOCHAR, NOCHAR, 0xee4e, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee4f,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee50, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee51, 0xee52, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xed8c, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xee53, 0xee54, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee57, 0xee55, NOCHAR,
  0xee56, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xee58, 0xee5a, 0xee5c, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee5d,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee5e, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xee5f, 0xee60, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xee64, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee66,
  0xee67, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee68, NOCHAR,
  NOCHAR, NOCHAR, 0xee6a, 0xee6b, 0xee6d, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xee6e, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee70, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xee6f, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xee71, 0xee72, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xed40, 0xee73, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee74, 0xee76,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xee77, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee78, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee79, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee7a, 0xee7b, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xee7c, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xed44, 0xee7d, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xee7e, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xee80, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee82,
  0xee85, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee86, 0xed41,
  0xee87, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee88, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee89,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee8a, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee8b, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee8c, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee8e, 0xee8f, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xee90, 0xee91, NOCHAR, NOCHAR, NOCHAR, 0xee92, 0xee93,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xee94, 0xee96, 0xee99, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee9a, 0xee9c, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee9d,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xee9f,
  NOCHAR, NOCHAR, 0xee9e, NOCHAR, NOCHAR, NOCHAR, 0xeea0, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeea3, 0xeea4, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeea1, 0xeea2, 0xeea5,
  NOCHAR, NOCHAR, NOCHAR, 0xeea7, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xeea6, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xeeae, 0xeea8, NOCHAR, 0xeeaa, NOCHAR, NOCHAR,
  NOCHAR, 0xeea9, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeeab,
  NOCHAR, NOCHAR, 0xeead, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xeeac, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xeeaf, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xeeb1, 0xeeb2, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xed43, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xeeb0, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xeeb6, NOCHAR, NOCHAR, 0xeeba, NOCHAR, 0xeeb8, NOCHAR,
  0xeeb4, NOCHAR, 0xeeb5, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xeeb9, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xeeb3, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xed49, NOCHAR, 0xeebd, NOCHAR, NOCHAR, NOCHAR,
  0xeec0, 0xeec2, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeec1, 0xeebf, NOCHAR, NOCHAR,
  0xeebc, NOCHAR, NOCHAR, NOCHAR, 0xeebb, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xed42,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeec4, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeec3,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xeec5, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeec6, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeec7, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeec8,
  0xeec9, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeeca, NOCHAR, NOCHAR, 0xeecb,
  0xeecc, 0xeecf, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, 0xeed0, 0xeed1, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeed2, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeed3, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeed4, NOCHAR,
  0xeed5, NOCHAR, 0xeed6, NOCHAR, NOCHAR, NOCHAR, 0xeed7, 0xeed8,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeed9, 0xeedc, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeede, 0xeedf, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0xeee0, NOCHAR, NOCHAR, 0xeee1, 0xeee3, NOCHAR, NOCHAR,
  0xeee2, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xeee4, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeee5, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeee6, 0xeee7,
  0xeee9, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeee8, 0xeeeb, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0xeeec, 0xedc4,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, 0xeecd, 0xed73, 0xed7e, 0xed80, 0xed95, 0xedbc,
  0xedcc, 0xedce, 0xedf9, 0xee42, 0xee59, 0xee61, 0xee62, 0xee63,
  0xee65, 0xee69, 0xee6c, 0xee75, 0xee81, 0xee83, 0xee84, 0xee8d,
  0xee95, 0xee97, 0xee98, 0xee9b, 0xeeb7, 0xeebe, 0xeece, 0xeeda,
  0xeedb, 0xeedd, 0xeeea, 0xeefc, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  0xeefb, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0x817c, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0x815f, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, 0x8160,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR, NOCHAR,
  NOCHAR, 0x8191, 0x8192, 0x81ca, NOCHAR, 0xeefa,
};

static const struct unim_index cp932ext_encmap[256] = {
/* 0x00 */ {0, 0, 0},
/* 0x01 */ {0, 0, 0},
/* 0x02 */ {0, 0, 0},
/* 0x03 */ {0, 0, 0},
/* 0x04 */ {0, 0, 0},
/* 0x05 */ {0, 0, 0},
/* 0x06 */ {0, 0, 0},
/* 0x07 */ {0, 0, 0},
/* 0x08 */ {0, 0, 0},
/* 0x09 */ {0, 0, 0},
/* 0x0A */ {0, 0, 0},
/* 0x0B */ {0, 0, 0},
/* 0x0C */ {0, 0, 0},
/* 0x0D */ {0, 0, 0},
/* 0x0E */ {0, 0, 0},
/* 0x0F */ {0, 0, 0},
/* 0x10 */ {0, 0, 0},
/* 0x11 */ {0, 0, 0},
/* 0x12 */ {0, 0, 0},
/* 0x13 */ {0, 0, 0},
/* 0x14 */ {0, 0, 0},
/* 0x15 */ {0, 0, 0},
/* 0x16 */ {0, 0, 0},
/* 0x17 */ {0, 0, 0},
/* 0x18 */ {0, 0, 0},
/* 0x19 */ {0, 0, 0},
/* 0x1A */ {0, 0, 0},
/* 0x1B */ {0, 0, 0},
/* 0x1C */ {0, 0, 0},
/* 0x1D */ {0, 0, 0},
/* 0x1E */ {0, 0, 0},
/* 0x1F */ {0, 0, 0},
/* 0x20 */ {0, 0, 0},
/* 0x21 */ {__cp932ext_encmap+0, 0x16, 0x79},
/* 0x22 */ {__cp932ext_encmap+100, 0x11, 0xbf},
/* 0x23 */ {0, 0, 0},
/* 0x24 */ {__cp932ext_encmap+275, 0x60, 0x73},
/* 0x25 */ {0, 0, 0},
/* 0x26 */ {0, 0, 0},
/* 0x27 */ {0, 0, 0},
/* 0x28 */ {0, 0, 0},
/* 0x29 */ {0, 0, 0},
/* 0x2A */ {0, 0, 0},
/* 0x2B */ {0, 0, 0},
/* 0x2C */ {0, 0, 0},
/* 0x2D */ {0, 0, 0},
/* 0x2E */ {0, 0, 0},
/* 0x2F */ {0, 0, 0},
/* 0x30 */ {__cp932ext_encmap+295, 0x1d, 0x1f},
/* 0x31 */ {0, 0, 0},
/* 0x32 */ {__cp932ext_encmap+298, 0x31, 0xa8},
/* 0x33 */ {__cp932ext_encmap+418, 0x03, 0xcd},
/* 0x34 */ {0, 0, 0},
/* 0x35 */ {0, 0, 0},
/* 0x36 */ {0, 0, 0},
/* 0x37 */ {0, 0, 0},
/* 0x38 */ {0, 0, 0},
/* 0x39 */ {0, 0, 0},
/* 0x3A */ {0, 0, 0},
/* 0x3B */ {0, 0, 0},
/* 0x3C */ {0, 0, 0},
/* 0x3D */ {0, 0, 0},
/* 0x3E */ {0, 0, 0},
/* 0x3F */ {0, 0, 0},
/* 0x40 */ {0, 0, 0},
/* 0x41 */ {0, 0, 0},
/* 0x42 */ {0, 0, 0},
/* 0x43 */ {0, 0, 0},
/* 0x44 */ {0, 0, 0},
/* 0x45 */ {0, 0, 0},
/* 0x46 */ {0, 0, 0},
/* 0x47 */ {0, 0, 0},
/* 0x48 */ {0, 0, 0},
/* 0x49 */ {0, 0, 0},
/* 0x4A */ {0, 0, 0},
/* 0x4B */ {0, 0, 0},
/* 0x4C */ {0, 0, 0},
/* 0x4D */ {0, 0, 0},
/* 0x4E */ {__cp932ext_encmap+621, 0x28, 0xfc},
/* 0x4F */ {__cp932ext_encmap+834, 0x00, 0xff},
/* 0x50 */ {__cp932ext_encmap+1090, 0x1e, 0xf4},
/* 0x51 */ {__cp932ext_encmap+1305, 0x4a, 0xec},
/* 0x52 */ {__cp932ext_encmap+1468, 0x15, 0xdb},
/* 0x53 */ {__cp932ext_encmap+1667, 0x00, 0xdd},
/* 0x54 */ {__cp932ext_encmap+1889, 0x8a, 0xff},
/* 0x55 */ {__cp932ext_encmap+2007, 0x86, 0x86},
/* 0x56 */ {0, 0, 0},
/* 0x57 */ {__cp932ext_encmap+2008, 0x59, 0xc8},
/* 0x58 */ {__cp932ext_encmap+2120, 0x9e, 0xb2},
/* 0x59 */ {__cp932ext_encmap+2141, 0x0b, 0xba},
/* 0x5A */ {0, 0, 0},
/* 0x5B */ {__cp932ext_encmap+2317, 0x56, 0xec},
/* 0x5C */ {__cp932ext_encmap+2468, 0x1e, 0xf5},
/* 0x5D */ {__cp932ext_encmap+2684, 0x27, 0xd0},
/* 0x5E */ {0, 0, 0},
/* 0x5F */ {__cp932ext_encmap+2854, 0x21, 0xde},
/* 0x60 */ {__cp932ext_encmap+3044, 0x5d, 0xf2},
/* 0x61 */ {__cp932ext_encmap+3194, 0x11, 0x98},
/* 0x62 */ {__cp932ext_encmap+3330, 0x13, 0xa6},
/* 0x63 */ {__cp932ext_encmap+3478, 0xf5, 0xf5},
/* 0x64 */ {__cp932ext_encmap+3479, 0x60, 0xce},
/* 0x65 */ {__cp932ext_encmap+3590, 0x4e, 0x4e},
/* 0x66 */ {__cp932ext_encmap+3591, 0x00, 0xfb},
/* 0x67 */ {__cp932ext_encmap+3843, 0x0e, 0xc0},
/* 0x68 */ {__cp932ext_encmap+4022, 0x01, 0xcf},
/* 0x69 */ {__cp932ext_encmap+4229, 0x68, 0xe2},
/* 0x6A */ {__cp932ext_encmap+4352, 0x30, 0xe4},
/* 0x6B */ {__cp932ext_encmap+4533, 0xd6, 0xd6},
/* 0x6C */ {__cp932ext_encmap+4534, 0x3f, 0xda},
/* 0x6D */ {__cp932ext_encmap+4690, 0x04, 0xfc},
/* 0x6E */ {__cp932ext_encmap+4939, 0x27, 0xbf},
/* 0x6F */ {__cp932ext_encmap+5092, 0x88, 0xf5},
/* 0x70 */ {__cp932ext_encmap+5202, 0x05, 0xbb},
/* 0x71 */ {__cp932ext_encmap+5385, 0x04, 0xfe},
/* 0x72 */ {__cp932ext_encmap+5636, 0xb1, 0xbe},
/* 0x73 */ {__cp932ext_encmap+5650, 0x24, 0xf5},
/* 0x74 */ {__cp932ext_encmap+5860, 0x07, 0x9f},
/* 0x75 */ {__cp932ext_encmap+6013, 0x01, 0x6f},
/* 0x76 */ {__cp932ext_encmap+6124, 0x82, 0xa6},
/* 0x77 */ {__cp932ext_encmap+6161, 0x46, 0x46},
/* 0x78 */ {__cp932ext_encmap+6162, 0x21, 0x7a},
/* 0x79 */ {__cp932ext_encmap+6252, 0x30, 0x9b},
/* 0x7A */ {__cp932ext_encmap+6360, 0xd1, 0xeb},
/* 0x7B */ {__cp932ext_encmap+6387, 0x9e, 0x9e},
/* 0x7C */ {0, 0, 0},
/* 0x7D */ {__cp932ext_encmap+6388, 0x48, 0xd6},
/* 0x7E */ {__cp932ext_encmap+6531, 0x52, 0x8a},
/* 0x7F */ {__cp932ext_encmap+6588, 0x47, 0xa1},
/* 0x80 */ {0, 0, 0},
/* 0x81 */ {0, 0, 0},
/* 0x82 */ {0, 0, 0},
/* 0x83 */ {__cp932ext_encmap+6679, 0x01, 0xf6},
/* 0x84 */ {__cp932ext_encmap+6925, 0x48, 0xdc},
/* 0x85 */ {__cp932ext_encmap+7074, 0x53, 0xb0},
/* 0x86 */ {0, 0, 0},
/* 0x87 */ {0, 0, 0},
/* 0x88 */ {__cp932ext_encmap+7168, 0x07, 0xf5},
/* 0x89 */ {__cp932ext_encmap+7407, 0x1c, 0x1c},
/* 0x8A */ {__cp932ext_encmap+7408, 0x12, 0xf6},
/* 0x8B */ {__cp932ext_encmap+7637, 0x53, 0x7f},
/* 0x8C */ {__cp932ext_encmap+7682, 0xf0, 0xf4},
/* 0x8D */ {__cp932ext_encmap+7687, 0x12, 0x76},
/* 0x8E */ {__cp932ext_encmap+7788, 0xcf, 0xcf},
/* 0x8F */ {0, 0, 0},
/* 0x90 */ {__cp932ext_encmap+7789, 0x67, 0xde},
/* 0x91 */ {__cp932ext_encmap+7909, 0x15, 0xee},
/* 0x92 */ {__cp932ext_encmap+8127, 0x06, 0xff},
/* 0x93 */ {__cp932ext_encmap+8377, 0x02, 0xf8},
/* 0x94 */ {__cp932ext_encmap+8624, 0x31, 0x48},
/* 0x95 */ {__cp932ext_encmap+8648, 0x92, 0x92},
/* 0x96 */ {__cp932ext_encmap+8649, 0x9d, 0xaf},
/* 0x97 */ {__cp932ext_encmap+8668, 0x33, 0x55},
/* 0x98 */ {__cp932ext_encmap+8703, 0x57, 0x65},
/* 0x99 */ {__cp932ext_encmap+8718, 0x27, 0x9e},
/* 0x9A */ {__cp932ext_encmap+8838, 0x4e, 0xdc},
/* 0x9B */ {__cp932ext_encmap+8981, 0x72, 0xbb},
/* 0x9C */ {__cp932ext_encmap+9055, 0x00, 0x00},
/* 0x9D */ {__cp932ext_encmap+9056, 0x6b, 0x70},
/* 0x9E */ {__cp932ext_encmap+9062, 0x19, 0xd1},
/* 0x9F */ {0, 0, 0},
/* 0xA0 */ {0, 0, 0},
/* 0xA1 */ {0, 0, 0},
/* 0xA2 */ {0, 0, 0},
/* 0xA3 */ {0, 0, 0},
/* 0xA4 */ {0, 0, 0},
/* 0xA5 */ {0, 0, 0},
/* 0xA6 */ {0, 0, 0},
/* 0xA7 */ {0, 0, 0},
/* 0xA8 */ {0, 0, 0},
/* 0xA9 */ {0, 0, 0},
/* 0xAA */ {0, 0, 0},
/* 0xAB */ {0, 0, 0},
/* 0xAC */ {0, 0, 0},
/* 0xAD */ {0, 0, 0},
/* 0xAE */ {0, 0, 0},
/* 0xAF */ {0, 0, 0},
/* 0xB0 */ {0, 0, 0},
/* 0xB1 */ {0, 0, 0},
/* 0xB2 */ {0, 0, 0},
/* 0xB3 */ {0, 0, 0},
/* 0xB4 */ {0, 0, 0},
/* 0xB5 */ {0, 0, 0},
/* 0xB6 */ {0, 0, 0},
/* 0xB7 */ {0, 0, 0},
/* 0xB8 */ {0, 0, 0},
/* 0xB9 */ {0, 0, 0},
/* 0xBA */ {0, 0, 0},
/* 0xBB */ {0, 0, 0},
/* 0xBC */ {0, 0, 0},
/* 0xBD */ {0, 0, 0},
/* 0xBE */ {0, 0, 0},
/* 0xBF */ {0, 0, 0},
/* 0xC0 */ {0, 0, 0},
/* 0xC1 */ {0, 0, 0},
/* 0xC2 */ {0, 0, 0},
/* 0xC3 */ {0, 0, 0},
/* 0xC4 */ {0, 0, 0},
/* 0xC5 */ {0, 0, 0},
/* 0xC6 */ {0, 0, 0},
/* 0xC7 */ {0, 0, 0},
/* 0xC8 */ {0, 0, 0},
/* 0xC9 */ {0, 0, 0},
/* 0xCA */ {0, 0, 0},
/* 0xCB */ {0, 0, 0},
/* 0xCC */ {0, 0, 0},
/* 0xCD */ {0, 0, 0},
/* 0xCE */ {0, 0, 0},
/* 0xCF */ {0, 0, 0},
/* 0xD0 */ {0, 0, 0},
/* 0xD1 */ {0, 0, 0},
/* 0xD2 */ {0, 0, 0},
/* 0xD3 */ {0, 0, 0},
/* 0xD4 */ {0, 0, 0},
/* 0xD5 */ {0, 0, 0},
/* 0xD6 */ {0, 0, 0},
/* 0xD7 */ {0, 0, 0},
/* 0xD8 */ {0, 0, 0},
/* 0xD9 */ {0, 0, 0},
/* 0xDA */ {0, 0, 0},
/* 0xDB */ {0, 0, 0},
/* 0xDC */ {0, 0, 0},
/* 0xDD */ {0, 0, 0},
/* 0xDE */ {0, 0, 0},
/* 0xDF */ {0, 0, 0},
/* 0xE0 */ {0, 0, 0},
/* 0xE1 */ {0, 0, 0},
/* 0xE2 */ {0, 0, 0},
/* 0xE3 */ {0, 0, 0},
/* 0xE4 */ {0, 0, 0},
/* 0xE5 */ {0, 0, 0},
/* 0xE6 */ {0, 0, 0},
/* 0xE7 */ {0, 0, 0},
/* 0xE8 */ {0, 0, 0},
/* 0xE9 */ {0, 0, 0},
/* 0xEA */ {0, 0, 0},
/* 0xEB */ {0, 0, 0},
/* 0xEC */ {0, 0, 0},
/* 0xED */ {0, 0, 0},
/* 0xEE */ {0, 0, 0},
/* 0xEF */ {0, 0, 0},
/* 0xF0 */ {0, 0, 0},
/* 0xF1 */ {0, 0, 0},
/* 0xF2 */ {0, 0, 0},
/* 0xF3 */ {0, 0, 0},
/* 0xF4 */ {0, 0, 0},
/* 0xF5 */ {0, 0, 0},
/* 0xF6 */ {0, 0, 0},
/* 0xF7 */ {0, 0, 0},
/* 0xF8 */ {0, 0, 0},
/* 0xF9 */ {__cp932ext_encmap+9247, 0x29, 0xdc},
/* 0xFA */ {__cp932ext_encmap+9427, 0x0e, 0x2d},
/* 0xFB */ {0, 0, 0},
/* 0xFC */ {0, 0, 0},
/* 0xFD */ {0, 0, 0},
/* 0xFE */ {0, 0, 0},
/* 0xFF */ {__cp932ext_encmap+9459, 0x02, 0xe4},
};

