# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum

class CjkBigramTokenFilterScripts(str, Enum):
    """Scripts that can be ignored by CjkBigramTokenFilter.
    """

    han = "han"  #: Ignore Han script when forming bigrams of CJK terms.
    hiragana = "hiragana"  #: Ignore Hiragana script when forming bigrams of CJK terms.
    katakana = "katakana"  #: Ignore Katakana script when forming bigrams of CJK terms.
    hangul = "hangul"  #: Ignore Hangul script when forming bigrams of CJK terms.

class EdgeNGramTokenFilterSide(str, Enum):
    """Specifies which side of the input an n-gram should be generated from.
    """

    front = "front"  #: Specifies that the n-gram should be generated from the front of the input.
    back = "back"  #: Specifies that the n-gram should be generated from the back of the input.

class EntityCategory(str, Enum):
    """A string indicating what entity categories to return.
    """

    location = "location"  #: Entities describing a physical location.
    organization = "organization"  #: Entities describing an organization.
    person = "person"  #: Entities describing a person.
    quantity = "quantity"  #: Entities describing a quantity.
    datetime = "datetime"  #: Entities describing a date and time.
    url = "url"  #: Entities describing a URL.
    email = "email"  #: Entities describing an email address.

class EntityRecognitionSkillLanguage(str, Enum):
    """The language codes supported for input text by EntityRecognitionSkill.
    """

    ar = "ar"  #: Arabic.
    cs = "cs"  #: Czech.
    zh_hans = "zh-Hans"  #: Chinese-Simplified.
    zh_hant = "zh-Hant"  #: Chinese-Traditional.
    da = "da"  #: Danish.
    nl = "nl"  #: Dutch.
    en = "en"  #: English.
    fi = "fi"  #: Finnish.
    fr = "fr"  #: French.
    de = "de"  #: German.
    el = "el"  #: Greek.
    hu = "hu"  #: Hungarian.
    it = "it"  #: Italian.
    ja = "ja"  #: Japanese.
    ko = "ko"  #: Korean.
    no = "no"  #: Norwegian (Bokmaal).
    pl = "pl"  #: Polish.
    pt = "pt-PT"  #: Portuguese (Portugal).
    pt_br = "pt-BR"  #: Portuguese (Brazil).
    ru = "ru"  #: Russian.
    es = "es"  #: Spanish.
    sv = "sv"  #: Swedish.
    tr = "tr"  #: Turkish.

class ImageAnalysisSkillLanguage(str, Enum):
    """The language codes supported for input by ImageAnalysisSkill.
    """

    en = "en"  #: English.
    es = "es"  #: Spanish.
    ja = "ja"  #: Japanese.
    pt = "pt"  #: Portuguese.
    zh = "zh"  #: Chinese.

class ImageDetail(str, Enum):
    """A string indicating which domain-specific details to return.
    """

    celebrities = "celebrities"  #: Details recognized as celebrities.
    landmarks = "landmarks"  #: Details recognized as landmarks.

class IndexerExecutionStatus(str, Enum):
    """Represents the status of an individual indexer execution.
    """

    transient_failure = "transientFailure"  #: An indexer invocation has failed, but the failure may be transient. Indexer invocations will continue per schedule.
    success = "success"  #: Indexer execution completed successfully.
    in_progress = "inProgress"  #: Indexer execution is in progress.
    reset = "reset"  #: Indexer has been reset.

class IndexerStatus(str, Enum):
    """Represents the overall indexer status.
    """

    unknown = "unknown"  #: Indicates that the indexer is in an unknown state.
    error = "error"  #: Indicates that the indexer experienced an error that cannot be corrected without human intervention.
    running = "running"  #: Indicates that the indexer is running normally.

class KeyPhraseExtractionSkillLanguage(str, Enum):
    """The language codes supported for input text by KeyPhraseExtractionSkill.
    """

    da = "da"  #: Danish.
    nl = "nl"  #: Dutch.
    en = "en"  #: English.
    fi = "fi"  #: Finnish.
    fr = "fr"  #: French.
    de = "de"  #: German.
    it = "it"  #: Italian.
    ja = "ja"  #: Japanese.
    ko = "ko"  #: Korean.
    no = "no"  #: Norwegian (Bokmaal).
    pl = "pl"  #: Polish.
    pt = "pt-PT"  #: Portuguese (Portugal).
    pt_br = "pt-BR"  #: Portuguese (Brazil).
    ru = "ru"  #: Russian.
    es = "es"  #: Spanish.
    sv = "sv"  #: Swedish.

class LexicalAnalyzerName(str, Enum):
    """Defines the names of all text analyzers supported by Azure Cognitive Search.
    """

    ar_microsoft = "ar.microsoft"  #: Microsoft analyzer for Arabic.
    ar_lucene = "ar.lucene"  #: Lucene analyzer for Arabic.
    hy_lucene = "hy.lucene"  #: Lucene analyzer for Armenian.
    bn_microsoft = "bn.microsoft"  #: Microsoft analyzer for Bangla.
    eu_lucene = "eu.lucene"  #: Lucene analyzer for Basque.
    bg_microsoft = "bg.microsoft"  #: Microsoft analyzer for Bulgarian.
    bg_lucene = "bg.lucene"  #: Lucene analyzer for Bulgarian.
    ca_microsoft = "ca.microsoft"  #: Microsoft analyzer for Catalan.
    ca_lucene = "ca.lucene"  #: Lucene analyzer for Catalan.
    zh_hans_microsoft = "zh-Hans.microsoft"  #: Microsoft analyzer for Chinese (Simplified).
    zh_hans_lucene = "zh-Hans.lucene"  #: Lucene analyzer for Chinese (Simplified).
    zh_hant_microsoft = "zh-Hant.microsoft"  #: Microsoft analyzer for Chinese (Traditional).
    zh_hant_lucene = "zh-Hant.lucene"  #: Lucene analyzer for Chinese (Traditional).
    hr_microsoft = "hr.microsoft"  #: Microsoft analyzer for Croatian.
    cs_microsoft = "cs.microsoft"  #: Microsoft analyzer for Czech.
    cs_lucene = "cs.lucene"  #: Lucene analyzer for Czech.
    da_microsoft = "da.microsoft"  #: Microsoft analyzer for Danish.
    da_lucene = "da.lucene"  #: Lucene analyzer for Danish.
    nl_microsoft = "nl.microsoft"  #: Microsoft analyzer for Dutch.
    nl_lucene = "nl.lucene"  #: Lucene analyzer for Dutch.
    en_microsoft = "en.microsoft"  #: Microsoft analyzer for English.
    en_lucene = "en.lucene"  #: Lucene analyzer for English.
    et_microsoft = "et.microsoft"  #: Microsoft analyzer for Estonian.
    fi_microsoft = "fi.microsoft"  #: Microsoft analyzer for Finnish.
    fi_lucene = "fi.lucene"  #: Lucene analyzer for Finnish.
    fr_microsoft = "fr.microsoft"  #: Microsoft analyzer for French.
    fr_lucene = "fr.lucene"  #: Lucene analyzer for French.
    gl_lucene = "gl.lucene"  #: Lucene analyzer for Galician.
    de_microsoft = "de.microsoft"  #: Microsoft analyzer for German.
    de_lucene = "de.lucene"  #: Lucene analyzer for German.
    el_microsoft = "el.microsoft"  #: Microsoft analyzer for Greek.
    el_lucene = "el.lucene"  #: Lucene analyzer for Greek.
    gu_microsoft = "gu.microsoft"  #: Microsoft analyzer for Gujarati.
    he_microsoft = "he.microsoft"  #: Microsoft analyzer for Hebrew.
    hi_microsoft = "hi.microsoft"  #: Microsoft analyzer for Hindi.
    hi_lucene = "hi.lucene"  #: Lucene analyzer for Hindi.
    hu_microsoft = "hu.microsoft"  #: Microsoft analyzer for Hungarian.
    hu_lucene = "hu.lucene"  #: Lucene analyzer for Hungarian.
    is_microsoft = "is.microsoft"  #: Microsoft analyzer for Icelandic.
    id_microsoft = "id.microsoft"  #: Microsoft analyzer for Indonesian (Bahasa).
    id_lucene = "id.lucene"  #: Lucene analyzer for Indonesian.
    ga_lucene = "ga.lucene"  #: Lucene analyzer for Irish.
    it_microsoft = "it.microsoft"  #: Microsoft analyzer for Italian.
    it_lucene = "it.lucene"  #: Lucene analyzer for Italian.
    ja_microsoft = "ja.microsoft"  #: Microsoft analyzer for Japanese.
    ja_lucene = "ja.lucene"  #: Lucene analyzer for Japanese.
    kn_microsoft = "kn.microsoft"  #: Microsoft analyzer for Kannada.
    ko_microsoft = "ko.microsoft"  #: Microsoft analyzer for Korean.
    ko_lucene = "ko.lucene"  #: Lucene analyzer for Korean.
    lv_microsoft = "lv.microsoft"  #: Microsoft analyzer for Latvian.
    lv_lucene = "lv.lucene"  #: Lucene analyzer for Latvian.
    lt_microsoft = "lt.microsoft"  #: Microsoft analyzer for Lithuanian.
    ml_microsoft = "ml.microsoft"  #: Microsoft analyzer for Malayalam.
    ms_microsoft = "ms.microsoft"  #: Microsoft analyzer for Malay (Latin).
    mr_microsoft = "mr.microsoft"  #: Microsoft analyzer for Marathi.
    nb_microsoft = "nb.microsoft"  #: Microsoft analyzer for Norwegian (Bokmål).
    no_lucene = "no.lucene"  #: Lucene analyzer for Norwegian.
    fa_lucene = "fa.lucene"  #: Lucene analyzer for Persian.
    pl_microsoft = "pl.microsoft"  #: Microsoft analyzer for Polish.
    pl_lucene = "pl.lucene"  #: Lucene analyzer for Polish.
    pt_br_microsoft = "pt-BR.microsoft"  #: Microsoft analyzer for Portuguese (Brazil).
    pt_br_lucene = "pt-BR.lucene"  #: Lucene analyzer for Portuguese (Brazil).
    pt_microsoft = "pt-PT.microsoft"  #: Microsoft analyzer for Portuguese (Portugal).
    pt_lucene = "pt-PT.lucene"  #: Lucene analyzer for Portuguese (Portugal).
    pa_microsoft = "pa.microsoft"  #: Microsoft analyzer for Punjabi.
    ro_microsoft = "ro.microsoft"  #: Microsoft analyzer for Romanian.
    ro_lucene = "ro.lucene"  #: Lucene analyzer for Romanian.
    ru_microsoft = "ru.microsoft"  #: Microsoft analyzer for Russian.
    ru_lucene = "ru.lucene"  #: Lucene analyzer for Russian.
    sr_cyrillic_microsoft = "sr-cyrillic.microsoft"  #: Microsoft analyzer for Serbian (Cyrillic).
    sr_latin_microsoft = "sr-latin.microsoft"  #: Microsoft analyzer for Serbian (Latin).
    sk_microsoft = "sk.microsoft"  #: Microsoft analyzer for Slovak.
    sl_microsoft = "sl.microsoft"  #: Microsoft analyzer for Slovenian.
    es_microsoft = "es.microsoft"  #: Microsoft analyzer for Spanish.
    es_lucene = "es.lucene"  #: Lucene analyzer for Spanish.
    sv_microsoft = "sv.microsoft"  #: Microsoft analyzer for Swedish.
    sv_lucene = "sv.lucene"  #: Lucene analyzer for Swedish.
    ta_microsoft = "ta.microsoft"  #: Microsoft analyzer for Tamil.
    te_microsoft = "te.microsoft"  #: Microsoft analyzer for Telugu.
    th_microsoft = "th.microsoft"  #: Microsoft analyzer for Thai.
    th_lucene = "th.lucene"  #: Lucene analyzer for Thai.
    tr_microsoft = "tr.microsoft"  #: Microsoft analyzer for Turkish.
    tr_lucene = "tr.lucene"  #: Lucene analyzer for Turkish.
    uk_microsoft = "uk.microsoft"  #: Microsoft analyzer for Ukrainian.
    ur_microsoft = "ur.microsoft"  #: Microsoft analyzer for Urdu.
    vi_microsoft = "vi.microsoft"  #: Microsoft analyzer for Vietnamese.
    standard_lucene = "standard.lucene"  #: Standard Lucene analyzer.
    standard_ascii_folding_lucene = "standardasciifolding.lucene"  #: Standard ASCII Folding Lucene analyzer. See https://docs.microsoft.com/rest/api/searchservice/Custom-analyzers-in-Azure-Search#Analyzers.
    keyword = "keyword"  #: Treats the entire content of a field as a single token. This is useful for data like zip codes, ids, and some product names. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/KeywordAnalyzer.html.
    pattern = "pattern"  #: Flexibly separates text into terms via a regular expression pattern. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/miscellaneous/PatternAnalyzer.html.
    simple = "simple"  #: Divides text at non-letters and converts them to lower case. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/SimpleAnalyzer.html.
    stop = "stop"  #: Divides text at non-letters; Applies the lowercase and stopword token filters. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/StopAnalyzer.html.
    whitespace = "whitespace"  #: An analyzer that uses the whitespace tokenizer. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/WhitespaceAnalyzer.html.

class LexicalTokenizerName(str, Enum):
    """Defines the names of all tokenizers supported by Azure Cognitive Search.
    """

    classic = "classic"  #: Grammar-based tokenizer that is suitable for processing most European-language documents. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/standard/ClassicTokenizer.html.
    edge_n_gram = "edgeNGram"  #: Tokenizes the input from an edge into n-grams of the given size(s). See https://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/ngram/EdgeNGramTokenizer.html.
    keyword = "keyword_v2"  #: Emits the entire input as a single token. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/KeywordTokenizer.html.
    letter = "letter"  #: Divides text at non-letters. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/LetterTokenizer.html.
    lowercase = "lowercase"  #: Divides text at non-letters and converts them to lower case. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/LowerCaseTokenizer.html.
    microsoft_language_tokenizer = "microsoft_language_tokenizer"  #: Divides text using language-specific rules.
    microsoft_language_stemming_tokenizer = "microsoft_language_stemming_tokenizer"  #: Divides text using language-specific rules and reduces words to their base forms.
    n_gram = "nGram"  #: Tokenizes the input into n-grams of the given size(s). See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/ngram/NGramTokenizer.html.
    path_hierarchy = "path_hierarchy_v2"  #: Tokenizer for path-like hierarchies. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/path/PathHierarchyTokenizer.html.
    pattern = "pattern"  #: Tokenizer that uses regex pattern matching to construct distinct tokens. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/pattern/PatternTokenizer.html.
    standard = "standard_v2"  #: Standard Lucene analyzer; Composed of the standard tokenizer, lowercase filter and stop filter. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/standard/StandardTokenizer.html.
    uax_url_email = "uax_url_email"  #: Tokenizes urls and emails as one token. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/standard/UAX29URLEmailTokenizer.html.
    whitespace = "whitespace"  #: Divides text at whitespace. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/WhitespaceTokenizer.html.

class MicrosoftStemmingTokenizerLanguage(str, Enum):
    """Lists the languages supported by the Microsoft language stemming tokenizer.
    """

    arabic = "arabic"  #: Selects the Microsoft stemming tokenizer for Arabic.
    bangla = "bangla"  #: Selects the Microsoft stemming tokenizer for Bangla.
    bulgarian = "bulgarian"  #: Selects the Microsoft stemming tokenizer for Bulgarian.
    catalan = "catalan"  #: Selects the Microsoft stemming tokenizer for Catalan.
    croatian = "croatian"  #: Selects the Microsoft stemming tokenizer for Croatian.
    czech = "czech"  #: Selects the Microsoft stemming tokenizer for Czech.
    danish = "danish"  #: Selects the Microsoft stemming tokenizer for Danish.
    dutch = "dutch"  #: Selects the Microsoft stemming tokenizer for Dutch.
    english = "english"  #: Selects the Microsoft stemming tokenizer for English.
    estonian = "estonian"  #: Selects the Microsoft stemming tokenizer for Estonian.
    finnish = "finnish"  #: Selects the Microsoft stemming tokenizer for Finnish.
    french = "french"  #: Selects the Microsoft stemming tokenizer for French.
    german = "german"  #: Selects the Microsoft stemming tokenizer for German.
    greek = "greek"  #: Selects the Microsoft stemming tokenizer for Greek.
    gujarati = "gujarati"  #: Selects the Microsoft stemming tokenizer for Gujarati.
    hebrew = "hebrew"  #: Selects the Microsoft stemming tokenizer for Hebrew.
    hindi = "hindi"  #: Selects the Microsoft stemming tokenizer for Hindi.
    hungarian = "hungarian"  #: Selects the Microsoft stemming tokenizer for Hungarian.
    icelandic = "icelandic"  #: Selects the Microsoft stemming tokenizer for Icelandic.
    indonesian = "indonesian"  #: Selects the Microsoft stemming tokenizer for Indonesian.
    italian = "italian"  #: Selects the Microsoft stemming tokenizer for Italian.
    kannada = "kannada"  #: Selects the Microsoft stemming tokenizer for Kannada.
    latvian = "latvian"  #: Selects the Microsoft stemming tokenizer for Latvian.
    lithuanian = "lithuanian"  #: Selects the Microsoft stemming tokenizer for Lithuanian.
    malay = "malay"  #: Selects the Microsoft stemming tokenizer for Malay.
    malayalam = "malayalam"  #: Selects the Microsoft stemming tokenizer for Malayalam.
    marathi = "marathi"  #: Selects the Microsoft stemming tokenizer for Marathi.
    norwegian_bokmaal = "norwegianBokmaal"  #: Selects the Microsoft stemming tokenizer for Norwegian (Bokmål).
    polish = "polish"  #: Selects the Microsoft stemming tokenizer for Polish.
    portuguese = "portuguese"  #: Selects the Microsoft stemming tokenizer for Portuguese.
    portuguese_brazilian = "portugueseBrazilian"  #: Selects the Microsoft stemming tokenizer for Portuguese (Brazil).
    punjabi = "punjabi"  #: Selects the Microsoft stemming tokenizer for Punjabi.
    romanian = "romanian"  #: Selects the Microsoft stemming tokenizer for Romanian.
    russian = "russian"  #: Selects the Microsoft stemming tokenizer for Russian.
    serbian_cyrillic = "serbianCyrillic"  #: Selects the Microsoft stemming tokenizer for Serbian (Cyrillic).
    serbian_latin = "serbianLatin"  #: Selects the Microsoft stemming tokenizer for Serbian (Latin).
    slovak = "slovak"  #: Selects the Microsoft stemming tokenizer for Slovak.
    slovenian = "slovenian"  #: Selects the Microsoft stemming tokenizer for Slovenian.
    spanish = "spanish"  #: Selects the Microsoft stemming tokenizer for Spanish.
    swedish = "swedish"  #: Selects the Microsoft stemming tokenizer for Swedish.
    tamil = "tamil"  #: Selects the Microsoft stemming tokenizer for Tamil.
    telugu = "telugu"  #: Selects the Microsoft stemming tokenizer for Telugu.
    turkish = "turkish"  #: Selects the Microsoft stemming tokenizer for Turkish.
    ukrainian = "ukrainian"  #: Selects the Microsoft stemming tokenizer for Ukrainian.
    urdu = "urdu"  #: Selects the Microsoft stemming tokenizer for Urdu.

class MicrosoftTokenizerLanguage(str, Enum):
    """Lists the languages supported by the Microsoft language tokenizer.
    """

    bangla = "bangla"  #: Selects the Microsoft tokenizer for Bangla.
    bulgarian = "bulgarian"  #: Selects the Microsoft tokenizer for Bulgarian.
    catalan = "catalan"  #: Selects the Microsoft tokenizer for Catalan.
    chinese_simplified = "chineseSimplified"  #: Selects the Microsoft tokenizer for Chinese (Simplified).
    chinese_traditional = "chineseTraditional"  #: Selects the Microsoft tokenizer for Chinese (Traditional).
    croatian = "croatian"  #: Selects the Microsoft tokenizer for Croatian.
    czech = "czech"  #: Selects the Microsoft tokenizer for Czech.
    danish = "danish"  #: Selects the Microsoft tokenizer for Danish.
    dutch = "dutch"  #: Selects the Microsoft tokenizer for Dutch.
    english = "english"  #: Selects the Microsoft tokenizer for English.
    french = "french"  #: Selects the Microsoft tokenizer for French.
    german = "german"  #: Selects the Microsoft tokenizer for German.
    greek = "greek"  #: Selects the Microsoft tokenizer for Greek.
    gujarati = "gujarati"  #: Selects the Microsoft tokenizer for Gujarati.
    hindi = "hindi"  #: Selects the Microsoft tokenizer for Hindi.
    icelandic = "icelandic"  #: Selects the Microsoft tokenizer for Icelandic.
    indonesian = "indonesian"  #: Selects the Microsoft tokenizer for Indonesian.
    italian = "italian"  #: Selects the Microsoft tokenizer for Italian.
    japanese = "japanese"  #: Selects the Microsoft tokenizer for Japanese.
    kannada = "kannada"  #: Selects the Microsoft tokenizer for Kannada.
    korean = "korean"  #: Selects the Microsoft tokenizer for Korean.
    malay = "malay"  #: Selects the Microsoft tokenizer for Malay.
    malayalam = "malayalam"  #: Selects the Microsoft tokenizer for Malayalam.
    marathi = "marathi"  #: Selects the Microsoft tokenizer for Marathi.
    norwegian_bokmaal = "norwegianBokmaal"  #: Selects the Microsoft tokenizer for Norwegian (Bokmål).
    polish = "polish"  #: Selects the Microsoft tokenizer for Polish.
    portuguese = "portuguese"  #: Selects the Microsoft tokenizer for Portuguese.
    portuguese_brazilian = "portugueseBrazilian"  #: Selects the Microsoft tokenizer for Portuguese (Brazil).
    punjabi = "punjabi"  #: Selects the Microsoft tokenizer for Punjabi.
    romanian = "romanian"  #: Selects the Microsoft tokenizer for Romanian.
    russian = "russian"  #: Selects the Microsoft tokenizer for Russian.
    serbian_cyrillic = "serbianCyrillic"  #: Selects the Microsoft tokenizer for Serbian (Cyrillic).
    serbian_latin = "serbianLatin"  #: Selects the Microsoft tokenizer for Serbian (Latin).
    slovenian = "slovenian"  #: Selects the Microsoft tokenizer for Slovenian.
    spanish = "spanish"  #: Selects the Microsoft tokenizer for Spanish.
    swedish = "swedish"  #: Selects the Microsoft tokenizer for Swedish.
    tamil = "tamil"  #: Selects the Microsoft tokenizer for Tamil.
    telugu = "telugu"  #: Selects the Microsoft tokenizer for Telugu.
    thai = "thai"  #: Selects the Microsoft tokenizer for Thai.
    ukrainian = "ukrainian"  #: Selects the Microsoft tokenizer for Ukrainian.
    urdu = "urdu"  #: Selects the Microsoft tokenizer for Urdu.
    vietnamese = "vietnamese"  #: Selects the Microsoft tokenizer for Vietnamese.

class OcrSkillLanguage(str, Enum):
    """The language codes supported for input by OcrSkill.
    """

    zh_hans = "zh-Hans"  #: Chinese-Simplified.
    zh_hant = "zh-Hant"  #: Chinese-Traditional.
    cs = "cs"  #: Czech.
    da = "da"  #: Danish.
    nl = "nl"  #: Dutch.
    en = "en"  #: English.
    fi = "fi"  #: Finnish.
    fr = "fr"  #: French.
    de = "de"  #: German.
    el = "el"  #: Greek.
    hu = "hu"  #: Hungarian.
    it = "it"  #: Italian.
    ja = "ja"  #: Japanese.
    ko = "ko"  #: Korean.
    nb = "nb"  #: Norwegian (Bokmaal).
    pl = "pl"  #: Polish.
    pt = "pt"  #: Portuguese.
    ru = "ru"  #: Russian.
    es = "es"  #: Spanish.
    sv = "sv"  #: Swedish.
    tr = "tr"  #: Turkish.
    ar = "ar"  #: Arabic.
    ro = "ro"  #: Romanian.
    sr_cyrl = "sr-Cyrl"  #: Serbian (Cyrillic, Serbia).
    sr_latn = "sr-Latn"  #: Serbian (Latin, Serbia).
    sk = "sk"  #: Slovak.

class PhoneticEncoder(str, Enum):
    """Identifies the type of phonetic encoder to use with a PhoneticTokenFilter.
    """

    metaphone = "metaphone"  #: Encodes a token into a Metaphone value.
    double_metaphone = "doubleMetaphone"  #: Encodes a token into a double metaphone value.
    soundex = "soundex"  #: Encodes a token into a Soundex value.
    refined_soundex = "refinedSoundex"  #: Encodes a token into a Refined Soundex value.
    caverphone1 = "caverphone1"  #: Encodes a token into a Caverphone 1.0 value.
    caverphone2 = "caverphone2"  #: Encodes a token into a Caverphone 2.0 value.
    cologne = "cologne"  #: Encodes a token into a Cologne Phonetic value.
    nysiis = "nysiis"  #: Encodes a token into a NYSIIS value.
    koelner_phonetik = "koelnerPhonetik"  #: Encodes a token using the Kölner Phonetik algorithm.
    haase_phonetik = "haasePhonetik"  #: Encodes a token using the Haase refinement of the Kölner Phonetik algorithm.
    beider_morse = "beiderMorse"  #: Encodes a token into a Beider-Morse value.

class RegexFlags(str, Enum):
    """Defines flags that can be combined to control how regular expressions are used in the pattern
    analyzer and pattern tokenizer.
    """

    canon_eq = "CANON_EQ"  #: Enables canonical equivalence.
    case_insensitive = "CASE_INSENSITIVE"  #: Enables case-insensitive matching.
    comments = "COMMENTS"  #: Permits whitespace and comments in the pattern.
    dot_all = "DOTALL"  #: Enables dotall mode.
    literal = "LITERAL"  #: Enables literal parsing of the pattern.
    multiline = "MULTILINE"  #: Enables multiline mode.
    unicode_case = "UNICODE_CASE"  #: Enables Unicode-aware case folding.
    unix_lines = "UNIX_LINES"  #: Enables Unix lines mode.

class ScoringFunctionAggregation(str, Enum):
    """Defines the aggregation function used to combine the results of all the scoring functions in a
    scoring profile.
    """

    sum = "sum"  #: Boost scores by the sum of all scoring function results.
    average = "average"  #: Boost scores by the average of all scoring function results.
    minimum = "minimum"  #: Boost scores by the minimum of all scoring function results.
    maximum = "maximum"  #: Boost scores by the maximum of all scoring function results.
    first_matching = "firstMatching"  #: Boost scores using the first applicable scoring function in the scoring profile.

class ScoringFunctionInterpolation(str, Enum):
    """Defines the function used to interpolate score boosting across a range of documents.
    """

    linear = "linear"  #: Boosts scores by a linearly decreasing amount. This is the default interpolation for scoring functions.
    constant = "constant"  #: Boosts scores by a constant factor.
    quadratic = "quadratic"  #: Boosts scores by an amount that decreases quadratically. Boosts decrease slowly for higher scores, and more quickly as the scores decrease. This interpolation option is not allowed in tag scoring functions.
    logarithmic = "logarithmic"  #: Boosts scores by an amount that decreases logarithmically. Boosts decrease quickly for higher scores, and more slowly as the scores decrease. This interpolation option is not allowed in tag scoring functions.

class SearchFieldDataType(str, Enum):
    """Defines the data type of a field in a search index.
    """

    string = "Edm.String"  #: Indicates that a field contains a string.
    int32 = "Edm.Int32"  #: Indicates that a field contains a 32-bit signed integer.
    int64 = "Edm.Int64"  #: Indicates that a field contains a 64-bit signed integer.
    double = "Edm.Double"  #: Indicates that a field contains an IEEE double-precision floating point number.
    boolean = "Edm.Boolean"  #: Indicates that a field contains a Boolean value (true or false).
    date_time_offset = "Edm.DateTimeOffset"  #: Indicates that a field contains a date/time value, including timezone information.
    geography_point = "Edm.GeographyPoint"  #: Indicates that a field contains a geo-location in terms of longitude and latitude.
    complex = "Edm.ComplexType"  #: Indicates that a field contains one or more complex objects that in turn have sub-fields of other types.

class SearchIndexerDataSourceType(str, Enum):
    """Defines the type of a datasource.
    """

    azure_sql = "azuresql"  #: Indicates an Azure SQL datasource.
    cosmos_db = "cosmosdb"  #: Indicates a CosmosDB datasource.
    azure_blob = "azureblob"  #: Indicates a Azure Blob datasource.
    azure_table = "azuretable"  #: Indicates a Azure Table datasource.
    my_sql = "mysql"  #: Indicates a MySql datasource.

class SentimentSkillLanguage(str, Enum):
    """The language codes supported for input text by SentimentSkill.
    """

    da = "da"  #: Danish.
    nl = "nl"  #: Dutch.
    en = "en"  #: English.
    fi = "fi"  #: Finnish.
    fr = "fr"  #: French.
    de = "de"  #: German.
    el = "el"  #: Greek.
    it = "it"  #: Italian.
    no = "no"  #: Norwegian (Bokmaal).
    pl = "pl"  #: Polish.
    pt = "pt-PT"  #: Portuguese (Portugal).
    ru = "ru"  #: Russian.
    es = "es"  #: Spanish.
    sv = "sv"  #: Swedish.
    tr = "tr"  #: Turkish.

class SnowballTokenFilterLanguage(str, Enum):
    """The language to use for a Snowball token filter.
    """

    armenian = "armenian"  #: Selects the Lucene Snowball stemming tokenizer for Armenian.
    basque = "basque"  #: Selects the Lucene Snowball stemming tokenizer for Basque.
    catalan = "catalan"  #: Selects the Lucene Snowball stemming tokenizer for Catalan.
    danish = "danish"  #: Selects the Lucene Snowball stemming tokenizer for Danish.
    dutch = "dutch"  #: Selects the Lucene Snowball stemming tokenizer for Dutch.
    english = "english"  #: Selects the Lucene Snowball stemming tokenizer for English.
    finnish = "finnish"  #: Selects the Lucene Snowball stemming tokenizer for Finnish.
    french = "french"  #: Selects the Lucene Snowball stemming tokenizer for French.
    german = "german"  #: Selects the Lucene Snowball stemming tokenizer for German.
    german2 = "german2"  #: Selects the Lucene Snowball stemming tokenizer that uses the German variant algorithm.
    hungarian = "hungarian"  #: Selects the Lucene Snowball stemming tokenizer for Hungarian.
    italian = "italian"  #: Selects the Lucene Snowball stemming tokenizer for Italian.
    kp = "kp"  #: Selects the Lucene Snowball stemming tokenizer for Dutch that uses the Kraaij-Pohlmann stemming algorithm.
    lovins = "lovins"  #: Selects the Lucene Snowball stemming tokenizer for English that uses the Lovins stemming algorithm.
    norwegian = "norwegian"  #: Selects the Lucene Snowball stemming tokenizer for Norwegian.
    porter = "porter"  #: Selects the Lucene Snowball stemming tokenizer for English that uses the Porter stemming algorithm.
    portuguese = "portuguese"  #: Selects the Lucene Snowball stemming tokenizer for Portuguese.
    romanian = "romanian"  #: Selects the Lucene Snowball stemming tokenizer for Romanian.
    russian = "russian"  #: Selects the Lucene Snowball stemming tokenizer for Russian.
    spanish = "spanish"  #: Selects the Lucene Snowball stemming tokenizer for Spanish.
    swedish = "swedish"  #: Selects the Lucene Snowball stemming tokenizer for Swedish.
    turkish = "turkish"  #: Selects the Lucene Snowball stemming tokenizer for Turkish.

class SplitSkillLanguage(str, Enum):
    """The language codes supported for input text by SplitSkill.
    """

    da = "da"  #: Danish.
    de = "de"  #: German.
    en = "en"  #: English.
    es = "es"  #: Spanish.
    fi = "fi"  #: Finnish.
    fr = "fr"  #: French.
    it = "it"  #: Italian.
    ko = "ko"  #: Korean.
    pt = "pt"  #: Portuguese.

class StemmerTokenFilterLanguage(str, Enum):
    """The language to use for a stemmer token filter.
    """

    arabic = "arabic"  #: Selects the Lucene stemming tokenizer for Arabic.
    armenian = "armenian"  #: Selects the Lucene stemming tokenizer for Armenian.
    basque = "basque"  #: Selects the Lucene stemming tokenizer for Basque.
    brazilian = "brazilian"  #: Selects the Lucene stemming tokenizer for Portuguese (Brazil).
    bulgarian = "bulgarian"  #: Selects the Lucene stemming tokenizer for Bulgarian.
    catalan = "catalan"  #: Selects the Lucene stemming tokenizer for Catalan.
    czech = "czech"  #: Selects the Lucene stemming tokenizer for Czech.
    danish = "danish"  #: Selects the Lucene stemming tokenizer for Danish.
    dutch = "dutch"  #: Selects the Lucene stemming tokenizer for Dutch.
    dutch_kp = "dutchKp"  #: Selects the Lucene stemming tokenizer for Dutch that uses the Kraaij-Pohlmann stemming algorithm.
    english = "english"  #: Selects the Lucene stemming tokenizer for English.
    light_english = "lightEnglish"  #: Selects the Lucene stemming tokenizer for English that does light stemming.
    minimal_english = "minimalEnglish"  #: Selects the Lucene stemming tokenizer for English that does minimal stemming.
    possessive_english = "possessiveEnglish"  #: Selects the Lucene stemming tokenizer for English that removes trailing possessives from words.
    porter2 = "porter2"  #: Selects the Lucene stemming tokenizer for English that uses the Porter2 stemming algorithm.
    lovins = "lovins"  #: Selects the Lucene stemming tokenizer for English that uses the Lovins stemming algorithm.
    finnish = "finnish"  #: Selects the Lucene stemming tokenizer for Finnish.
    light_finnish = "lightFinnish"  #: Selects the Lucene stemming tokenizer for Finnish that does light stemming.
    french = "french"  #: Selects the Lucene stemming tokenizer for French.
    light_french = "lightFrench"  #: Selects the Lucene stemming tokenizer for French that does light stemming.
    minimal_french = "minimalFrench"  #: Selects the Lucene stemming tokenizer for French that does minimal stemming.
    galician = "galician"  #: Selects the Lucene stemming tokenizer for Galician.
    minimal_galician = "minimalGalician"  #: Selects the Lucene stemming tokenizer for Galician that does minimal stemming.
    german = "german"  #: Selects the Lucene stemming tokenizer for German.
    german2 = "german2"  #: Selects the Lucene stemming tokenizer that uses the German variant algorithm.
    light_german = "lightGerman"  #: Selects the Lucene stemming tokenizer for German that does light stemming.
    minimal_german = "minimalGerman"  #: Selects the Lucene stemming tokenizer for German that does minimal stemming.
    greek = "greek"  #: Selects the Lucene stemming tokenizer for Greek.
    hindi = "hindi"  #: Selects the Lucene stemming tokenizer for Hindi.
    hungarian = "hungarian"  #: Selects the Lucene stemming tokenizer for Hungarian.
    light_hungarian = "lightHungarian"  #: Selects the Lucene stemming tokenizer for Hungarian that does light stemming.
    indonesian = "indonesian"  #: Selects the Lucene stemming tokenizer for Indonesian.
    irish = "irish"  #: Selects the Lucene stemming tokenizer for Irish.
    italian = "italian"  #: Selects the Lucene stemming tokenizer for Italian.
    light_italian = "lightItalian"  #: Selects the Lucene stemming tokenizer for Italian that does light stemming.
    sorani = "sorani"  #: Selects the Lucene stemming tokenizer for Sorani.
    latvian = "latvian"  #: Selects the Lucene stemming tokenizer for Latvian.
    norwegian = "norwegian"  #: Selects the Lucene stemming tokenizer for Norwegian (Bokmål).
    light_norwegian = "lightNorwegian"  #: Selects the Lucene stemming tokenizer for Norwegian (Bokmål) that does light stemming.
    minimal_norwegian = "minimalNorwegian"  #: Selects the Lucene stemming tokenizer for Norwegian (Bokmål) that does minimal stemming.
    light_nynorsk = "lightNynorsk"  #: Selects the Lucene stemming tokenizer for Norwegian (Nynorsk) that does light stemming.
    minimal_nynorsk = "minimalNynorsk"  #: Selects the Lucene stemming tokenizer for Norwegian (Nynorsk) that does minimal stemming.
    portuguese = "portuguese"  #: Selects the Lucene stemming tokenizer for Portuguese.
    light_portuguese = "lightPortuguese"  #: Selects the Lucene stemming tokenizer for Portuguese that does light stemming.
    minimal_portuguese = "minimalPortuguese"  #: Selects the Lucene stemming tokenizer for Portuguese that does minimal stemming.
    portuguese_rslp = "portugueseRslp"  #: Selects the Lucene stemming tokenizer for Portuguese that uses the RSLP stemming algorithm.
    romanian = "romanian"  #: Selects the Lucene stemming tokenizer for Romanian.
    russian = "russian"  #: Selects the Lucene stemming tokenizer for Russian.
    light_russian = "lightRussian"  #: Selects the Lucene stemming tokenizer for Russian that does light stemming.
    spanish = "spanish"  #: Selects the Lucene stemming tokenizer for Spanish.
    light_spanish = "lightSpanish"  #: Selects the Lucene stemming tokenizer for Spanish that does light stemming.
    swedish = "swedish"  #: Selects the Lucene stemming tokenizer for Swedish.
    light_swedish = "lightSwedish"  #: Selects the Lucene stemming tokenizer for Swedish that does light stemming.
    turkish = "turkish"  #: Selects the Lucene stemming tokenizer for Turkish.

class StopwordsList(str, Enum):
    """Identifies a predefined list of language-specific stopwords.
    """

    arabic = "arabic"  #: Selects the stopword list for Arabic.
    armenian = "armenian"  #: Selects the stopword list for Armenian.
    basque = "basque"  #: Selects the stopword list for Basque.
    brazilian = "brazilian"  #: Selects the stopword list for Portuguese (Brazil).
    bulgarian = "bulgarian"  #: Selects the stopword list for Bulgarian.
    catalan = "catalan"  #: Selects the stopword list for Catalan.
    czech = "czech"  #: Selects the stopword list for Czech.
    danish = "danish"  #: Selects the stopword list for Danish.
    dutch = "dutch"  #: Selects the stopword list for Dutch.
    english = "english"  #: Selects the stopword list for English.
    finnish = "finnish"  #: Selects the stopword list for Finnish.
    french = "french"  #: Selects the stopword list for French.
    galician = "galician"  #: Selects the stopword list for Galician.
    german = "german"  #: Selects the stopword list for German.
    greek = "greek"  #: Selects the stopword list for Greek.
    hindi = "hindi"  #: Selects the stopword list for Hindi.
    hungarian = "hungarian"  #: Selects the stopword list for Hungarian.
    indonesian = "indonesian"  #: Selects the stopword list for Indonesian.
    irish = "irish"  #: Selects the stopword list for Irish.
    italian = "italian"  #: Selects the stopword list for Italian.
    latvian = "latvian"  #: Selects the stopword list for Latvian.
    norwegian = "norwegian"  #: Selects the stopword list for Norwegian.
    persian = "persian"  #: Selects the stopword list for Persian.
    portuguese = "portuguese"  #: Selects the stopword list for Portuguese.
    romanian = "romanian"  #: Selects the stopword list for Romanian.
    russian = "russian"  #: Selects the stopword list for Russian.
    sorani = "sorani"  #: Selects the stopword list for Sorani.
    spanish = "spanish"  #: Selects the stopword list for Spanish.
    swedish = "swedish"  #: Selects the stopword list for Swedish.
    thai = "thai"  #: Selects the stopword list for Thai.
    turkish = "turkish"  #: Selects the stopword list for Turkish.

class TextExtractionAlgorithm(str, Enum):
    """A value indicating which algorithm to use. Default is printed.
    """

    printed = "printed"  #: An algorithm suitable for printed text.
    handwritten = "handwritten"  #: An algorithm suitable for handwritten text.

class TextSplitMode(str, Enum):
    """A value indicating which split mode to perform.
    """

    pages = "pages"  #: Split the text into individual pages.
    sentences = "sentences"  #: Split the text into individual sentences.

class TextTranslationSkillLanguage(str, Enum):
    """The language codes supported for input text by TextTranslationSkill.
    """

    af = "af"  #: Afrikaans.
    ar = "ar"  #: Arabic.
    bn = "bn"  #: Bangla.
    bs = "bs"  #: Bosnian (Latin).
    bg = "bg"  #: Bulgarian.
    yue = "yue"  #: Cantonese (Traditional).
    ca = "ca"  #: Catalan.
    zh_hans = "zh-Hans"  #: Chinese Simplified.
    zh_hant = "zh-Hant"  #: Chinese Traditional.
    hr = "hr"  #: Croatian.
    cs = "cs"  #: Czech.
    da = "da"  #: Danish.
    nl = "nl"  #: Dutch.
    en = "en"  #: English.
    et = "et"  #: Estonian.
    fj = "fj"  #: Fijian.
    fil = "fil"  #: Filipino.
    fi = "fi"  #: Finnish.
    fr = "fr"  #: French.
    de = "de"  #: German.
    el = "el"  #: Greek.
    ht = "ht"  #: Haitian Creole.
    he = "he"  #: Hebrew.
    hi = "hi"  #: Hindi.
    mww = "mww"  #: Hmong Daw.
    hu = "hu"  #: Hungarian.
    is_enum = "is"  #: Icelandic.
    id = "id"  #: Indonesian.
    it = "it"  #: Italian.
    ja = "ja"  #: Japanese.
    sw = "sw"  #: Kiswahili.
    tlh = "tlh"  #: Klingon.
    ko = "ko"  #: Korean.
    lv = "lv"  #: Latvian.
    lt = "lt"  #: Lithuanian.
    mg = "mg"  #: Malagasy.
    ms = "ms"  #: Malay.
    mt = "mt"  #: Maltese.
    nb = "nb"  #: Norwegian.
    fa = "fa"  #: Persian.
    pl = "pl"  #: Polish.
    pt = "pt"  #: Portuguese.
    otq = "otq"  #: Queretaro Otomi.
    ro = "ro"  #: Romanian.
    ru = "ru"  #: Russian.
    sm = "sm"  #: Samoan.
    sr_cyrl = "sr-Cyrl"  #: Serbian (Cyrillic).
    sr_latn = "sr-Latn"  #: Serbian (Latin).
    sk = "sk"  #: Slovak.
    sl = "sl"  #: Slovenian.
    es = "es"  #: Spanish.
    sv = "sv"  #: Swedish.
    ty = "ty"  #: Tahitian.
    ta = "ta"  #: Tamil.
    te = "te"  #: Telugu.
    th = "th"  #: Thai.
    to = "to"  #: Tongan.
    tr = "tr"  #: Turkish.
    uk = "uk"  #: Ukrainian.
    ur = "ur"  #: Urdu.
    vi = "vi"  #: Vietnamese.
    cy = "cy"  #: Welsh.
    yua = "yua"  #: Yucatec Maya.

class TokenCharacterKind(str, Enum):
    """Represents classes of characters on which a token filter can operate.
    """

    letter = "letter"  #: Keeps letters in tokens.
    digit = "digit"  #: Keeps digits in tokens.
    whitespace = "whitespace"  #: Keeps whitespace in tokens.
    punctuation = "punctuation"  #: Keeps punctuation in tokens.
    symbol = "symbol"  #: Keeps symbols in tokens.

class TokenFilterName(str, Enum):
    """Defines the names of all token filters supported by Azure Cognitive Search.
    """

    arabic_normalization = "arabic_normalization"  #: A token filter that applies the Arabic normalizer to normalize the orthography. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/ar/ArabicNormalizationFilter.html.
    apostrophe = "apostrophe"  #: Strips all characters after an apostrophe (including the apostrophe itself). See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/tr/ApostropheFilter.html.
    ascii_folding = "asciifolding"  #: Converts alphabetic, numeric, and symbolic Unicode characters which are not in the first 127 ASCII characters (the "Basic Latin" Unicode block) into their ASCII equivalents, if such equivalents exist. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/miscellaneous/ASCIIFoldingFilter.html.
    cjk_bigram = "cjk_bigram"  #: Forms bigrams of CJK terms that are generated from the standard tokenizer. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/cjk/CJKBigramFilter.html.
    cjk_width = "cjk_width"  #: Normalizes CJK width differences. Folds fullwidth ASCII variants into the equivalent basic Latin, and half-width Katakana variants into the equivalent Kana. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/cjk/CJKWidthFilter.html.
    classic = "classic"  #: Removes English possessives, and dots from acronyms. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/standard/ClassicFilter.html.
    common_gram = "common_grams"  #: Construct bigrams for frequently occurring terms while indexing. Single terms are still indexed too, with bigrams overlaid. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/commongrams/CommonGramsFilter.html.
    edge_n_gram = "edgeNGram_v2"  #: Generates n-grams of the given size(s) starting from the front or the back of an input token. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/ngram/EdgeNGramTokenFilter.html.
    elision = "elision"  #: Removes elisions. For example, "l'avion" (the plane) will be converted to "avion" (plane). See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/util/ElisionFilter.html.
    german_normalization = "german_normalization"  #: Normalizes German characters according to the heuristics of the German2 snowball algorithm. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/de/GermanNormalizationFilter.html.
    hindi_normalization = "hindi_normalization"  #: Normalizes text in Hindi to remove some differences in spelling variations. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/hi/HindiNormalizationFilter.html.
    indic_normalization = "indic_normalization"  #: Normalizes the Unicode representation of text in Indian languages. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/in/IndicNormalizationFilter.html.
    keyword_repeat = "keyword_repeat"  #: Emits each incoming token twice, once as keyword and once as non-keyword. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/miscellaneous/KeywordRepeatFilter.html.
    k_stem = "kstem"  #: A high-performance kstem filter for English. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/en/KStemFilter.html.
    length = "length"  #: Removes words that are too long or too short. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/miscellaneous/LengthFilter.html.
    limit = "limit"  #: Limits the number of tokens while indexing. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/miscellaneous/LimitTokenCountFilter.html.
    lowercase = "lowercase"  #: Normalizes token text to lower case. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/LowerCaseFilter.htm.
    n_gram = "nGram_v2"  #: Generates n-grams of the given size(s). See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/ngram/NGramTokenFilter.html.
    persian_normalization = "persian_normalization"  #: Applies normalization for Persian. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/fa/PersianNormalizationFilter.html.
    phonetic = "phonetic"  #: Create tokens for phonetic matches. See https://lucene.apache.org/core/4_10_3/analyzers-phonetic/org/apache/lucene/analysis/phonetic/package-tree.html.
    porter_stem = "porter_stem"  #: Uses the Porter stemming algorithm to transform the token stream. See http://tartarus.org/~martin/PorterStemmer.
    reverse = "reverse"  #: Reverses the token string. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/reverse/ReverseStringFilter.html.
    scandinavian_normalization = "scandinavian_normalization"  #: Normalizes use of the interchangeable Scandinavian characters. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/miscellaneous/ScandinavianNormalizationFilter.html.
    scandinavian_folding_normalization = "scandinavian_folding"  #: Folds Scandinavian characters åÅäæÄÆ-&gt;a and öÖøØ-&gt;o. It also discriminates against use of double vowels aa, ae, ao, oe and oo, leaving just the first one. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/miscellaneous/ScandinavianFoldingFilter.html.
    shingle = "shingle"  #: Creates combinations of tokens as a single token. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/shingle/ShingleFilter.html.
    snowball = "snowball"  #: A filter that stems words using a Snowball-generated stemmer. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/snowball/SnowballFilter.html.
    sorani_normalization = "sorani_normalization"  #: Normalizes the Unicode representation of Sorani text. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/ckb/SoraniNormalizationFilter.html.
    stemmer = "stemmer"  #: Language specific stemming filter. See https://docs.microsoft.com/rest/api/searchservice/Custom-analyzers-in-Azure-Search#TokenFilters.
    stopwords = "stopwords"  #: Removes stop words from a token stream. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/StopFilter.html.
    trim = "trim"  #: Trims leading and trailing whitespace from tokens. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/miscellaneous/TrimFilter.html.
    truncate = "truncate"  #: Truncates the terms to a specific length. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/miscellaneous/TruncateTokenFilter.html.
    unique = "unique"  #: Filters out tokens with same text as the previous token. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/miscellaneous/RemoveDuplicatesTokenFilter.html.
    uppercase = "uppercase"  #: Normalizes token text to upper case. See http://lucene.apache.org/core/4_10_3/analyzers-common/org/apache/lucene/analysis/core/UpperCaseFilter.html.
    word_delimiter = "word_delimiter"  #: Splits words into subwords and performs optional transformations on subword groups.

class VisualFeature(str, Enum):
    """The strings indicating what visual feature types to return.
    """

    adult = "adult"  #: Visual features recognized as adult persons.
    brands = "brands"  #: Visual features recognized as commercial brands.
    categories = "categories"  #: Categories.
    description = "description"  #: Description.
    faces = "faces"  #: Visual features recognized as people faces.
    objects = "objects"  #: Visual features recognized as objects.
    tags = "tags"  #: Tags.
