# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AzureActiveDirectory(Model):
    """The settings to enable AAD authentication on the cluster.

    :param tenant_id: Azure active directory tenant id.
    :type tenant_id: str
    :param cluster_application: Azure active directory cluster application id.
    :type cluster_application: str
    :param client_application: Azure active directory client application id.
    :type client_application: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'cluster_application': {'key': 'clusterApplication', 'type': 'str'},
        'client_application': {'key': 'clientApplication', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureActiveDirectory, self).__init__(**kwargs)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.cluster_application = kwargs.get('cluster_application', None)
        self.client_application = kwargs.get('client_application', None)
