# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.account_filters_operations import AccountFiltersOperations
from .operations.operations import Operations
from .operations.mediaservices_operations import MediaservicesOperations
from .operations.locations_operations import LocationsOperations
from .operations.assets_operations import AssetsOperations
from .operations.asset_filters_operations import AssetFiltersOperations
from .operations.content_key_policies_operations import ContentKeyPoliciesOperations
from .operations.transforms_operations import TransformsOperations
from .operations.jobs_operations import JobsOperations
from .operations.streaming_policies_operations import StreamingPoliciesOperations
from .operations.streaming_locators_operations import StreamingLocatorsOperations
from .operations.live_events_operations import LiveEventsOperations
from .operations.live_outputs_operations import LiveOutputsOperations
from .operations.streaming_endpoints_operations import StreamingEndpointsOperations
from . import models


class AzureMediaServicesConfiguration(AzureConfiguration):
    """Configuration for AzureMediaServices
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The unique identifier for a Microsoft Azure
     subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(AzureMediaServicesConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-mgmt-media/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class AzureMediaServices(SDKClient):
    """AzureMediaServices

    :ivar config: Configuration for client.
    :vartype config: AzureMediaServicesConfiguration

    :ivar account_filters: AccountFilters operations
    :vartype account_filters: azure.mgmt.media.operations.AccountFiltersOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.media.operations.Operations
    :ivar mediaservices: Mediaservices operations
    :vartype mediaservices: azure.mgmt.media.operations.MediaservicesOperations
    :ivar locations: Locations operations
    :vartype locations: azure.mgmt.media.operations.LocationsOperations
    :ivar assets: Assets operations
    :vartype assets: azure.mgmt.media.operations.AssetsOperations
    :ivar asset_filters: AssetFilters operations
    :vartype asset_filters: azure.mgmt.media.operations.AssetFiltersOperations
    :ivar content_key_policies: ContentKeyPolicies operations
    :vartype content_key_policies: azure.mgmt.media.operations.ContentKeyPoliciesOperations
    :ivar transforms: Transforms operations
    :vartype transforms: azure.mgmt.media.operations.TransformsOperations
    :ivar jobs: Jobs operations
    :vartype jobs: azure.mgmt.media.operations.JobsOperations
    :ivar streaming_policies: StreamingPolicies operations
    :vartype streaming_policies: azure.mgmt.media.operations.StreamingPoliciesOperations
    :ivar streaming_locators: StreamingLocators operations
    :vartype streaming_locators: azure.mgmt.media.operations.StreamingLocatorsOperations
    :ivar live_events: LiveEvents operations
    :vartype live_events: azure.mgmt.media.operations.LiveEventsOperations
    :ivar live_outputs: LiveOutputs operations
    :vartype live_outputs: azure.mgmt.media.operations.LiveOutputsOperations
    :ivar streaming_endpoints: StreamingEndpoints operations
    :vartype streaming_endpoints: azure.mgmt.media.operations.StreamingEndpointsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The unique identifier for a Microsoft Azure
     subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = AzureMediaServicesConfiguration(credentials, subscription_id, base_url)
        super(AzureMediaServices, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2018-07-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.account_filters = AccountFiltersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.mediaservices = MediaservicesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.locations = LocationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.assets = AssetsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.asset_filters = AssetFiltersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.content_key_policies = ContentKeyPoliciesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.transforms = TransformsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.jobs = JobsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.streaming_policies = StreamingPoliciesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.streaming_locators = StreamingLocatorsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.live_events = LiveEventsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.live_outputs = LiveOutputsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.streaming_endpoints = StreamingEndpointsOperations(
            self._client, self.config, self._serialize, self._deserialize)
