# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BatchAccountKeys(Model):
    """A set of Azure Batch account keys.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar account_name: The Batch account name.
    :vartype account_name: str
    :ivar primary: The primary key associated with the account.
    :vartype primary: str
    :ivar secondary: The secondary key associated with the account.
    :vartype secondary: str
    """

    _validation = {
        'account_name': {'readonly': True},
        'primary': {'readonly': True},
        'secondary': {'readonly': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'primary': {'key': 'primary', 'type': 'str'},
        'secondary': {'key': 'secondary', 'type': 'str'},
    }

    def __init__(self):
        super(BatchAccountKeys, self).__init__()
        self.account_name = None
        self.primary = None
        self.secondary = None
