<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY bbschema "http://uche.ogbuji.net/example/buyerbase/schema#">
  <!ENTITY bb "http://uche.ogbuji.net/example/buyerbase">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:bbschema="&bbschema;"
  xmlns:bb="&bb;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time"
  exclude-result-prefixes="f frdf fhttp fcore fres exslt exslt-set exslt-math exslt-functions exslt-date-time dc bb rdf bbschema">


  <!--
File:  index.xslt

Description:

    This stylesheet creates the index of customers and provides links
    to pages where a customer's profile or their purchases can be
    edited, where new purchases can be added for a customer, and where
    a new customer can be added.

    This stylesheet can be applied to any XML source document. It gets
    the customer data from an RDF "complete".

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
  -->

  <xsl:include href="menu-includes.xslt"/>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="not(fcore:has-session())">
        <fhttp:response-uri uri="/buyerbase/?xslt=home.xslt"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="menus">
          <xsl:with-param name="pageTitle" select="'Buyer Base - Customer Index'"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="body">
    <table width="695">
      <tr>
        <td>
          <p class="blackTitle">
            <xsl:choose>
              <xsl:when test='fcore:has-session()'>
                <a href="{fres:uri-path}?xslt=customer.xslt">
                  <font color="#000000">Add New Customer</font>
                </a>
                <xsl:text>&nbsp;|&nbsp;</xsl:text>
                <a href="/buyerbase/?xslt=logout.xslt">
                  <font color="#000000">Logout</font>
                </a>
              </xsl:when>
              <xsl:otherwise>
                <a href="/buyerbase/?xslt=home.xslt">
                  <font color="#000000">Login</font>
                </a>
              </xsl:otherwise>
            </xsl:choose>
          </p>
        </td>
      </tr>
      <tr class="cellBlue">
        <td align="left" class="menucell"><div class="menu">Index of Customers</div></td>
      </tr>
      <tr>
        <td>
          <xsl:variable name="customer-list" select="frdf:complete(frdf:any(),'&rdf;type','&bbschema;Customer')"/>
          <xsl:choose>
            <xsl:when test="$customer-list">
              <form action="{fres:uri-path}?xslt=customer.xslt" method="post" name="customer">
                <table border="1" width="675" cellpadding="2" bgcolor="#FFFFFF" bordercolorlight="#C0C0C0" class="normal" align="center">
                  <tr class="cellGray">
                    <td width="250" align="center">
                      <div class="blackTitle">Name</div>
                    </td>
                    <td align="center">
                      <div class="blackTitle">
                        <xsl:text>Action</xsl:text>
                        <xsl:if test="fcore:has-session()"> (choose one)</xsl:if>
                      </div>
                    </td>
                  </tr>
                  <xsl:apply-templates select="$customer-list">
                    <xsl:sort select="Subject"/>
                  </xsl:apply-templates>
                </table>
              </form>
            </xsl:when>
            <xsl:otherwise>
              <div align="center" class="blackTitle">
                <xsl:text>[ </xsl:text>
                <i>no customers on file</i>
                <xsl:text> ]</xsl:text>
              </div>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="Statement">
    <xsl:variable name="name" select="frdf:complete(Subject,'&bbschema;name',frdf:any())"/>
    <xsl:variable name="fileName" select="fhttp:local-uri(Scope)"/>
    <!--
    <xsl:message>
      <xsl:value-of select='Scope'/>,
      <xsl:value-of select='$fileName'/>,
    </xsl:message>
    -->
    <tr>
      <td class="normal">
        <xsl:value-of select="concat('&#160;&#160;',$name/Object)"/>
      </td>
      <td class="normal" align="center">
        <xsl:text>&nbsp;&nbsp;</xsl:text>
        <xsl:if test='fcore:has-session()'>
          <a href="{$fileName}?xslt=../customer.xslt">Edit Profile</a>
          <xsl:text>&nbsp;&nbsp;|&nbsp;&nbsp;</xsl:text>
        </xsl:if>
        <a href="{$fileName}?xslt=../purchase-summary.xslt">View Purchases</a>
        <xsl:if test='fcore:has-session()'>
          <xsl:text>&nbsp;&nbsp;|&nbsp;&nbsp;</xsl:text>
          <a href="{$fileName}?xslt=../new-purchase.xslt">New Purchase</a>
        </xsl:if>
        <xsl:text>&nbsp;&nbsp;</xsl:text>
      </td>
    </tr>
  </xsl:template>
</xsl:stylesheet>
