########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/SCore/ServerImp.py,v 1.7 2004/10/07 08:27:58 mbrown Exp $
"""
Server repository resource class

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import XmlDocumentImp

from Ft.Server import FTSERVER_NAMESPACE
from Ft.Server.Common import ResourceTypes


class ServerImp(XmlDocumentImp.XmlDocumentImp):
    """
    A system server
    """
    resourceType = ResourceTypes.ResourceType.SERVER

    def getStatus(self):
        """
        Returns the state of this server: running (1) or stopped (0)
        based on the content of the resource. No check is made to see
        if a server process is running.
        """
        self._verifyTx()
        content = self.asDom()
        nss = {'ftss': FTSERVER_NAMESPACE}
        status = content.xpath('number(/ftss:Server/ftss:Status/@running)', explicitNss=nss)
        return int(status)


    def setRunning(self):
        """
        Change the state of this server to running
        """
        self._verifyTx()
        xu = UPDATE_STATE % (FTSERVER_NAMESPACE, '1')
        self._driver.xupdateContent(self._path, xu)
        return


    def setStopped(self):
        """
        Change the state of this server to stopped
        """
        self._verifyTx()
        xu = UPDATE_STATE % (FTSERVER_NAMESPACE, '0')
        self._driver.xupdateContent(self._path, xu)
        return


UPDATE_STATE="""<?xml version="1.0"?>
<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  xmlns:ftss="%s"
>
  <xupdate:remove select="/ftss:Server/ftss:Status"/>
  <xupdate:append select="/ftss:Server" child='last()'><ftss:Status running='%s'/></xupdate:append>
</xupdate:modifications>
"""


