


from Ft.Rdf.Parsers import Versa

import test_helper

def test_gt(tester,model):


    tester.startGroup("gt")
    nsMap = {'ft':'http://fourthought.com#',
             'foo':'http://foo.com#',
             'dc':'http://purl.org/dc/elements/1.1#',
             }


    con = Versa.CreateContext(model = model,
                              nsMapping = nsMap)

    exp = "all()[gt(.-ft:age->isLiteral(),17)]"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(2, len(res))
    tester.compareIn(res,"http://foo.com#jolson")
    tester.compareIn(res,"http://foo.com#molson")
    tester.testDone()


    exp = "all()[gt(.-ft:age->isLiteral(),45)]"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(0, len(res))
    tester.testDone()

    tester.groupDone()



def test_lt(tester,model):


    tester.startGroup("lt")
    nsMap = {'ft':'http://fourthought.com#',
             'foo':'http://foo.com#',
             'dc':'http://purl.org/dc/elements/1.1#',
             }


    con = Versa.CreateContext(model = model,
                              nsMapping = nsMap)

    exp = "all()[lt(.-ft:age->isLiteral(),45)]"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(2, len(res))
    tester.compareIn(res,"http://foo.com#jolson")
    tester.compareIn(res,"http://foo.com#molson")
    tester.testDone()


    exp = "all()[lt(.-ft:age->isLiteral(),17)]"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(0, len(res))
    tester.testDone()

    tester.groupDone()


def test_eq(tester,model):


    tester.startGroup("eq")
    nsMap = {'ft':'http://fourthought.com#',
             'foo':'http://foo.com#',
             'dc':'http://purl.org/dc/elements/1.1#',
             }


    con = Versa.CreateContext(model = model,
                              nsMapping = nsMap)

    exp = "all()[eq(.-dc:Title->isLiteral(),'Mike Olson')]"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(1, len(res))
    tester.compareIn(res,"http://foo.com#molson")
    tester.testDone()


    exp = "all()[eq(.-ft:age->isLiteral(),99)]"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(0, len(res))
    tester.testDone()

    tester.groupDone()




def Test(tester):
    model = test_helper.init(tester)
    test_gt(tester,model)
    test_lt(tester,model)
    test_eq(tester,model)


if __name__ == '__main__':
    from Ft.Lib.TestSuite import Tester
    tester = Tester.Tester()
    Test(tester)
