<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY bbschema "http://uche.ogbuji.net/example/buyerbase/schema#">
  <!ENTITY bb "http://uche.ogbuji.net/example/buyerbase">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:bbschema="&bbschema;"
  xmlns:bb="&bb;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time"
  exclude-result-prefixes="f frdf fhttp fcore fres exslt exslt-set exslt-math exslt-functions exslt-date-time dc bb rdf bbschema">


  <!--
File:  purchase.xslt

Description:

    This stylesheet renders information about a purchase.

    This stylesheet expects to be applied to a purchase XML document.

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
  -->

  <xsl:include href="menu-includes.xslt"/>

  <xsl:param name='fres:document-root'/>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="fcore:has-session()">
        <xsl:call-template name="menus">
          <xsl:with-param name="pageTitle" select="'Buyer Base - View Purchase'"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <fhttp:response-uri uri="/buyerbase/?xslt=home.xslt"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="body">
    <form name="main" method="post" action="{$fres:uri-path}?xslt=../submit-purchase.xslt">
      <input type="hidden" id="actionToDo" name="actionToDo" value="delete"/>
      <table width="695">
        <tr>
          <td colspan="2">
            <p class="blackTitle">
              <xsl:choose>
                <xsl:when test='fcore:has-session()'>
                  <xsl:variable name="customer-id" select="bb:purchase/bb:customer/@id"/>
                  <a href="/buyerbase/?xslt=index.xslt">
                    <font color="#000000">View Customer Index</font>
                  </a>
                  <xsl:text>&nbsp;|&nbsp;</xsl:text>
                  <a href="{substring-after($customer-id,$fres:document-root)}?xslt=../customer.xslt">
                    <font color="#000000">View Customer Profile</font>
                  </a>
                  <xsl:text>&nbsp;|&nbsp;</xsl:text>
                  <a href="{substring-after($customer-id,$fres:document-root)}?xslt=../new-purchase.xslt">
                    <font color="#000000">New Purchase</font>
                  </a>
                  <xsl:text>&nbsp;|&nbsp;</xsl:text>
                  <a href="/buyerbase/?xslt=logout.xslt">
                    <font color="#000000">Logout</font>
                  </a>
                </xsl:when>
                <xsl:otherwise>
                  <a href="/buyerbase/?xslt=home.xslt">
                    <font color="#000000">Login</font>
                  </a>
                </xsl:otherwise>
              </xsl:choose>
            </p>
          </td>
        </tr>
        <xsl:call-template name="display-customer"/>
        <xsl:apply-templates select="bb:purchase"/>
        <tr>
          <td colspan="2">
            <input name="delete-purchase" class="button" type="submit" tabindex="18" value="Delete Purchase" style="width: 130"/>
          </td>
        </tr>
      </table>
    </form>
  </xsl:template>

  <xsl:template name="display-customer">
    <tr class="cellBlue">
      <td class="menucell" colspan="2" align="left"><div class="menu">Customer</div></td>
    </tr>
    <tr>
      <td><div class="normal">Name: <xsl:value-of select='document(bb:purchase/bb:customer/@id)/bb:customer/bb:fullname'/></div></td>
      <td><div class="normal">Work Phone: <xsl:value-of select='document(bb:purchase/bb:customer/@id)/bb:customer/bb:phone[@desc="work"]'/></div></td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
    </tr>
  </xsl:template>

  <xsl:template match="bb:purchase">
    <xsl:variable name="currencySymbol" select="'$'"/>
    <tr class="cellBlue">
      <td class="menucell" colspan="2" align="left"><div class="menu">Purchase Order No. <xsl:value-of select='@id'/></div></td>
    </tr>
    <tr>
      <td valign="top" colspan="2">
        <table border="1" width="675" cellpadding="2" bgcolor="#FFFFFF" bordercolorlight="#C0C0C0" class="normal" align="center">
          <tr class="cellGray">
            <td class="th" align="center" width="80">No</td>
            <td class="th" align="center" width="220">Product</td>
            <td class="th" align="center" width="100">Qty</td>
            <td class="th" align="center" width="125">Unit Price</td>
            <td class="th" align="center" width="110">Total Price</td>
          </tr>
          <xsl:for-each select='bb:item'>
            <tr>
              <td align="center">
                <xsl:value-of select="substring-after(bb:product/@id,'#')"/>
              </td>
              <td align='left'>
                <xsl:value-of select='bb:product'/>
              </td>
              <td align='center'>
                <xsl:value-of select='bb:quantity'/>
              </td>
              <td align='right'>
                <xsl:value-of select="$currencySymbol"/>
                <xsl:value-of select="format-number(bb:unitprice,'#,##0.00')"/>
                <xsl:value-of select="'&nbsp;'"/>
              </td>
              <td align='right'>
                <xsl:value-of select="$currencySymbol"/>
                <xsl:value-of select="format-number(bb:unitprice * bb:quantity,'#,##0.00')"/>
                <xsl:value-of select="'&nbsp;'"/>
              </td>
            </tr>
          </xsl:for-each>

          <!-- grand total calculation -->
          <xsl:variable name="subtotals-rtf">
            <xsl:for-each select='bb:item'>
              <val>
                <xsl:value-of select="bb:unitprice * bb:quantity"/>
              </val>
            </xsl:for-each>
          </xsl:variable>
          <xsl:variable name="grand-total" select="sum(exslt:node-set($subtotals-rtf)/val)"/>
          <tr>
            <td colspan="4" align="right" class="cellGray">
              <b>Grand Total&nbsp;</b>
            </td>
            <td align="right" class="th">
              <b>
                <xsl:value-of select="$currencySymbol"/>
                <xsl:value-of select="format-number($grand-total,'#,##0.00')"/>
                <xsl:value-of select="'&nbsp;'"/>
              </b>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </xsl:template>

</xsl:stylesheet>
