########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/SCore/XsltDocumentDefinitionImp.py,v 1.11 2005/01/07 19:48:38 jkloth Exp $
"""
XsltDocumentDefinition repository resource class

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import DocumentDefinitionImp, XsltDocumentImp

from Ft.Server import FTSERVER_NAMESPACE
from Ft.Server.Common import ResourceTypes


class XsltDocumentDefinitionImp(DocumentDefinitionImp.DocumentDefinitionImp,
                                XsltDocumentImp.XsltDocumentImp):
    """
    An XSLT-based document definition document
    """
    resourceType = ResourceTypes.ResourceType.XSLT_DOCUMENT_DEFINITION

    def asStylesheet(self):
        return XsltDocumentImp.XsltDocumentImp.asStylesheet(self)

    def setContent(self, src):
        XsltDocumentImp.XsltDocumentImp.setContent(self, src)
        self._update()
        return

    def getExtFunctionsAndElements(self):
       #To support extension elements for XSLT docdefs
       f, e = XsltDocumentImp.XsltDocumentImp.getExtFunctionsAndElements(self)

       for module in self._driver._properties['XsltExtensionModule']:
           m = __import__(module, {}, {}, ['ExtFunctions', 'ExtElements'])
           f.update(getattr(m, 'ExtFunctions', {}))
           e.update(getattr(m, 'ExtElements', {}))
       return (f, e)

def NewDocumentDefinitionXml(driver, path, acl, owner, imt, src, docDef):
    return DocumentDefinitionImp.NewDocumentDefinitionXml(
        driver, path, acl, owner, imt, src, docDef,
        ResourceTypes.ResourceType.XSLT_DOCUMENT_DEFINITION
        )


NEW_SHEET_XUPDATE="""<?xml version="1.0"?>
<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  xmlns:ftss="%s"
>
  <xupdate:append select="/*" child="last()">
    <ftss:BaseNames/>
  </xupdate:append>
</xupdate:modifications>
""" % FTSERVER_NAMESPACE
