########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Commands/Login.py,v 1.1 2005/05/20 20:21:44 jkloth Exp $
"""
Implementation of '4ss_manager login' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import os
from Ft.Server.Common import ClAuthenticate
from Ft.Server.Server.Commands import CommandUtil

__doc__ = """This command will associate a username and password hash
in a password file on the local filesystem. Subsequent invocations of
4ss_manager command-line scripts can then automatically look up access
info for connecting to a repository. The location of the password file
is determined by the FTSS_PASSWORD_FILE environment variable. If not set,
then the location is assumed to be a file named '%s' in the directory
determined by the environment variable HOME (on Unix) or APPDATA
(on Windows 2000/XP), or the environment variable WINDIR (on Windows
9x/ME/NT). If the password file does not exist, it will be created
when the entry is stored. The location must be writable by the user invoking
the command. At this time, this command does NOT verify that the username,
password hash, hostname and port combination is valid; no repository
connection is made.""" % CommandUtil.PasswordManager.getFilename()

def Run(options, args):

    userName = args.get('username')
    if not userName:
        userName = ClAuthenticate.GetUserName('Default manager username: ')

    while True:
        password = ClAuthenticate.GetPass('Password for %s: ' % userName)
        password2 = ClAuthenticate.GetPass('Re-enter password to confirm: ')
        if password == password2:
            break
        else:
            sys.stderr.write('Passwords did not match. Please try again.\n')
            sys.stderr.flush()

    passwordHash = ClAuthenticate.HashPasswd(password)

    CommandUtil.PasswordManager.setLogin(userName, passwordHash)
    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('login',
                          'Save username and password for subsequent accesses',
                          '',
                          __doc__,
                          function = Run,
                          arguments = [Arguments.OptionalArgument('username',
                                                                  'User for which to set defaults',
                                                                  str),
                                       ],
                          fileName = __file__,
                          )
    return cmd
