########################################################################
#
# File Name:            ExtClasses.py
#
# Documentation:        http://docs.4suite.org/4Rdf/ExtClasses.py.html
#
"""
RDF ExtClasses
WWW: http://4suite.org/4RDF         e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


g_extensionPredicates = {}
g_extensionAsserts = {}
g_extensionActions = {}
g_extensionQueries = {}
g_extensionCommands = {}


import os, string
defMods = os.environ.get("RDF_EXTENSION_CLASSES","")
modNames = string.split(defMods,':')


for modName in modNames:
    if not modName:
        continue
    print "Import Module '%s' for extension" % modName
    m = __import__(modName)
    for subName in string.split(modName,'.')[1:]:
        m = getattr(m,subName)

    if hasattr(m,'g_extensionPredicates'):
        exts = getattr(m,'g_extensionPredicates')
        g_extensionPredicates.update(exts)
    if hasattr(m,'g_extensionActions'):
        exts = getattr(m,'g_extensionActions')
        g_extensionActions.update(exts)
    if hasattr(m,'g_extensionQueries'):
        exts = getattr(m,'g_extensionQueries')
        g_extensionQueries.update(exts)
    if hasattr(m,'g_extensionCommands'):
        exts = getattr(m,'g_extensionCommands')
        g_extensionCommands.update(exts)
